/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.eclipse.util;

import com.deltawalker.Msg;
import com.deltawalker.structure.SizeFilter;
import java.text.NumberFormat;
import org.eclipse.osgi.util.NLS;

public final class SizeFormatter {
    private static String BIND_STRING = Msg.SizeFormatter_bind;
    private static NumberFormat formatter = NumberFormat.getInstance();
    private static final String UNKNOWN_SIZE = "--";

    public static String format(long l) {
        return NLS.bind((String)BIND_STRING, (Object)formatter.format(l), (Object)((Object)SizeFilter.Unit.BYTES));
    }

    public static String format(long l, int n) {
        if (l < -1L) {
            throw new IllegalArgumentException("Resource size cannot be a negative number; size=" + l);
        }
        if (l == -1L) {
            return UNKNOWN_SIZE;
        }
        double d = l;
        formatter.setMaximumFractionDigits(n);
        if (l < SizeFilter.Unit.KBYTES.multiplier()) {
            return NLS.bind((String)BIND_STRING, (Object)formatter.format(d), (Object)((Object)SizeFilter.Unit.BYTES));
        }
        if (l < SizeFilter.Unit.MBYTES.multiplier()) {
            return NLS.bind((String)BIND_STRING, (Object)formatter.format(d / (double)SizeFilter.Unit.KBYTES.multiplier()), (Object)((Object)SizeFilter.Unit.KBYTES));
        }
        if (l < SizeFilter.Unit.GBYTES.multiplier()) {
            return NLS.bind((String)BIND_STRING, (Object)formatter.format(d / (double)SizeFilter.Unit.MBYTES.multiplier()), (Object)((Object)SizeFilter.Unit.MBYTES));
        }
        return NLS.bind((String)BIND_STRING, (Object)formatter.format(d / (double)SizeFilter.Unit.GBYTES.multiplier()), (Object)((Object)SizeFilter.Unit.GBYTES));
    }

    public static String formatLong(long l) {
        if (l == -1L) {
            return "Unknown size";
        }
        return SizeFormatter.format(l);
    }

    private SizeFormatter() {
    }
}

