/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.eclipse.util;

import com.deltawalker.internal.DeltaWalkerPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class Logger {
    private Plugin plugin;
    private String pluginId;

    public static void handleStatus(IStatus iStatus, String string, int n) {
        StatusManager.getManager().handle(Logger.newStatus(iStatus, string), n);
    }

    public static IStatus newStatus(IStatus iStatus, String string) {
        return new Status(iStatus.getSeverity(), iStatus.getPlugin(), iStatus.getCode(), string, iStatus.getException());
    }

    public Logger() {
        this((Plugin)DeltaWalkerPlugin.getDefault(), DeltaWalkerPlugin.getDefault().getId());
    }

    public Logger(Plugin plugin, String string) {
        this.plugin = plugin;
        this.pluginId = string;
    }

    public IStatus getStatus(Throwable throwable) {
        String string = "An unexpected exception was thrown.";
        if (throwable instanceof CoreException) {
            string = ((CoreException)throwable).getStatus().getMessage();
        }
        return this.newError(string, throwable);
    }

    public void log(IStatus iStatus) {
        this.plugin.getLog().log(iStatus);
    }

    public void log(String string) {
        this.plugin.getLog().log(this.newStatus(4, string, null));
    }

    public void log(Throwable throwable) {
        this.plugin.getLog().log(this.getStatus(throwable));
    }

    public void logErrorMessage(String string) {
        if (string == null) {
            string = "";
        }
        this.log((IStatus)new Status(4, this.pluginId, 4, string, null));
    }

    public void logErrorStatus(String string, IStatus iStatus) {
        if (iStatus == null) {
            this.logErrorMessage(string);
            return;
        }
        MultiStatus multiStatus = new MultiStatus(this.pluginId, iStatus.getCode(), string, null);
        multiStatus.add(iStatus);
        this.log((IStatus)multiStatus);
    }

    public IStatus newError(String string, Throwable throwable) {
        int n = 0;
        if (throwable instanceof CoreException) {
            CoreException coreException = (CoreException)throwable;
            this.pluginId = coreException.getStatus().getPlugin();
            n = coreException.getStatus().getCode();
        }
        return new Status(4, this.pluginId, n, string, StatusUtil.getCause((Throwable)throwable));
    }

    public IStatus newStatus(int n, String string, Throwable throwable) {
        String string2 = string;
        if (string == null || string.trim().length() == 0) {
            string2 = throwable.getMessage() == null ? throwable.toString() : throwable.getMessage();
        }
        return new Status(n, this.pluginId, n, string2, StatusUtil.getCause((Throwable)throwable));
    }
}

