/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.eclipse.util;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.slf4j.LoggerFactory;

public class FactoryInfo {
    private static final String CLASS = "class";
    private static final String CONTENT_TYPE = "contentType";
    private static final String ID = "id";
    private static final String NAME = "name";
    private final IConfigurationElement configElement;
    private final Pattern ctPattern;
    private Object factory;
    private final String id;
    private final String name;

    public FactoryInfo(IConfigurationElement iConfigurationElement) {
        this.configElement = iConfigurationElement;
        this.id = this.configElement.getAttribute(ID);
        this.name = this.configElement.getAttribute(NAME);
        this.ctPattern = this.createPattern(iConfigurationElement.getAttribute(CONTENT_TYPE));
    }

    protected IConfigurationElement configElement() {
        return this.configElement;
    }

    public Pattern contentTypePattern() {
        return this.ctPattern;
    }

    protected Pattern createPattern(String string) {
        return string == null ? null : Pattern.compile(string, 66);
    }

    public boolean factoryEquals(FactoryInfo factoryInfo) {
        IConfigurationElement iConfigurationElement = this.configElement();
        IConfigurationElement iConfigurationElement2 = factoryInfo.configElement();
        return iConfigurationElement.getAttribute(CLASS).equals(iConfigurationElement2.getAttribute(CLASS)) && iConfigurationElement.getContributor().equals(iConfigurationElement2.getContributor());
    }

    public Object getFactory() {
        if (this.factory == null) {
            try {
                this.factory = this.configElement.createExecutableExtension(CLASS);
            }
            catch (CoreException coreException) {
                assert (false);
                LoggerFactory.getLogger((String)"com.deltopia.FactoryInfo").error("Couldn't load factory", (Throwable)coreException);
            }
        }
        return this.factory;
    }

    public String id() {
        return this.id;
    }

    public String toString() {
        return this.name;
    }
}

