/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.eclipse.util;

import com.deltawalker.DocType;
import com.deltawalker.UriInfo;
import com.deltawalker.resources.IResource;
import com.deltawalker.resources.ResourceFactory;
import com.deltawalker.script.Role;
import com.deltopia.eclipse.util.FactoryInfo;
import com.deltopia.io.ContentType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryFinder {
    private static final Map<String, FactoryInfo[]> extPt2FacInfo = new HashMap<String, FactoryInfo[]>();
    private static final Logger LOG = LoggerFactory.getLogger(FactoryFinder.class);

    public static FactoryInfo[] findInfos(String string, Map<Role, UriInfo> map, Object[] objectArray, boolean bl) {
        ContentType contentType = ContentType.UNKNOWN;
        for (Map.Entry<Role, UriInfo> entry : map.entrySet()) {
            UriInfo uriInfo = entry.getValue();
            if (uriInfo.isEmpty()) continue;
            IResource iResource = null;
            contentType = uriInfo.contentType();
            try {
                iResource = ResourceFactory.staticCreateResource(uriInfo, false, bl);
                if (!uriInfo.uri().equals(iResource.getUri())) {
                    entry.setValue(uriInfo.cloneUpdateUri(iResource.getUri(), false));
                }
                if (contentType.isUnknown()) {
                    contentType = iResource.contentType();
                    entry.setValue(entry.getValue().cloneUpdateContentType(contentType));
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("content type: " + contentType + "     docType: " + (Object)((Object)DocType.fromJson(contentType.docTypeKey())));
                }
                if (objectArray == null || contentType.isArchive()) continue;
                objectArray[entry.getKey().toInt()] = iResource;
            }
            catch (Throwable throwable) {
                LOG.warn("Find infos failed:", throwable);
                entry.setValue(entry.getValue().cloneUpdateError(throwable));
            }
        }
        return FactoryFinder.getFactories(string, map);
    }

    public static FactoryInfo[] getFactories(String string, ContentType contentType) {
        if (string == null) {
            throw new NullPointerException("extPointId");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("extPointId is empty");
        }
        if (contentType == null) {
            throw new NullPointerException("cType");
        }
        FactoryInfo[] factoryInfoArray = FactoryFinder.getInfos(string);
        LinkedHashSet<FactoryInfo> linkedHashSet = new LinkedHashSet<FactoryInfo>();
        if (!contentType.isUnknown()) {
            FactoryInfo[] factoryInfoArray2 = factoryInfoArray;
            int n = factoryInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                FactoryInfo factoryInfo = factoryInfoArray2[n2];
                if (FactoryFinder.matches(factoryInfo, contentType)) {
                    linkedHashSet.add(factoryInfo);
                }
                ++n2;
            }
        }
        return linkedHashSet.toArray(new FactoryInfo[linkedHashSet.size()]);
    }

    public static FactoryInfo[] getFactories(String string, Map<Role, UriInfo> map) {
        FactoryInfo[] factoryInfoArray = FactoryFinder.getInfos(string);
        LinkedHashSet<FactoryInfo> linkedHashSet = new LinkedHashSet<FactoryInfo>();
        FactoryInfo[] factoryInfoArray2 = factoryInfoArray;
        int n = factoryInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            FactoryInfo factoryInfo = factoryInfoArray2[n2];
            for (UriInfo uriInfo : map.values()) {
                ContentType contentType = uriInfo.contentType();
                if (contentType.isUnknown() || !FactoryFinder.matches(factoryInfo, contentType)) continue;
                linkedHashSet.add(factoryInfo);
            }
            ++n2;
        }
        return linkedHashSet.toArray(new FactoryInfo[linkedHashSet.size()]);
    }

    public static Object[] getFactories(String string, Map<Role, UriInfo> map, Object[] objectArray, boolean bl) {
        FactoryInfo[] factoryInfoArray = FactoryFinder.findInfos(string, map, objectArray, bl);
        int n = factoryInfoArray.length;
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray2[n2] = factoryInfoArray[n2].getFactory();
            ++n2;
        }
        return objectArray2;
    }

    public static Object getFactory(String string, String string2) {
        FactoryInfo[] factoryInfoArray;
        FactoryInfo[] factoryInfoArray2 = factoryInfoArray = FactoryFinder.getInfos(string);
        int n = factoryInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            FactoryInfo factoryInfo = factoryInfoArray2[n2];
            if (string2.equals(factoryInfo.id())) {
                return factoryInfo.getFactory();
            }
            ++n2;
        }
        return null;
    }

    public static FactoryInfo[] getInfos(String string) {
        FactoryInfo[] factoryInfoArray = extPt2FacInfo.get(string);
        if (factoryInfoArray == null && (factoryInfoArray = FactoryFinder.loadInfos(string, FactoryInfo.class)).length > 0) {
            extPt2FacInfo.put(string, factoryInfoArray);
        }
        return (FactoryInfo[])factoryInfoArray.clone();
    }

    public static FactoryInfo[] loadInfos(String string, Class clazz) {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string);
        int n = iConfigurationElementArray.length;
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(IConfigurationElement.class);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        Object object = Array.newInstance(clazz, n);
        int n2 = 0;
        while (n2 < n) {
            Object var7_7 = null;
            try {
                if (constructor != null) {
                    var7_7 = constructor.newInstance(iConfigurationElementArray[n2]);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
            Array.set(object, n2, var7_7);
            ++n2;
        }
        return (FactoryInfo[])object;
    }

    private static boolean matches(FactoryInfo factoryInfo, ContentType contentType) {
        Pattern pattern = factoryInfo.contentTypePattern();
        return pattern != null && pattern.matcher(contentType.toString()).matches();
    }
}

