/*
 * Decompiled with CFR 0.152.
 */
package com.deltopia.eclipse.util;

import com.deltopia.io.FileInfo;
import com.deltopia.util.OS;
import java.util.HashMap;
import java.util.Map;

public final class AttributesFormatter {
    private static Map<Integer, String> int2String = new HashMap<Integer, String>();

    public static synchronized String format(int n, boolean bl) {
        String string = int2String.get(n);
        if (string != null) {
            return bl ? String.valueOf(string) + '@' : string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (OS.WIN) {
            stringBuilder.append(!FileInfo.hasPermission((int)n, (int)131072) ? (char)'R' : '-');
            stringBuilder.append(FileInfo.isSet((int)n, (int)32) ? (char)'H' : '-');
            stringBuilder.append(FileInfo.isSet((int)n, (int)128) ? (char)'S' : '-');
            stringBuilder.append(FileInfo.isSet((int)n, (int)256) ? (char)'A' : '-');
        } else {
            if (FileInfo.isSet((int)n, (int)64)) {
                stringBuilder.append('l');
            } else {
                stringBuilder.append(FileInfo.isSet((int)n, (int)1) ? (char)'d' : '-');
            }
            stringBuilder.append(FileInfo.hasPermission((int)n, (int)65536) ? (char)'r' : '-');
            stringBuilder.append(FileInfo.hasPermission((int)n, (int)131072) ? (char)'w' : '-');
            stringBuilder.append(FileInfo.hasPermission((int)n, (int)262144) ? (char)'x' : '-');
            stringBuilder.append(FileInfo.hasPermission((int)n, (int)524288) ? (char)'r' : '-');
            stringBuilder.append(FileInfo.hasPermission((int)n, (int)0x100000) ? (char)'w' : '-');
            stringBuilder.append(FileInfo.hasPermission((int)n, (int)0x200000) ? (char)'x' : '-');
            stringBuilder.append(FileInfo.hasPermission((int)n, (int)0x400000) ? (char)'r' : '-');
            stringBuilder.append(FileInfo.hasPermission((int)n, (int)0x800000) ? (char)'w' : '-');
            stringBuilder.append(FileInfo.hasPermission((int)n, (int)0x1000000) ? (char)'x' : '-');
        }
        string = stringBuilder.toString();
        int2String.put(n, string);
        return string;
    }

    private AttributesFormatter() {
    }
}

