/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.printing;

import com.deltawalker.App;
import com.deltawalker.script.MarginUnit;
import com.deltawalker.ui.printing.IPrinter;
import com.deltawalker.ui.printing.PageSetup;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public final class PrinterUtil {
    public static float getInches(float f, MarginUnit marginUnit) {
        return marginUnit == MarginUnit.INCH ? f : f / 2.54f;
    }

    public static Rectangle getPrintableArea(IPrinter iPrinter) {
        return PrinterUtil.getPrintableArea(iPrinter.getDeviceDPI(), iPrinter.getDeviceBounds(), iPrinter.getDeviceClientArea());
    }

    public static Rectangle getPrintableArea(Point point, Rectangle rectangle, Rectangle rectangle2) {
        PageSetup pageSetup = App.instance().printBoss().getPageSetup();
        MarginUnit marginUnit = pageSetup.getMarginUnits();
        int n = Math.round(PrinterUtil.getInches(pageSetup.getMarginTop(), marginUnit) * (float)point.y);
        int n2 = Math.round(PrinterUtil.getInches(pageSetup.getMarginLeft(), marginUnit) * (float)point.x);
        int n3 = Math.round(PrinterUtil.getInches(pageSetup.getMarginBottom(), marginUnit) * (float)point.y);
        int n4 = Math.round(PrinterUtil.getInches(pageSetup.getMarginRight(), marginUnit) * (float)point.x);
        rectangle.x += n2;
        rectangle.y += n;
        rectangle.width -= n2 + n4;
        rectangle.height -= n + n3;
        return rectangle2.intersection(rectangle);
    }

    private PrinterUtil() {
    }
}

