/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.printing;

import com.deltawalker.App;
import com.deltawalker.ui.printing.IPrinter;
import com.deltawalker.ui.printing.IPrinterGC;
import com.deltawalker.ui.printing.PageSetup;
import com.deltawalker.ui.printing.PrinterGC;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;

public class PrinterPrinter
implements IPrinter {
    private IPrinterGC gc;
    private final PageSetup pageSetup;
    private final Printer printer;

    public PrinterPrinter() {
        this(new PageSetup(false));
    }

    public PrinterPrinter(PageSetup pageSetup) {
        if (pageSetup == null) {
            throw new NullPointerException("pageSetup");
        }
        this.pageSetup = pageSetup;
        this.printer = new Printer(App.instance().printBoss().getPrinterData(false));
    }

    @Override
    public void dispose() {
        if (this.gc != null) {
            this.gc.dispose();
            this.gc = null;
        }
        this.printer.dispose();
    }

    @Override
    public void endJob() {
        this.printer.endJob();
    }

    @Override
    public void endPage() {
        if (this.gc != null) {
            this.gc.dispose();
            this.gc = null;
        }
        this.printer.endPage();
    }

    @Override
    public Device getDevice() {
        return this.printer;
    }

    @Override
    public Rectangle getDeviceBounds() {
        return this.printer.getBounds();
    }

    @Override
    public Rectangle getDeviceClientArea() {
        return this.printer.getClientArea();
    }

    @Override
    public Point getDeviceDPI() {
        return this.printer.getDPI();
    }

    public PageSetup getPageSetup() {
        return this.pageSetup;
    }

    @Override
    public boolean startJob(String string) {
        return this.printer.startJob(string);
    }

    @Override
    public IPrinterGC startPage() {
        if (this.gc != null) {
            throw new IllegalStateException("PrintPrinter#startPage() has already been called. To call it again, you must call PrintPrinter#endPage() first.");
        }
        this.gc = this.printer.startPage() ? new PrinterGC((Drawable)this.printer) : null;
        return this.gc;
    }
}

