/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.printing;

import com.deltawalker.Msg;
import com.deltawalker.internal.ContextId;
import com.deltawalker.ui.ButtonFactory;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.printing.IPreviewPrinterListener;
import com.deltawalker.ui.printing.IPrintable;
import com.deltawalker.ui.printing.PageSetup;
import com.deltawalker.ui.printing.PreviewPrinterComposite;
import com.deltopia.ui.swt.ProgressMonitorProxy;
import com.deltopia.util.OS;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class PrintPreviewWindow
extends Window {
    public static final int CLOSE_ID = 256;
    public static final int NEXT_PAGE_ID = 16;
    public static final int PAGE_SETUP_ID = 2;
    public static final int PREVIOUS_PAGE_ID = 32;
    public static final int PRINT_ID = 4;
    public static final int PRINT_PREVIEW_ID = 8;
    public static final float[] ZOOM_FACTORS = new float[]{0.5f, 1.0f, 2.0f};
    public static final int ZOOM_IN_ID = 64;
    public static final int ZOOM_OUT_ID = 128;
    private Button btnClose;
    private Button btnNextPage;
    private Button btnPageSetup;
    private Button btnPreviousPage;
    private Button btnPrint;
    private Button btnZoomIn;
    private Button btnZoomOut;
    private final ButtonFactory buttonFactory = new ButtonFactory(){

        @Override
        protected IAction createButtonAction(int n) {
            return PrintPreviewWindow.this.createButtonAction(n);
        }
    };
    private Composite cmpButtonBar;
    private PreviewPrinterComposite cmpPreview;
    private final Listener listener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 1: {
                    PrintPreviewWindow.this.handleKeyDown(event);
                    break;
                }
                case 37: {
                    PrintPreviewWindow.this.handleMouseWheel(event);
                    break;
                }
                case 13: {
                    if (!(event.widget instanceof Button)) break;
                    PrintPreviewWindow.this.handleButtonSelection(event);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("event");
                }
            }
        }
    };
    private PageSetup pageSetup;
    private final Shell[] parents;
    private boolean previewing = false;
    private final IPrintable printable;
    private final StatusLineManager statusLine = new StatusLineManager();
    private Control[] tabList;
    private boolean zoomToFitOnResize = true;

    private static Shell[] getParentShells(Shell shell) {
        ArrayList<Shell> arrayList = new ArrayList<Shell>();
        while (shell != null) {
            arrayList.add(0, shell);
            shell = (Shell)shell.getParent();
        }
        return arrayList.toArray(new Shell[arrayList.size()]);
    }

    public PrintPreviewWindow(Shell shell, IPrintable iPrintable) {
        super(null);
        if (iPrintable == null) {
            throw new NullPointerException("printable");
        }
        this.parents = PrintPreviewWindow.getParentShells(shell);
        this.printable = iPrintable;
        this.setBlockOnOpen(true);
    }

    public void beginPreviewPrinting() {
        if (this.isPreviewing()) {
            return;
        }
        ProgressMonitorProxy progressMonitorProxy = new ProgressMonitorProxy((Control)this.cmpPreview, this.statusLine.getProgressMonitor());
        new Thread(new Runnable((IProgressMonitor)progressMonitorProxy){
            private final /* synthetic */ IProgressMonitor val$pm;
            {
                this.val$pm = iProgressMonitor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PrintPreviewWindow printPreviewWindow = PrintPreviewWindow.this;
                synchronized (printPreviewWindow) {
                    if (PrintPreviewWindow.this.isPreviewing()) {
                        return;
                    }
                    PrintPreviewWindow.this.setPreviewing(true);
                }
                try {
                    if (PrintPreviewWindow.this.cmpPreview != null && !PrintPreviewWindow.this.cmpPreview.isDisposed()) {
                        PrintPreviewWindow.this.printable.print(PrintPreviewWindow.this.cmpPreview, this.val$pm);
                    }
                }
                finally {
                    PrintPreviewWindow.this.setPreviewing(false);
                }
            }
        }).start();
    }

    public boolean canZoomIn() {
        if (this.cmpPreview != null) {
            float f = this.cmpPreview.getZoomFactor();
            int n = 0;
            while (n < ZOOM_FACTORS.length) {
                if (f < ZOOM_FACTORS[n]) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean canZoomOut() {
        if (this.cmpPreview != null) {
            float f = this.cmpPreview.getZoomFactor();
            int n = ZOOM_FACTORS.length - 1;
            while (n >= 0) {
                if (ZOOM_FACTORS[n] < f) {
                    return true;
                }
                --n;
            }
        }
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, ContextId.PRINT_PREVIEW_DIALOG);
        this.setShellStyle(this.getShellStyle() & 0xFFFFFFBF);
        int n = this.parents.length;
        if (n > 0) {
            shell.setText(this.parents[n - 1].getText());
        }
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        Button button = this.buttonFactory.createButton(composite, n, string, bl);
        if (button != null) {
            button.addListener(1, this.listener);
            button.addListener(37, this.listener);
            button.addListener(13, this.listener);
        }
        return button;
    }

    protected IAction createButtonAction(int n) {
        return null;
    }

    protected Composite createButtonBar(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 0;
        final Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createButtonsForButtonBar(composite2);
        if (OS.OSX) {
            composite2.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent traverseEvent) {
                    switch (traverseEvent.detail) {
                        case 16: {
                            Control control = PrintPreviewWindow.this.getNextControlInTabOrder(composite2, true);
                            if (control == null) break;
                            control.setFocus();
                            composite2.getShell().setDefaultButton((Button)control);
                            traverseEvent.doit = true;
                            traverseEvent.detail = 0;
                            break;
                        }
                        case 8: {
                            Control control = PrintPreviewWindow.this.getNextControlInTabOrder(composite2, false);
                            if (control == null) break;
                            control.setFocus();
                            traverseEvent.doit = true;
                            traverseEvent.detail = 0;
                        }
                    }
                }
            });
        }
        this.btnPrint.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                switch (traverseEvent.detail) {
                    case 8: {
                        PrintPreviewWindow.this.btnClose.setFocus();
                        traverseEvent.doit = true;
                        traverseEvent.detail = 0;
                    }
                }
            }
        });
        this.btnClose.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                switch (traverseEvent.detail) {
                    case 16: {
                        PrintPreviewWindow.this.btnPrint.setFocus();
                        traverseEvent.doit = true;
                        traverseEvent.detail = 0;
                    }
                }
            }
        });
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.btnPrint = this.createButton(composite, 4, Msg.Common_print, false);
        this.btnPageSetup = this.createButton(composite, 2, String.valueOf(Msg.Common_pageSetup) + "...", false);
        this.btnNextPage = this.createButton(composite, 16, UIMsg.PrintPreviewWindow_nextPage, false);
        this.btnPreviousPage = this.createButton(composite, 32, UIMsg.PrintPreviewWindow_previousPage, false);
        this.btnZoomIn = this.createButton(composite, 64, UIMsg.PrintPreviewWindow_zoomIn, true);
        this.btnZoomOut = this.createButton(composite, 128, UIMsg.PrintPreviewWindow_zoomOut, false);
        this.btnClose = this.createButton(composite, 256, UIMsg.PrintPreviewWindow_close, false);
        if (this.btnClose != null) {
            this.btnClose.setEnabled(true);
        }
    }

    protected Control createContents(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        Composite composite2 = (Composite)super.createContents(composite);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.cmpButtonBar = this.createButtonBar(composite2);
        this.createPreviewComposite(composite2);
        if (this.cmpButtonBar != null) {
            this.cmpButtonBar.addListener(1, this.listener);
            this.cmpButtonBar.addListener(37, this.listener);
        }
        this.cmpPreview.addListener(1, this.listener);
        Control control = this.statusLine.createControl((Composite)composite2.getShell());
        control.setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        this.beginPreviewPrinting();
        return composite2;
    }

    protected Control createPreviewComposite(Composite composite) {
        this.cmpPreview = new PreviewPrinterComposite(composite, 2048, this.pageSetup);
        this.cmpPreview.setLayoutData(new GridData(4, 4, true, true));
        this.cmpPreview.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (PrintPreviewWindow.this.zoomToFitOnResize) {
                    PrintPreviewWindow.this.cmpPreview.zoomToFit();
                }
            }
        });
        this.cmpPreview.addPreviewPrinterListener(new IPreviewPrinterListener(){

            @Override
            public void pageEnded(PreviewPrinterComposite previewPrinterComposite) {
                PrintPreviewWindow.this.updatePreviewPrintingWidgets();
            }

            @Override
            public void pageIndexChanged(PreviewPrinterComposite previewPrinterComposite) {
                PrintPreviewWindow.this.updatePreviewPrintingWidgets();
            }
        });
        return this.cmpPreview;
    }

    protected Point getInitialLocation(Point point) {
        return this.parents.length > 0 ? this.parents[0].getLocation() : super.getInitialLocation(point);
    }

    protected Point getInitialSize() {
        return this.parents.length > 0 ? this.parents[0].getSize() : super.getInitialSize();
    }

    public Control getNextControlInTabOrder(Composite composite, boolean bl) {
        if (composite == null) {
            throw new NullPointerException("buttonBar");
        }
        if (this.tabList == null) {
            this.tabList = composite.getTabList();
        }
        Control control = null;
        Shell shell = composite.getShell();
        int n = 0;
        while (n < this.tabList.length) {
            if (shell.getDefaultButton() == this.tabList[n] || this.tabList[n].isFocusControl()) {
                control = this.tabList[n];
                break;
            }
            ++n;
        }
        if (control == null) {
            return null;
        }
        if (bl) {
            return this.tabList[n == this.tabList.length - 1 ? 0 : ++n];
        }
        return this.tabList[n == 0 ? this.tabList.length - 1 : --n];
    }

    protected ShellListener getShellListener() {
        final ShellListener shellListener = super.getShellListener();
        return new ShellListener(){

            public void shellActivated(ShellEvent shellEvent) {
                shellListener.shellActivated(shellEvent);
                int n = PrintPreviewWindow.this.parents.length - 1;
                while (n >= 0) {
                    Shell shell = PrintPreviewWindow.this.parents[n];
                    if (!shell.isDisposed()) {
                        Shell shell2;
                        if (n == 0 && !(shell2 = (Shell)shellEvent.widget).isDisposed()) {
                            shell2.setMaximized(shell.getMaximized());
                        }
                        if (shell.isVisible()) {
                            shell.setVisible(false);
                        }
                    }
                    --n;
                }
            }

            public void shellClosed(ShellEvent shellEvent) {
                Shell shell = (Shell)shellEvent.widget;
                if (!shell.isDisposed()) {
                    shellListener.shellClosed(shellEvent);
                }
            }

            public void shellDeactivated(ShellEvent shellEvent) {
                shellListener.shellDeactivated(shellEvent);
            }

            public void shellDeiconified(ShellEvent shellEvent) {
                shellListener.shellDeiconified(shellEvent);
            }

            public void shellIconified(ShellEvent shellEvent) {
                shellListener.shellIconified(shellEvent);
            }
        };
    }

    protected void handleButtonSelection(Event event) {
        Button button = (Button)event.widget;
        int n = this.buttonFactory.getButtonId(button);
        switch (n) {
            case 256: {
                this.getShell().close();
                return;
            }
            case 16: 
            case 32: {
                if (this.cmpPreview == null) break;
                if (n == 16) {
                    this.cmpPreview.gotoNextPage();
                    break;
                }
                this.cmpPreview.gotoPreviousPage();
                break;
            }
            case 2: 
            case 4: {
                IAction iAction = this.buttonFactory.getButtonAction(button);
                if (n == 4) {
                    this.getShell().close();
                }
                if (iAction == null || !iAction.isEnabled()) break;
                iAction.run();
                break;
            }
            case 64: 
            case 128: {
                if (n == 64) {
                    this.zoomIn();
                } else {
                    this.zoomOut();
                }
                this.updateZoomFactorButtons();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected void handleKeyDown(Event event) {
        if ((event.stateMask & SWT.MOD1) != 0) {
            int n;
            if (this.cmpPreview != null && (n = this.cmpPreview.getPageCount()) > 0) {
                if (event.keyCode == 0x1000007) {
                    this.cmpPreview.setPageIndex(0);
                } else if (event.keyCode == 0x1000008) {
                    this.cmpPreview.setPageIndex(n - 1);
                }
            }
        } else if (event.stateMask == 0) {
            if (event.keyCode == 0x1000005) {
                this.btnPreviousPage.notifyListeners(13, null);
            } else if (event.keyCode == 0x1000006) {
                this.btnNextPage.notifyListeners(13, null);
            }
        }
    }

    protected void handleMouseWheel(Event event) {
        if (event.widget != this.cmpPreview) {
            this.cmpPreview.notifyListeners(37, event);
        }
    }

    private void handlePreviewPrintingChanged() {
        if (this.cmpPreview == null || this.cmpPreview.isDisposed()) {
            return;
        }
        Display display = this.cmpPreview.getDisplay();
        if (!Thread.currentThread().equals(display.getThread())) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    PrintPreviewWindow.this.handlePreviewPrintingChanged();
                }
            });
            return;
        }
        if (this.isPreviewing()) {
            if (!this.statusLine.isCancelEnabled()) {
                this.statusLine.setCancelEnabled(true);
            }
        } else {
            this.statusLine.getProgressMonitor().done();
        }
        this.updatePreviewPrintingWidgets();
    }

    protected void handleShellCloseEvent() {
        if (!this.isPreviewing()) {
            int n = 0;
            while (n < this.parents.length) {
                Shell shell = this.parents[n];
                if (!shell.isDisposed()) {
                    if (n == 0) {
                        Shell shell2 = this.getShell();
                        boolean bl = shell2.getMaximized();
                        if (!bl) {
                            shell.setBounds(shell2.getBounds());
                        }
                        shell.setMaximized(bl);
                    }
                    shell.setVisible(true);
                    shell.layout();
                }
                ++n;
            }
            super.handleShellCloseEvent();
        } else {
            this.statusLine.setMessage(UIMsg.PrintPreviewWindow_printInProgress);
            this.cmpPreview.getDisplay().beep();
        }
    }

    private synchronized boolean isPreviewing() {
        return this.previewing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setPreviewing(boolean bl) {
        boolean bl2 = false;
        PrintPreviewWindow printPreviewWindow = this;
        synchronized (printPreviewWindow) {
            if (this.previewing != bl) {
                this.previewing = bl;
                bl2 = true;
            }
        }
        if (bl2) {
            this.handlePreviewPrintingChanged();
        }
    }

    private void updatePageIndexWidgets() {
        if (this.btnNextPage != null) {
            this.btnNextPage.setEnabled(this.cmpPreview != null && this.cmpPreview.hasNextPage());
        }
        if (this.btnPreviousPage != null) {
            this.btnPreviousPage.setEnabled(this.cmpPreview != null && this.cmpPreview.hasPreviousPage());
        }
        if (!this.isPreviewing()) {
            int n;
            String string = null;
            if (this.cmpPreview != null && (n = this.cmpPreview.getPageCount()) > 0) {
                string = NLS.bind((String)Msg.Common_pageNumberOf, (Object)Integer.toString(this.cmpPreview.getPageIndex() + 1), (Object)Integer.toString(n));
            }
            this.statusLine.setMessage(string);
        }
    }

    private void updatePreviewPrintingWidgets() {
        Button[] buttonArray = new Button[]{this.btnPrint, this.btnPageSetup, this.btnClose};
        boolean bl = !this.isPreviewing();
        Button[] buttonArray2 = buttonArray;
        int n = buttonArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray2[n2];
            if (button != null && !button.isDisposed()) {
                IAction iAction = this.buttonFactory.getButtonAction(button);
                button.setEnabled(bl && (button == this.btnClose || iAction != null && iAction.isEnabled()));
            }
            ++n2;
        }
        this.updatePageIndexWidgets();
        this.updateZoomFactorButtons();
    }

    private void updateZoomFactorButtons() {
        if (this.btnZoomIn != null) {
            this.btnZoomIn.setEnabled(this.canZoomIn());
        }
        if (this.btnZoomOut != null) {
            this.btnZoomOut.setEnabled(this.canZoomOut());
        }
    }

    public void zoomIn() {
        if (this.cmpPreview != null) {
            float f = this.cmpPreview.getZoomFactor();
            int n = 0;
            while (n < ZOOM_FACTORS.length) {
                float f2 = ZOOM_FACTORS[n];
                if (f < f2) {
                    this.cmpPreview.setZoomFactor(f2);
                    this.zoomToFitOnResize = false;
                    break;
                }
                ++n;
            }
        }
    }

    public void zoomOut() {
        if (this.cmpPreview != null) {
            float f = this.cmpPreview.getZoomFactor();
            int n = ZOOM_FACTORS.length - 1;
            while (n >= 0) {
                float f2 = ZOOM_FACTORS[n];
                if (f2 < f) {
                    this.cmpPreview.setZoomFactor(f2);
                    this.zoomToFitOnResize = false;
                    break;
                }
                --n;
            }
        }
    }
}

