/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.printing;

import com.deltawalker.App;
import com.deltawalker.interfaces.IPrintBoss;
import com.deltawalker.internal.ui.printing.IDeferredDrawable;
import com.deltawalker.internal.ui.printing.PreviewPrinterGC;
import com.deltawalker.internal.ui.printing.PreviewPrinterLayout;
import com.deltawalker.internal.ui.printing.PreviewPrinterPage;
import com.deltawalker.internal.ui.printing.UIPrinterAdapter;
import com.deltawalker.ui.printing.IPreviewPrinterListener;
import com.deltawalker.ui.printing.IPrinter;
import com.deltawalker.ui.printing.IPrinterGC;
import com.deltawalker.ui.printing.PageSetup;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.PreviewPrinterDevice;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public class PreviewPrinterComposite
extends Composite
implements IPrinter {
    private static final int PAGE_ENDED = 1;
    private static final int PAGE_INDEX_CHANGED = 2;
    private static final int SHADOW_WIDTH = 2;
    private PreviewPrinterDevice device;
    private int listenerCount;
    private Object[] listeners;
    private final int marginHeight;
    private final int marginWidth;
    private PreviewPrinterPage page;
    private int pageCount;
    private int pageIndex = -1;
    private IDeferredDrawable[] pages = new IDeferredDrawable[16];
    private Control ctlShadowBottom;
    private Control ctlShadowRight;
    private final IPrinter uiPrinter;
    private float zoomFactor = 1.0f;
    private IPrintBoss printBoss = App.instance().printBoss();

    public PreviewPrinterComposite(Composite composite, int n) {
        this(composite, n, new PageSetup(false));
    }

    public PreviewPrinterComposite(Composite composite, int n, PageSetup pageSetup) {
        super(composite, n | 0x100 | 0x200);
        this.setBackground(this.getDisplay().getSystemColor(18));
        this.device = new PreviewPrinterDevice((Widget)this, this.printBoss.getPrinterData(false));
        this.createControls();
        Display display = this.getDisplay();
        this.marginWidth = Math.round(0.35f * (float)display.getDPI().x / 2.54f);
        this.marginHeight = Math.round(0.35f * (float)display.getDPI().y / 2.54f);
        this.setLayout(new PreviewPrinterLayout());
        this.hookScrollBarSelection();
        this.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                PreviewPrinterComposite.this.handleMouseWheel(event);
            }
        });
        IPrinter iPrinter = this.createPrinter();
        this.uiPrinter = iPrinter == null || iPrinter == this ? iPrinter : new UIPrinterAdapter(this.getDisplay(), iPrinter);
    }

    public void addPreviewPrinterListener(IPreviewPrinterListener iPreviewPrinterListener) {
        if (iPreviewPrinterListener != null) {
            int n = 0;
            while (n < this.listenerCount) {
                if (iPreviewPrinterListener.equals(this.listeners[n])) {
                    return;
                }
                ++n;
            }
            if (this.listeners == null) {
                this.listeners = new Object[16];
            } else if (this.listeners.length == this.listenerCount) {
                Object[] objectArray = new Object[2 * this.listeners.length];
                System.arraycopy(this.listeners, 0, objectArray, 0, this.listeners.length);
                this.listeners = objectArray;
            }
            this.listeners[this.listenerCount++] = iPreviewPrinterListener;
        }
    }

    private void createControls() {
        Color color = this.getDisplay().getSystemColor(17);
        this.ctlShadowRight = new Label((Composite)this, 0);
        this.ctlShadowRight.setBackground(color);
        this.ctlShadowRight.setVisible(false);
        this.ctlShadowBottom = new Label((Composite)this, 0);
        this.ctlShadowBottom.setBackground(color);
        this.ctlShadowBottom.setVisible(false);
        this.page = new PreviewPrinterPage(this, 0){

            public void setVisible(boolean bl) {
                super.setVisible(bl);
                PreviewPrinterComposite.this.ctlShadowRight.setVisible(bl);
                PreviewPrinterComposite.this.ctlShadowBottom.setVisible(bl);
            }
        };
        this.page.setVisible(false);
        this.page.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
                this.controlResized(controlEvent);
            }

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = PreviewPrinterComposite.this.page.getBounds();
                PreviewPrinterComposite.this.ctlShadowRight.setBounds(rectangle.x + rectangle.width, rectangle.y + 2, 2, rectangle.height);
                PreviewPrinterComposite.this.ctlShadowBottom.setBounds(rectangle.x + 2, rectangle.y + rectangle.height, rectangle.width, 2);
            }
        });
        this.setTabList(new Control[]{this.page});
    }

    protected IPrinter createPrinter() {
        return new IPrinter(){
            private PreviewPrinterGC gc;

            @Override
            public void dispose() {
                PreviewPrinterComposite.this.internalDispose();
            }

            @Override
            public void endJob() {
                PreviewPrinterComposite.this.layout();
            }

            @Override
            public void endPage() {
                if (this.gc == null) {
                    return;
                }
                IDeferredDrawable iDeferredDrawable = this.gc.getDeferredDrawable();
                this.gc.dispose();
                this.gc = null;
                if (iDeferredDrawable != null) {
                    if (PreviewPrinterComposite.this.pages.length == PreviewPrinterComposite.this.pageCount) {
                        IDeferredDrawable[] iDeferredDrawableArray = new IDeferredDrawable[2 * PreviewPrinterComposite.this.pages.length];
                        System.arraycopy(PreviewPrinterComposite.this.pages, 0, iDeferredDrawableArray, 0, PreviewPrinterComposite.this.pages.length);
                        PreviewPrinterComposite.this.pages = iDeferredDrawableArray;
                    }
                    IDeferredDrawable[] iDeferredDrawableArray = PreviewPrinterComposite.this.pages;
                    PreviewPrinterComposite previewPrinterComposite = PreviewPrinterComposite.this;
                    int n = previewPrinterComposite.pageCount;
                    previewPrinterComposite.pageCount = n + 1;
                    iDeferredDrawableArray[n] = iDeferredDrawable;
                }
                PreviewPrinterComposite.this.firePreviewPrinterEvent(1);
            }

            @Override
            public Device getDevice() {
                return PreviewPrinterComposite.this.device;
            }

            @Override
            public Rectangle getDeviceBounds() {
                return PreviewPrinterComposite.this.device.getBounds();
            }

            @Override
            public Rectangle getDeviceClientArea() {
                return PreviewPrinterComposite.this.device.getClientArea();
            }

            @Override
            public Point getDeviceDPI() {
                return PreviewPrinterComposite.this.device.getDPI();
            }

            @Override
            public boolean startJob(String string) {
                int n = PreviewPrinterComposite.this.pageCount;
                PreviewPrinterComposite.this.pageCount = 0;
                PreviewPrinterComposite.this.setPageIndex(-1);
                int n2 = n - 1;
                while (n2 >= 0) {
                    ((PreviewPrinterComposite)PreviewPrinterComposite.this).pages[n2] = null;
                    --n2;
                }
                return true;
            }

            @Override
            public IPrinterGC startPage() {
                if (this.gc != null) {
                    return null;
                }
                Rectangle rectangle = PreviewPrinterComposite.this.device.getBounds();
                this.gc = new PreviewPrinterGC((Device)PreviewPrinterComposite.this.getDisplay(), rectangle.width, rectangle.height);
                return this.gc;
            }
        };
    }

    @Override
    public void dispose() {
        this.uiPrinter.dispose();
    }

    @Override
    public void endJob() {
        this.uiPrinter.endJob();
    }

    @Override
    public void endPage() {
        this.uiPrinter.endPage();
    }

    private void firePreviewPrinterEvent(final int n) {
        final IPreviewPrinterListener[] iPreviewPrinterListenerArray = new IPreviewPrinterListener[1];
        ISafeRunnable iSafeRunnable = new ISafeRunnable(){

            public void handleException(Throwable throwable) {
            }

            public void run() throws Exception {
                switch (n) {
                    case 1: {
                        iPreviewPrinterListenerArray[0].pageEnded(PreviewPrinterComposite.this);
                        break;
                    }
                    case 2: {
                        iPreviewPrinterListenerArray[0].pageIndexChanged(PreviewPrinterComposite.this);
                    }
                }
            }
        };
        int n2 = 0;
        while (n2 < this.listenerCount) {
            Object object = this.listeners[n2];
            if (object instanceof IPreviewPrinterListener) {
                iPreviewPrinterListenerArray[0] = (IPreviewPrinterListener)object;
                try {
                    iSafeRunnable.run();
                }
                catch (Exception exception) {
                    iSafeRunnable.handleException((Throwable)exception);
                }
            }
            ++n2;
        }
    }

    @Override
    public Device getDevice() {
        return this.uiPrinter.getDevice();
    }

    @Override
    public Rectangle getDeviceBounds() {
        return this.uiPrinter.getDeviceBounds();
    }

    @Override
    public Rectangle getDeviceClientArea() {
        return this.uiPrinter.getDeviceClientArea();
    }

    @Override
    public Point getDeviceDPI() {
        return this.uiPrinter.getDeviceDPI();
    }

    public final int getMarginHeight() {
        return this.marginHeight;
    }

    public final int getMarginWidth() {
        return this.marginWidth;
    }

    public Control getPage() {
        return this.page;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getPageIndex() {
        int n = this.getPageCount();
        if (n > 0) {
            if (this.pageIndex < 0 || this.pageIndex >= n) {
                this.setPageIndex(0);
            }
        } else {
            this.setPageIndex(-1);
        }
        return this.pageIndex;
    }

    public float getZoomFactor() {
        return this.zoomFactor;
    }

    public void gotoNextPage() {
        if (this.hasNextPage()) {
            this.setPageIndex(this.getPageIndex() + 1);
        }
    }

    public void gotoPreviousPage() {
        this.gotoPreviousPage(false);
    }

    private void gotoPreviousPage(boolean bl) {
        if (this.hasPreviousPage()) {
            this.setPageIndex(this.getPageIndex() - 1, bl);
        }
    }

    protected void handleMouseWheel(Event event) {
        ScrollBar scrollBar = this.getVerticalBar();
        int n = scrollBar.getSelection();
        if (event.count > 0) {
            if (n <= scrollBar.getMinimum()) {
                this.gotoPreviousPage(true);
            } else {
                scrollBar.setSelection(n - scrollBar.getIncrement());
                scrollBar.notifyListeners(13, null);
            }
        } else if (scrollBar.getMaximum() <= n + scrollBar.getThumb()) {
            this.gotoNextPage();
        } else {
            scrollBar.setSelection(n + scrollBar.getIncrement());
            scrollBar.notifyListeners(13, null);
        }
        event.doit = false;
    }

    public boolean hasNextPage() {
        int n = this.getPageCount();
        int n2 = this.getPageIndex();
        return n > 0 && n2 < n - 1;
    }

    public boolean hasPreviousPage() {
        int n = this.getPageCount();
        int n2 = this.getPageIndex();
        return n > 0 && n2 > 0;
    }

    private void hookScrollBarSelection() {
        ScrollBar scrollBar;
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (PreviewPrinterComposite.this.getPageIndex() > -1) {
                    ScrollBar scrollBar = (ScrollBar)event.widget;
                    Point point = PreviewPrinterComposite.this.page.getLocation();
                    int n = scrollBar.getSelection();
                    if ((0x100 & scrollBar.getStyle()) == 256) {
                        PreviewPrinterComposite.this.page.setLocation(-n + PreviewPrinterComposite.this.marginWidth, point.y);
                    } else {
                        PreviewPrinterComposite.this.page.setLocation(point.x, -n + PreviewPrinterComposite.this.marginHeight);
                    }
                }
            }
        };
        ScrollBar scrollBar2 = this.getHorizontalBar();
        if (scrollBar2 != null) {
            scrollBar2.addListener(13, listener);
        }
        if ((scrollBar = this.getVerticalBar()) != null) {
            scrollBar.addListener(13, listener);
        }
    }

    protected void internalDispose() {
        super.dispose();
    }

    public void removePreviewPrinterListener(IPreviewPrinterListener iPreviewPrinterListener) {
        if (iPreviewPrinterListener != null && this.listeners != null) {
            int n = 0;
            while (n < this.listenerCount) {
                if (iPreviewPrinterListener.equals(this.listeners[n])) {
                    System.arraycopy(this.listeners, n + 1, this.listeners, n, this.listenerCount - n - 1);
                    this.listeners[--this.listenerCount] = null;
                    return;
                }
                ++n;
            }
        }
    }

    public void setPageIndex(int n) {
        this.setPageIndex(n, false);
    }

    private void setPageIndex(int n, boolean bl) {
        if (this.pageIndex != n) {
            Rectangle rectangle;
            this.pageIndex = n;
            n = this.getPageIndex();
            if (n >= 0 && n < this.pageCount) {
                rectangle = this.device.getBounds();
                this.page.setImage(this.pages[n], rectangle.width, rectangle.height);
            } else {
                this.page.setImage(null);
            }
            this.layout();
            rectangle = this.getVerticalBar();
            rectangle.setSelection(bl ? rectangle.getMaximum() : rectangle.getMinimum());
            rectangle.notifyListeners(13, null);
            this.firePreviewPrinterEvent(2);
        }
    }

    public void setZoomFactor(float f) {
        if (f > 0.0f) {
            this.zoomFactor = f;
            if (!this.isDisposed()) {
                this.layout();
            }
        }
    }

    @Override
    public boolean startJob(String string) {
        return this.uiPrinter.startJob(string);
    }

    @Override
    public IPrinterGC startPage() {
        return this.uiPrinter.startPage();
    }

    public void zoomToFit() {
        float f = 1.0f;
        Rectangle rectangle = this.getClientArea();
        rectangle.x += this.marginWidth;
        rectangle.y += this.marginHeight;
        rectangle.width -= 2 * this.marginWidth;
        rectangle.height -= 2 * this.marginHeight;
        Rectangle rectangle2 = this.device.getBounds();
        if (rectangle2.width > 0) {
            f = (float)rectangle.width / (float)rectangle2.width;
        }
        if (rectangle2.height > 0) {
            f = Math.min(f, (float)rectangle.height / (float)rectangle2.height);
        }
        this.setZoomFactor(f);
    }
}

