/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.printing;

import com.deltawalker.App;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.internal.ui.printing.dialogs.PageSetupDialog;
import com.deltawalker.script.MarginUnit;
import com.deltawalker.script.Role;
import com.deltopia.ObjectUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.printing.PrinterData;

public class PageSetup
implements Cloneable {
    public static final String _PREFIX = PageSetup.class.getName();
    public static final String DEF_FTR_CENTER = "";
    public static final String DEF_FTR_LEFT = PageSetupDialog.TEMPL_PG_NUM;
    public static final String DEF_FTR_RIGHT = "<DateTime/>";
    public static final String DEF_HDR_CENTER = PageSetupDialog.PATH_TAGS.get((Object)Role.REF);
    public static final String DEF_HDR_LEFT = PageSetupDialog.PATH_TAGS.get((Object)Role.ONE);
    public static final String DEF_HDR_RIGHT = PageSetupDialog.PATH_TAGS.get((Object)Role.TWO);
    public static final float DEF_MARGIN_BOTTOM = 0.75f;
    public static final float DEF_MARGIN_LEFT = 0.5f;
    public static final float DEF_MARGIN_RIGHT = 0.5f;
    public static final float DEF_MARGIN_TOP = 0.75f;
    private String ftrCenter = "";
    private String ftrLeft = DEF_FTR_LEFT;
    private String ftrRight = "<DateTime/>";
    private String hdrCenter = DEF_HDR_CENTER;
    private String hdrLeft = DEF_HDR_LEFT;
    private String hdrRight = DEF_HDR_RIGHT;
    private float margBottom = 0.75f;
    private float margLeft = 0.5f;
    private float margRight = 0.5f;
    private float margTop = 0.75f;
    private MarginUnit margUnit = MarginUnit.INCH;
    private int orientation = 1;
    private IPreferenceStore prefs = PrefUtil.getGlobalPrefs();
    private boolean printFooter = true;
    private boolean printHeader = true;

    public PageSetup(boolean bl) {
        this.initializeFromPrefs();
    }

    public PageSetup clone() throws CloneNotSupportedException {
        return (PageSetup)super.clone();
    }

    public String getFooter(PrefKey prefKey) {
        if (!this.getPrintHeader()) {
            return DEF_FTR_CENTER;
        }
        switch (prefKey) {
            case P_FOOTER_CENTER: {
                return this.getFooterCenter();
            }
            case P_FOOTER_LEFT: {
                return this.getFooterLeft();
            }
            case P_FOOTER_RIGHT: {
                return this.getFooterRight();
            }
        }
        throw new IllegalArgumentException("footer");
    }

    public String getFooterCenter() {
        return this.ftrCenter;
    }

    public String getFooterLeft() {
        return this.ftrLeft;
    }

    public String getFooterRight() {
        return this.ftrRight;
    }

    public String getHeader(PrefKey prefKey, Boolean bl) {
        if (!this.getPrintHeader()) {
            return DEF_FTR_CENTER;
        }
        switch (prefKey) {
            case P_HEADER_CENTER: {
                if (bl != null && !bl.booleanValue()) {
                    return DEF_FTR_CENTER;
                }
                return this.hdrCenter;
            }
            case P_HEADER_LEFT: {
                if (bl != null && !bl.booleanValue()) {
                    return this.hdrCenter;
                }
                return this.hdrLeft;
            }
            case P_HEADER_RIGHT: {
                if (bl != null && !bl.booleanValue()) {
                    return this.hdrLeft;
                }
                return this.hdrRight;
            }
        }
        throw new IllegalArgumentException("header");
    }

    public String getHeaderCenter() {
        return this.hdrCenter;
    }

    public String getHeaderLeft() {
        return this.hdrLeft;
    }

    public String getHeaderRight() {
        return this.hdrRight;
    }

    public float getMarginBottom() {
        return this.margBottom;
    }

    public float getMarginLeft() {
        return this.margLeft;
    }

    public float getMarginRight() {
        return this.margRight;
    }

    public float getMarginTop() {
        return this.margTop;
    }

    public MarginUnit getMarginUnits() {
        return this.margUnit;
    }

    public int getOrientation() {
        PrinterData printerData = App.instance().printBoss().getPrinterData(true);
        int n = printerData != null ? printerData.orientation : this.orientation;
        return n;
    }

    public boolean getPrintFooter() {
        return this.printFooter;
    }

    public boolean getPrintHeader() {
        return this.printHeader;
    }

    private void initializeFromPrefs() {
        IPreferenceStore iPreferenceStore = PrefUtil.getGlobalPrefs();
        this.setMarginUnits(MarginUnit.fromString(iPreferenceStore.getString(PrefKey.P_MARGIN_UNIT.toString())));
        this.setMarginBottom(iPreferenceStore.getFloat(PrefKey.P_MARGIN_BOTTOM.toString()));
        this.setMarginLeft(iPreferenceStore.getFloat(PrefKey.P_MARGIN_LEFT.toString()));
        this.setMarginRight(iPreferenceStore.getFloat(PrefKey.P_MARGIN_RIGHT.toString()));
        this.setMarginTop(iPreferenceStore.getFloat(PrefKey.P_MARGIN_TOP.toString()));
        this.setFooterCenter(iPreferenceStore.getString(PrefKey.P_FOOTER_CENTER.toString()));
        this.setFooterLeft(iPreferenceStore.getString(PrefKey.P_FOOTER_LEFT.toString()));
        this.setFooterRight(iPreferenceStore.getString(PrefKey.P_FOOTER_RIGHT.toString()));
        this.setHeaderCenter(iPreferenceStore.getString(PrefKey.P_HEADER_CENTER.toString()));
        this.setHeaderLeft(iPreferenceStore.getString(PrefKey.P_HEADER_LEFT.toString()));
        this.setHeaderRight(iPreferenceStore.getString(PrefKey.P_HEADER_RIGHT.toString()));
        this.setPrintFooter(iPreferenceStore.getBoolean(PrefKey.P_PRINT_FOOTER.toString()));
        this.setPrintHeader(iPreferenceStore.getBoolean(PrefKey.P_PRINT_HEADER.toString()));
        this.setOrientation(iPreferenceStore.getInt(PrefKey.P_ORIENTATION.toString()));
    }

    public void setFooter(String string, String string2) {
        if (string.equals(PrefKey.P_FOOTER_CENTER.toString())) {
            this.setFooterCenter(string2);
        } else if (string.equals(PrefKey.P_FOOTER_LEFT.toString())) {
            this.setFooterLeft(string2);
        } else if (string.equals(PrefKey.P_FOOTER_RIGHT.toString())) {
            this.setFooterRight(string2);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setFooterCenter(String string) {
        if (!ObjectUtil.areEqual((Object)this.ftrCenter, (Object)string)) {
            this.ftrCenter = string;
            this.prefs.setValue(PrefKey.P_FOOTER_CENTER.toString(), string);
        }
    }

    public void setFooterLeft(String string) {
        if (!ObjectUtil.areEqual((Object)this.ftrLeft, (Object)string)) {
            this.ftrLeft = string;
            this.prefs.setValue(PrefKey.P_FOOTER_LEFT.toString(), string);
        }
    }

    public void setFooterRight(String string) {
        if (!ObjectUtil.areEqual((Object)this.ftrRight, (Object)string)) {
            this.ftrRight = string;
            this.prefs.setValue(PrefKey.P_FOOTER_RIGHT.toString(), string);
        }
    }

    public void setHeader(String string, String string2) {
        if (string.equals(PrefKey.P_HEADER_CENTER.toString())) {
            this.setHeaderCenter(string2);
        } else if (string.equals(PrefKey.P_HEADER_LEFT.toString())) {
            this.setHeaderLeft(string2);
        } else if (string.equals(PrefKey.P_HEADER_RIGHT.toString())) {
            this.setHeaderRight(string2);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setHeaderCenter(String string) {
        if (!ObjectUtil.areEqual((Object)this.hdrCenter, (Object)string)) {
            this.hdrCenter = string;
            this.prefs.setValue(PrefKey.P_HEADER_CENTER.toString(), string);
        }
    }

    public void setHeaderLeft(String string) {
        if (!ObjectUtil.areEqual((Object)this.hdrLeft, (Object)string)) {
            this.hdrLeft = string;
            this.prefs.setValue(PrefKey.P_HEADER_LEFT.toString(), string);
        }
    }

    public void setHeaderRight(String string) {
        if (!ObjectUtil.areEqual((Object)this.hdrRight, (Object)string)) {
            this.hdrRight = string;
            this.prefs.setValue(PrefKey.P_HEADER_RIGHT.toString(), string);
        }
    }

    public void setMargin(String string, float f) {
        if (string.equals(PrefKey.P_MARGIN_BOTTOM.toString())) {
            this.setMarginBottom(f);
        } else if (string.equals(PrefKey.P_MARGIN_LEFT.toString())) {
            this.setMarginLeft(f);
        } else if (string.equals(PrefKey.P_MARGIN_RIGHT.toString())) {
            this.setMarginRight(f);
        } else if (string.equals(PrefKey.P_MARGIN_TOP.toString())) {
            this.setMarginTop(f);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setMarginBottom(float f) {
        if (this.margBottom != f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException();
            }
            this.margBottom = f;
            this.prefs.setValue(PrefKey.P_MARGIN_BOTTOM.toString(), f);
        }
    }

    public void setMarginLeft(float f) {
        if (this.margLeft != f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("margLeft");
            }
            this.margLeft = f;
            this.prefs.setValue(PrefKey.P_MARGIN_LEFT.toString(), f);
        }
    }

    public void setMarginRight(float f) {
        if (this.margRight != f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("margRight");
            }
            this.margRight = f;
            this.prefs.setValue(PrefKey.P_MARGIN_RIGHT.toString(), f);
        }
    }

    public void setMarginTop(float f) {
        if (this.margTop != f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("margTop");
            }
            this.margTop = f;
            this.prefs.setValue(PrefKey.P_MARGIN_TOP.toString(), f);
        }
    }

    public void setMarginUnits(MarginUnit marginUnit) {
        if (this.margUnit != marginUnit) {
            this.margUnit = marginUnit;
            this.prefs.setValue(PrefKey.P_MARGIN_UNIT.toString(), marginUnit.toString());
        }
    }

    public void setOrientation(int n) {
        int n2 = this.getOrientation();
        if (n2 != n) {
            assert (1 == n || 2 == n);
            PrinterData printerData = App.instance().printBoss().getPrinterData(true);
            if (printerData != null) {
                printerData.orientation = n;
            } else {
                this.orientation = n;
            }
            this.prefs.setValue(PrefKey.P_ORIENTATION.toString(), n);
        }
    }

    public void setPrintFooter(boolean bl) {
        if (this.printFooter != bl) {
            this.printFooter = bl;
            this.prefs.setValue(PrefKey.P_PRINT_FOOTER.toString(), bl);
        }
    }

    public void setPrintHeader(boolean bl) {
        if (this.printHeader != bl) {
            this.printHeader = bl;
            this.prefs.setValue(PrefKey.P_PRINT_HEADER.toString(), this.printFooter);
        }
    }
}

