/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.printing;

import com.deltawalker.App;
import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.internal.ui.printing.NullPrinter;
import com.deltawalker.internal.ui.printing.dialogs.PageSetupDialog;
import com.deltawalker.script.Role;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.printing.IPrinter;
import com.deltawalker.ui.printing.IPrinterGC;
import com.deltawalker.ui.printing.PrinterUtil;
import com.deltopia.StringUtil;
import com.deltopia.io.FileUtil;
import com.deltopia.util.OS;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;

public abstract class HeaderFooterPrintOp
implements Runnable {
    protected static final int CANNOT_START_PAGE = Integer.MIN_VALUE;
    private static final int HEADER_FOOTER_SPACING = 3;
    private boolean canDispose = true;
    private Device device;
    private boolean estimating = false;
    private Font font;
    private HeaderFooterInfo ftrInfo;
    private IPrinterGC gc;
    private HeaderFooterInfo hdrInfo;
    private final boolean headless;
    private int pageIx;
    protected final IProgressMonitor pm;
    private final IPrinter printer;
    private Point printerDPI;
    private Rectangle rcPage;
    private final Map<String, Object> tagValues = new HashMap<String, Object>();
    private boolean threeWay = false;
    private TextLayouts txLayouts;

    protected HeaderFooterPrintOp(IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
        this.printer = iPrinter;
        this.pm = iProgressMonitor != null ? iProgressMonitor : new NullProgressMonitor();
        this.headless = this.printer instanceof NullPrinter;
    }

    private int computePageCount() {
        NullPrinter nullPrinter = new NullPrinter(this.printer);
        try {
            ProgressMonitorWrapper progressMonitorWrapper = new ProgressMonitorWrapper(this.pm){

                public void beginTask(String string, int n) {
                }

                public void done() {
                }

                public void setTaskName(String string) {
                }

                public void subTask(String string) {
                }
            };
            HeaderFooterPrintOp headerFooterPrintOp = this.newInstance(nullPrinter, (IProgressMonitor)progressMonitorWrapper);
            if (headerFooterPrintOp != null) {
                headerFooterPrintOp.estimating = true;
                if (OS.OSX) {
                    headerFooterPrintOp.txLayouts = new TextLayouts();
                }
                headerFooterPrintOp.canDispose = false;
                headerFooterPrintOp.run();
                this.txLayouts = headerFooterPrintOp.txLayouts;
                int n = headerFooterPrintOp.pageIx;
                return n;
            }
        }
        finally {
            nullPrinter.dispose();
        }
        return 0;
    }

    protected TextLayout createTextLayout(String string, int n) {
        return this.createTextLayout(string, n, 16384);
    }

    protected TextLayout createTextLayout(String string, int n, int n2) {
        TextLayout textLayout;
        if (this.txLayouts != null && (textLayout = this.txLayouts.get(string, n, n2)) != null) {
            return textLayout;
        }
        textLayout = new TextLayout(this.device);
        textLayout.setAlignment(n2);
        textLayout.setFont(this.font);
        textLayout.setText(string);
        if (n != 0) {
            textLayout.setWidth(n);
        }
        if (this.txLayouts != null) {
            this.txLayouts.add(string, n, n2, textLayout);
        }
        return textLayout;
    }

    protected void dispose() {
        if (this.txLayouts != null) {
            this.txLayouts.dispose();
        }
        if (this.font != null) {
            this.font.dispose();
        }
    }

    protected void disposeTextLayout(TextLayout textLayout) {
        if (this.txLayouts == null || !this.txLayouts.contains(textLayout)) {
            textLayout.dispose();
        }
    }

    protected void doRun() {
        if (this.printer.startJob(this.headless ? "" : this.getJobName())) {
            this.setTagValue("<DateTime/>", new Date());
            int n = 0;
            if (!this.estimating) {
                this.pm.beginTask(UIMsg.HeaderFooterPrintOp_calculating, -1);
                n = this.computePageCount();
                if (!this.pm.isCanceled()) {
                    this.setTagValue("<PageCount/>", n);
                }
            }
            this.pageIx = 0;
            if (!this.pm.isCanceled()) {
                this.pm.beginTask(UIMsg.HeaderFooterPrintOp_printing, n);
                this.print();
            }
            this.endPage();
            this.printer.endJob();
        }
    }

    protected void drawImage(Image image, int n, int n2, int n3, int n4) {
        if (!this.headless) {
            this.gc.drawImage(image, n, n2, n3, n4);
        }
    }

    protected void drawLine(int n, int n2, int n3, int n4) {
        this.drawLine(n, n2, n3, n4, this.gc.getForeground());
    }

    protected void drawLine(int n, int n2, int n3, int n4, Color color) {
        if (!this.headless && color != null) {
            Color color2 = this.gc.getForeground();
            try {
                this.gc.setForeground(color);
                this.gc.drawLine(n, n2, n3, n4);
            }
            finally {
                this.gc.setForeground(color2);
            }
        }
    }

    protected void drawRectangle(int n, int n2, int n3, int n4, Color color, int n5) {
        if (!this.headless && color != null) {
            Color color2 = this.gc.getForeground();
            try {
                this.gc.setForeground(color);
                this.gc.drawRectangle(n, n2, n3, n4);
            }
            finally {
                this.gc.setForeground(color2);
            }
        }
    }

    protected void drawText(String string, int n, int n2, int n3) {
        this.drawText(string, n, n2, n3, -1);
    }

    protected void drawText(String string, int n, int n2, int n3, int n4) {
        this.drawText(string, n, n2, n3, n4, 16384);
    }

    protected void drawText(String string, int n, int n2, int n3, int n4, Color color) {
        this.drawText(string, n, n2, n3, n4, 16384, color);
    }

    protected void drawText(String string, int n, int n2, int n3, int n4, int n5) {
        this.drawText(string, n, n2, n3, n4, n5, null);
    }

    protected void drawText(String string, int n, int n2, int n3, int n4, int n5, Color color) {
        if (this.headless || StringUtil.isEmpty((String)string)) {
            return;
        }
        TextLayout textLayout = this.createTextLayout(string, n3, n5);
        Rectangle rectangle = null;
        Color color2 = null;
        try {
            if (n3 != -1 && n4 != -1) {
                rectangle = this.gc.getClipping();
                this.gc.setClipping(n, n2, n3, n4);
            }
            if (color != null) {
                color2 = this.gc.getForeground();
                this.gc.setForeground(color);
            }
            this.gc.drawText(textLayout, n, n2);
        }
        finally {
            if (rectangle != null) {
                this.gc.setClipping(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (color2 != null) {
                this.gc.setForeground(color2);
            }
            this.disposeTextLayout(textLayout);
        }
    }

    protected void drawText(String string, Rectangle rectangle) {
        this.drawText(string, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 16384);
    }

    protected void endPage() {
        if (this.gc != null) {
            if (!this.headless) {
                this.printHeader();
                this.printFooter();
            }
            this.printer.endPage();
            this.pm.worked(1);
            this.gc = null;
        }
    }

    private String expandTags(String string) {
        if (string != null) {
            string = StringUtil.replace((String)string, (String)"<PageNumber/>", (String)Integer.toString(this.pageIx));
            Iterator<String> iterator = PageSetupDialog.TAGS_ALL.iterator();
            while (iterator.hasNext()) {
                String string2;
                Object object = this.getTagValue(string2 = iterator.next());
                string = StringUtil.replace((String)string, (String)string2, (String)(object == null ? "" : StringUtil.makeSafe((String)object.toString())));
            }
        }
        return string;
    }

    protected void fillRectangle(int n, int n2, int n3, int n4, Color color) {
        if (color != null) {
            Color color2 = this.gc.getBackground();
            try {
                this.gc.setBackground(color);
                this.gc.fillRectangle(n, n2, n3, n4);
            }
            finally {
                this.gc.setBackground(color2);
            }
        }
    }

    protected Font getFont() {
        return this.font;
    }

    private String getFooter(PrefKey prefKey) {
        String string = App.instance().printBoss().getPageSetup().getFooter(prefKey);
        if (string.isEmpty()) {
            return string;
        }
        if (!string.startsWith("\r") || !string.startsWith("\n")) {
            string = String.valueOf('\n') + string;
        }
        return this.expandTags(string);
    }

    protected int getFooterHeight() {
        this.getPrintableArea();
        return this.ftrInfo.height;
    }

    private String getHeader(PrefKey prefKey) {
        String string = App.instance().printBoss().getPageSetup().getHeader(prefKey, this.threeWay);
        if (string.isEmpty()) {
            return string;
        }
        if (!string.endsWith("\r") || !string.endsWith("\n")) {
            string = String.valueOf(string) + '\n';
        }
        return this.expandTags(string);
    }

    protected String getJobName() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Role role : Relation.roles(this.threeWay)) {
            Object object = this.getTagValue(PageSetupDialog.NAME_TAGS.get((Object)role));
            if (object == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append('-');
            }
            stringBuffer.append(FileUtil.getFileName((String)object.toString(), (boolean)false));
        }
        return stringBuffer.toString();
    }

    protected Rectangle getPrintableArea() {
        if (this.rcPage == null) {
            this.rcPage = PrinterUtil.getPrintableArea(this.printer);
            this.hdrInfo = new HeaderFooterInfo(this.rcPage.width, this.getHeader(PrefKey.P_HEADER_LEFT), this.getHeader(PrefKey.P_HEADER_CENTER), this.getHeader(PrefKey.P_HEADER_RIGHT));
            this.ftrInfo = new HeaderFooterInfo(this.rcPage.width, this.getFooter(PrefKey.P_FOOTER_LEFT), this.getFooter(PrefKey.P_FOOTER_CENTER), this.getFooter(PrefKey.P_FOOTER_RIGHT));
            int n = this.hdrInfo.height;
            this.rcPage.y += n + 6;
            this.rcPage.height -= n + this.ftrInfo.height + 12;
        }
        return new Rectangle(this.rcPage.x, this.rcPage.y, this.rcPage.width, this.rcPage.height);
    }

    protected Device getPrinterDevice() {
        if (this.device == null) {
            this.device = this.printer.getDevice();
        }
        return this.device;
    }

    protected Point getPrinterDPI() {
        if (this.printerDPI == null) {
            this.printerDPI = this.printer.getDeviceDPI();
        }
        return this.printerDPI;
    }

    public Object getTagValue(String string) {
        return this.tagValues.get(string);
    }

    public boolean getThreeWay() {
        return this.threeWay;
    }

    protected String getVisibleContent(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        TextLayout textLayout = this.createTextLayout(string, n);
        try {
            int[] nArray = textLayout.getLineOffsets();
            int n3 = 0;
            int n4 = 0;
            while (n4 < nArray.length - 1) {
                if ((n3 += textLayout.getLineBounds((int)n4).height) > n2) {
                    break;
                }
                stringBuffer.append(string.substring(nArray[n4], nArray[n4 + 1]));
                ++n4;
            }
        }
        finally {
            this.disposeTextLayout(textLayout);
        }
        return stringBuffer.toString();
    }

    protected abstract HeaderFooterPrintOp newInstance(IPrinter var1, IProgressMonitor var2);

    protected abstract void print();

    protected void printFooter() {
        Rectangle rectangle = this.getPrintableArea();
        int n = rectangle.y + rectangle.height + 3;
        int n2 = rectangle.x;
        this.drawText(this.getFooter(PrefKey.P_FOOTER_LEFT), n2, n += 3, this.ftrInfo.leftWidth, -1, 16384);
        this.drawText(this.getFooter(PrefKey.P_FOOTER_CENTER), n2 += this.ftrInfo.leftWidth, n, this.ftrInfo.centerWidth, -1, 0x1000000);
        this.drawText(this.getFooter(PrefKey.P_FOOTER_RIGHT), n2 += this.ftrInfo.centerWidth, n, this.ftrInfo.rightWidth, -1, 131072);
        this.drawLine(rectangle.x, n -= 3, rectangle.x + rectangle.width, n);
    }

    protected void printHeader() {
        Rectangle rectangle = this.getPrintableArea();
        int n = rectangle.x;
        int n2 = rectangle.y - this.hdrInfo.height - 6;
        this.drawText(this.getHeader(PrefKey.P_HEADER_LEFT), n, n2, this.hdrInfo.leftWidth, -1, 16384);
        this.drawText(this.getHeader(PrefKey.P_HEADER_CENTER), n += this.hdrInfo.leftWidth, n2, this.hdrInfo.centerWidth, -1, 0x1000000);
        this.drawText(this.getHeader(PrefKey.P_HEADER_RIGHT), n += this.hdrInfo.centerWidth, n2, this.hdrInfo.rightWidth, -1, 131072);
        n2 = rectangle.y - 3;
        this.drawLine(rectangle.x, n2, rectangle.x + rectangle.width, n2);
    }

    @Override
    public final void run() {
        try {
            this.doRun();
        }
        finally {
            this.pm.done();
            if (this.canDispose) {
                this.dispose();
            }
        }
    }

    protected void setFont(Font font) {
        this.font = font;
    }

    protected void setFontData(FontData fontData) {
        int n = fontData.getHeight();
        --n;
        if (--n < 9) {
            n = 9;
        }
        fontData.setHeight(9);
        this.setFont(new Font(this.getPrinterDevice(), fontData));
    }

    public void setTagValue(String string, Object object) {
        this.tagValues.put(string, object);
    }

    public void setThreeWay(boolean bl) {
        this.threeWay = bl;
    }

    protected boolean startPage() {
        if (this.gc != null) {
            throw new IllegalStateException("startPage() called without a previous call to endPage()");
        }
        this.gc = this.printer.startPage();
        if (this.gc != null) {
            ++this.pageIx;
            return true;
        }
        return false;
    }

    protected Point textExtent(String string) {
        return this.textExtent(string, -1);
    }

    protected Point textExtent(String string, int n) {
        return this.textExtent(string, n, 16384);
    }

    protected Point textExtent(String string, int n, int n2) {
        Point point = new Point(0, 0);
        if (!StringUtil.isEmpty((String)string)) {
            TextLayout textLayout = this.createTextLayout(string, n, n2);
            try {
                Rectangle rectangle = textLayout.getBounds();
                point = new Point(rectangle.width, rectangle.height);
            }
            finally {
                this.disposeTextLayout(textLayout);
            }
        }
        return point;
    }

    protected Point toPrinterSize(Point point, int n, int n2) {
        int n3;
        int n4;
        Point point2 = this.getPrinterDPI();
        if (point2.x != point.x && n != 0) {
            if (point.x == 0) {
                throw new IllegalArgumentException("dpi");
            }
            n4 = (int)Math.ceil((double)(n * point2.x) / (double)point.x);
        } else {
            n4 = n;
        }
        if (point2.y != point.y && n2 != 0) {
            if (point.y == 0) {
                throw new IllegalArgumentException("dpi");
            }
            n3 = (int)Math.ceil((double)(n2 * point2.y) / (double)point.y);
        } else {
            n3 = n2;
        }
        return new Point(n4, n3);
    }

    private class HeaderFooterInfo {
        public final int centerWidth;
        public final int height;
        public final int leftWidth;
        public final int rightWidth;

        public HeaderFooterInfo(int n, String string, String string2, String string3) {
            this.centerWidth = Math.min(HeaderFooterPrintOp.this.textExtent((String)string2, (int)-1, (int)0x1000000).x, n);
            this.leftWidth = (n - this.centerWidth) / 2;
            this.rightWidth = n - this.leftWidth - this.centerWidth;
            this.height = Math.max(Math.max(HeaderFooterPrintOp.this.textExtent((String)string, (int)this.leftWidth, (int)16384).y, HeaderFooterPrintOp.this.textExtent((String)string2, (int)this.centerWidth, (int)0x1000000).y), HeaderFooterPrintOp.this.textExtent((String)string3, (int)this.rightWidth, (int)131072).y);
        }
    }

    private static class TextLayouts {
        private Map<TextLayoutKey, TextLayout> entries = new HashMap<TextLayoutKey, TextLayout>();

        private TextLayouts() {
        }

        public void add(String string, int n, int n2, TextLayout textLayout) {
            TextLayoutKey textLayoutKey = new TextLayoutKey(string, n, n2);
            if (!this.entries.containsKey(textLayoutKey)) {
                this.entries.put(textLayoutKey, textLayout);
            }
        }

        public boolean contains(TextLayout textLayout) {
            return this.entries.containsValue(textLayout);
        }

        public void dispose() {
            for (TextLayout textLayout : this.entries.values()) {
                textLayout.dispose();
            }
            this.entries.clear();
        }

        public TextLayout get(String string, int n, int n2) {
            TextLayoutKey textLayoutKey = new TextLayoutKey(string, n, n2);
            return this.entries.get(textLayoutKey);
        }

        private static class TextLayoutKey {
            public final int alignment;
            private volatile int hashCode;
            public final String text;
            public final int width;

            public TextLayoutKey(String string, int n, int n2) {
                this.text = string;
                this.width = n;
                this.alignment = n2;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof TextLayoutKey)) {
                    return false;
                }
                TextLayoutKey textLayoutKey = (TextLayoutKey)object;
                return this.width == textLayoutKey.width && this.alignment == textLayoutKey.alignment && this.text.equals(textLayoutKey.text);
            }

            public int hashCode() {
                int n = this.hashCode;
                if (n == 0) {
                    n = 17;
                    n = 31 * n + this.text.hashCode();
                    n = 31 * n + this.width;
                    this.hashCode = n = 31 * n + this.alignment;
                }
                return n;
            }
        }
    }
}

