/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.printing;

import com.deltawalker.script.Role;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.printing.HeaderFooterPrintOp;
import com.deltawalker.ui.printing.IPrinter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;

public abstract class DiffViewPrintOp
extends HeaderFooterPrintOp {
    private DeltaColor dColor;
    protected final Role[] roles;
    protected final boolean threeWay;

    public DiffViewPrintOp(DiffView diffView, IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
        super(iPrinter, iProgressMonitor);
        Role[] roleArray;
        this.threeWay = diffView.isThreeWay();
        if (this.threeWay) {
            Role[] roleArray2 = new Role[3];
            roleArray2[0] = Role.ONE;
            roleArray2[1] = Role.REF;
            roleArray = roleArray2;
            roleArray2[2] = Role.TWO;
        } else {
            Role[] roleArray3 = new Role[2];
            roleArray3[0] = Role.REF;
            roleArray = roleArray3;
            roleArray3[1] = Role.ONE;
        }
        this.roles = roleArray;
    }

    @Override
    protected void dispose() {
        try {
            if (this.dColor != null) {
                this.dColor.dispose();
                this.dColor = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    protected abstract int getCenterWidth();

    protected DeltaColor diffColor() {
        Device device = this.getPrinterDevice();
        if (this.dColor != null && !this.dColor.device().equals(device)) {
            this.dColor.dispose();
            this.dColor = null;
        }
        if (this.dColor == null) {
            this.dColor = DeltaColor.forDevice(device);
        }
        return this.dColor;
    }

    @Override
    protected HeaderFooterPrintOp newInstance(IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
        return null;
    }

    @Override
    protected void print() {
        Rectangle rectangle = this.getPrintableArea();
        int n = this.getCenterWidth();
        int n2 = this.roles.length;
        int n3 = (rectangle.width - n * (n2 - 1)) / n2;
        int[] nArray = new int[n2];
        int n4 = rectangle.x;
        int n5 = 0;
        while (n5 < n2) {
            nArray[n5] = n4;
            n4 += n3 + n;
            ++n5;
        }
        this.print(rectangle, nArray, n3);
    }

    protected abstract void print(Rectangle var1, int[] var2, int var3);
}

