/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.fieldassist;

import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.ui.fieldassist.ContentProposal;
import com.deltopia.StringUtil;
import com.deltopia.io.FileInfo;
import com.deltopia.io.FileUtil;
import com.deltopia.io.IFilenameFilter;
import com.deltopia.io.IO;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class FileSystemContentProposalProvider
implements IContentProposalProvider {
    private static final IContentProposal[] NO_PROPOSALS = new IContentProposal[0];
    private IFilenameFilter filter;

    public FileSystemContentProposalProvider(IFilenameFilter iFilenameFilter) {
        this.filter = iFilenameFilter;
    }

    public IContentProposal[] getProposals(String string, int n) {
        String string2;
        FileInfo[] fileInfoArray;
        String string3 = FileUtil.defaultSlashes((String)string);
        int n2 = string3.lastIndexOf(File.separatorChar);
        if (n2 < 0) {
            return NO_PROPOSALS;
        }
        File file = new File(string3.substring(0, n2 + 1));
        try {
            fileInfoArray = IO.fileSystem().listFileInfos(file, 7, (IProgressMonitor)new NullProgressMonitor(){

                public boolean isCanceled() {
                    return Thread.currentThread().isInterrupted();
                }
            }, 16);
        }
        catch (Exception exception) {
            fileInfoArray = new FileInfo[]{};
        }
        String string4 = string3.substring(n2 + 1);
        LinkedList<FileInfo> linkedList = new LinkedList<FileInfo>();
        FileInfo[] fileInfoArray2 = fileInfoArray;
        int n3 = fileInfoArray.length;
        int n4 = 0;
        while (n4 < n3) {
            FileInfo fileInfo = fileInfoArray2[n4];
            string2 = fileInfo.name();
            boolean bl = StringUtil.startsWithIgnoreCase((CharSequence)string2, (CharSequence)string4);
            if (bl && this.filter.accepts(fileInfo)) {
                linkedList.add(fileInfo);
            }
            ++n4;
        }
        Collections.sort(linkedList, new Comparator<FileInfo>(){

            @Override
            public int compare(FileInfo fileInfo, FileInfo fileInfo2) {
                if (fileInfo.isDirectory() && !fileInfo2.isDirectory()) {
                    return -1;
                }
                if (!fileInfo.isDirectory() && fileInfo2.isDirectory()) {
                    return 1;
                }
                return fileInfo.name().compareToIgnoreCase(fileInfo2.name());
            }
        });
        int n5 = linkedList.size();
        IContentProposal[] iContentProposalArray = new IContentProposal[n5];
        Point point = new Point(16, 16);
        int n6 = 0;
        while (n6 < n5) {
            string2 = (FileInfo)linkedList.get(n6);
            if (string2 == null) break;
            String string5 = file.toString();
            String string6 = string5.endsWith(File.separator) ? file + string2.name() : file + File.separator + string2.name();
            Image image = null;
            if (string2.isDirectory()) {
                image = ImageCache.getImage(ImageConst.FOLDER);
            } else {
                FileUtil.ProgramInfo programInfo = FileUtil.getImageFromExtension((String)FileUtil.getExtension((String)string2.name()), (Point)point);
                Image image2 = image = programInfo != null ? programInfo.image : null;
                if (image == null) {
                    image = ImageCache.getImage(ImageConst.FILE);
                }
            }
            iContentProposalArray[n6] = new ContentProposal(string6, image);
            ++n6;
        }
        return iContentProposalArray;
    }
}

