/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.fieldassist;

import com.deltawalker.ui.fieldassist.ContentProposalAdapter;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class ContentAssistCommandAdapter
extends ContentProposalAdapter {
    private String commandId;
    public static final String CONTENT_PROPOSAL_COMMAND = "org.eclipse.ui.edit.text.contentAssist.proposals";
    private static final int DEFAULT_AUTO_ACTIVATION_DELAY = 500;
    private IHandlerService handlerService;
    private IHandlerActivation activeHandler;
    private IHandler proposalHandler = new AbstractHandler(){

        public Object execute(ExecutionEvent executionEvent) {
            ContentAssistCommandAdapter.this.openProposalPopup();
            return null;
        }
    };

    public ContentAssistCommandAdapter(Control control, IControlContentAdapter iControlContentAdapter, IContentProposalProvider iContentProposalProvider, String string, char[] cArray) {
        super(control, iControlContentAdapter, iContentProposalProvider, null, cArray);
        this.commandId = string;
        if (string == null) {
            this.commandId = CONTENT_PROPOSAL_COMMAND;
        }
        if (cArray == null) {
            this.setAutoActivationCharacters(new char[0]);
        }
        this.setAutoActivationDelay(500);
        this.addListeners(control);
        this.handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
    }

    private void addListeners(Control control) {
        control.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                if (ContentAssistCommandAdapter.this.activeHandler != null) {
                    ContentAssistCommandAdapter.this.handlerService.deactivateHandler(ContentAssistCommandAdapter.this.activeHandler);
                    ContentAssistCommandAdapter.this.activeHandler = null;
                }
            }

            public void focusGained(FocusEvent focusEvent) {
                if (ContentAssistCommandAdapter.this.isEnabled()) {
                    if (ContentAssistCommandAdapter.this.activeHandler == null) {
                        ContentAssistCommandAdapter.this.activeHandler = ContentAssistCommandAdapter.this.handlerService.activateHandler(ContentAssistCommandAdapter.this.commandId, ContentAssistCommandAdapter.this.proposalHandler);
                    }
                } else {
                    if (ContentAssistCommandAdapter.this.activeHandler != null) {
                        ContentAssistCommandAdapter.this.handlerService.deactivateHandler(ContentAssistCommandAdapter.this.activeHandler);
                    }
                    ContentAssistCommandAdapter.this.activeHandler = null;
                }
            }
        });
        control.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                if (ContentAssistCommandAdapter.this.activeHandler != null) {
                    ContentAssistCommandAdapter.this.handlerService.deactivateHandler(ContentAssistCommandAdapter.this.activeHandler);
                    ContentAssistCommandAdapter.this.activeHandler = null;
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }
        });
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ContentAssistCommandAdapter.this.activeHandler != null) {
                    ContentAssistCommandAdapter.this.handlerService.deactivateHandler(ContentAssistCommandAdapter.this.activeHandler);
                    ContentAssistCommandAdapter.this.activeHandler = null;
                }
            }
        });
    }

    public String getCommandId() {
        return this.commandId;
    }
}

