/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.dialogs;

import com.deltawalker.AddonException;
import com.deltawalker.AddonInfo;
import com.deltawalker.AddonInfoUtil;
import com.deltawalker.ui.DeltaColor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserInfoDialog
extends TitleAreaDialog {
    protected static int textHeight = 2;
    private static int textLength = 30;
    private int charWidth;
    protected Color clrOptional;
    protected Color clrRequired;
    protected AddonInfo info = AddonInfoUtil.addonInfo();
    protected Text txtCompany;
    protected Text txtEmail;
    protected Text txtName;

    public UserInfoDialog() {
        this(null);
    }

    public UserInfoDialog(Shell shell) {
        super(shell);
    }

    public boolean close() {
        boolean bl = super.close();
        if (this.clrRequired != null && !this.clrRequired.isDisposed()) {
            this.clrRequired.dispose();
            this.clrRequired = null;
        }
        if (this.clrOptional != null && !this.clrOptional.isDisposed()) {
            this.clrOptional.dispose();
            this.clrOptional = null;
        }
        return bl;
    }

    protected Button createCheckbox(Composite composite, String string, int n, int n2) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = n2;
        if ((n2 & 4) != 0) {
            gridData.grabExcessHorizontalSpace = true;
        }
        Button button = new Button(composite, n);
        button.setLayoutData((Object)gridData);
        button.setText(string);
        return button;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Display display = composite2.getDisplay();
        RGB rGB = DeltaColor.getListBackgroundSystemColor().getRGB();
        this.clrRequired = new Color((Device)display, DeltaColor.interpolate(new RGB(255, 0, 0), rGB, 0.8));
        this.clrOptional = new Color((Device)display, DeltaColor.interpolate(new RGB(0, 255, 0), rGB, 0.8));
        GC gC = new GC((Drawable)composite2);
        try {
            this.charWidth = gC.getFontMetrics().getAverageCharWidth();
        }
        finally {
            gC.dispose();
        }
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = (int)(1.5 * (double)this.convertVerticalDLUsToPixels(4));
        gridLayout.marginHeight = this.convertHorizontalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        Dialog.applyDialogFont((Control)composite3);
        return composite3;
    }

    protected void createLabel(Composite composite, String string, Control[] controlArray) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 128, false, false));
        label.setText(String.valueOf(string) + ':');
        if (controlArray != null) {
            controlArray[0] = label;
        }
    }

    protected Text createTextControl(Composite composite, AddonInfo.Param param, int n) {
        return this.createTextControl(composite, param, n, null);
    }

    protected Text createTextControl(Composite composite, AddonInfo.Param param, int n, Control[] controlArray) {
        String string = param.displayName();
        String string2 = this.info.paramValueAsString(param);
        if (param == AddonInfo.Param.KEY && string2.equals("MC0CFCha-B6VCxE8D-L3yQ8zCZ-PUtb+F3E-AhUAkWkQ-SHKG7umL-TYEmVDg/-menFts0=")) {
            string2 = "";
        }
        return this.createTextControl(composite, string, string2, param, n, controlArray);
    }

    protected Text createTextControl(Composite composite, String string, String string2, AddonInfo.Param param, int n, Control[] controlArray) {
        GridData gridData;
        this.createLabel(composite, string, controlArray);
        Text text = new Text(composite, n |= 0x800);
        if ((n & 2) != 0) {
            gridData = new GridData(4, 4, true, true);
            int n2 = text.getLineHeight();
            gridData.heightHint = textHeight * n2;
            gridData.widthHint = this.charWidth * textLength;
        } else {
            gridData = new GridData(4, 4, true, false);
        }
        text.setLayoutData((Object)gridData);
        text.setText(string2);
        text.setData((Object)param);
        return text;
    }

    protected void enableInfoControls(boolean bl) {
        this.txtName.setEnabled(bl);
        this.txtEmail.setEnabled(bl);
        this.txtCompany.setEnabled(bl);
    }

    protected String getErrorMessage(AddonException addonException) {
        if (addonException != null) {
            return addonException.getLocalizedMessage();
        }
        return "";
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10 | 0x10000000;
    }
}

