/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.dialogs;

import com.deltopia.StringUtil;
import java.io.File;
import java.nio.file.NoSuchFileException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.PreviewView;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextPreviewDialog
extends Dialog {
    private static final Logger LOG = LoggerFactory.getLogger(TextPreviewDialog.class);
    private String text;
    private String title = "Preview";
    private File file;
    private Image image;

    public TextPreviewDialog(Shell shell) {
        super(shell);
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Shell shell = this.getShell();
        shell.setText(this.title);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 800;
        gridData.heightHint = 600;
        if (!StringUtil.isEmpty((String)this.text)) {
            Text text = new Text(composite2, 2882);
            text.setLayoutData((Object)gridData);
            text.setText(this.text);
        } else if (this.image != null) {
            Label label = new Label(composite2, 0x1000800);
            label.setLayoutData((Object)gridData);
            label.setImage(this.image);
        } else {
            PreviewView previewView = new PreviewView(composite2);
            shell.setSize(gridData.widthHint, gridData.heightHint);
            previewView.setLayoutData((Object)gridData);
            try {
                previewView.setPreviewItem(this.file);
            }
            catch (Exception exception) {
                String string;
                if (exception instanceof NoSuchFileException) {
                    string = "Cannot preview: " + this.file;
                    LOG.info(String.valueOf(string) + ": " + exception.getMessage());
                } else {
                    string = "Failed to preview: " + this.file + ". Error: " + exception.getMessage();
                    LOG.error("Failed to preview " + this.file, (Throwable)exception);
                }
                Label label = new Label(composite2, 0);
                label.setText(string);
                shell.pack();
            }
        }
        TextPreviewDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x10000000 | 0x10);
        return super.open();
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setTitle(String string) {
        if (StringUtil.isEmpty((String)string)) {
            throw new IllegalArgumentException("title");
        }
        this.title = string;
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException("image");
        }
        this.image = image;
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.file = file;
    }
}

