/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.dialogs;

import com.deltawalker.AddonInfo;
import com.deltawalker.App;
import com.deltawalker.interfaces.IStateBoss;
import com.deltawalker.ui.CheckboxTable;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.TextPreviewDialog;
import com.deltawalker.ui.dialogs.UserInfoDialog;
import com.deltopia.StringUtil;
import com.deltopia.eclipse.util.SizeFormatter;
import com.deltopia.io.FileUtil;
import com.deltopia.io.IFileSystem;
import com.deltopia.io.IO;
import com.deltopia.io.StreamUtil;
import com.deltopia.jface.util.DialogUtil;
import com.deltopia.ui.OSFileDialog;
import com.deltopia.util.Const;
import com.deltopia.util.logging.LogUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitFeedbackDialog
extends UserInfoDialog {
    private static final String DNL = String.valueOf(Const.LINE_ENDING) + Const.LINE_ENDING;
    private static final Logger LOG = LoggerFactory.getLogger(SubmitFeedbackDialog.class);
    private static final String NL = Const.LINE_ENDING;
    private static final String SEC_TITLE = String.valueOf(DNL) + NL + "***** {0} *****" + DNL;
    private static final String PREFIX = "SubmitFeedbackDialog.";
    private static final String KEY_CMD = "com.deltawalker.cmd";
    private static final String CMD_SYSTEM_INFO = "SystemInfo";
    private static final String CMD_ATTACH_FILES = "AttachFiles";
    private static final String CMD_PREVIEW = "Preview";
    private static final Set<String> LIST_TEXT_EXT = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("txt", "log", "properties", "css", "java", "js", "log", "mf", "jsp", "dws")));
    private static final int MAX_PREVIEW_CHARS = 256000;
    private static int textLength = 30;
    private int charWidth;
    private Button chbSysInfo;
    private Color clrRequired;
    private String email;
    private String submitMsg;
    private Text txtComment;
    private FilesTable table;
    private Handler handler;

    public SubmitFeedbackDialog(Shell shell) {
        super(shell);
    }

    @Override
    public boolean close() {
        boolean bl = super.close();
        if (this.clrRequired != null && !this.clrRequired.isDisposed()) {
            this.clrRequired.dispose();
            this.clrRequired = null;
        }
        return bl;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(UIMsg.SubmitFeedbackAction_toolTip);
        this.setHelpAvailable(false);
    }

    private String constructSubmitMessage(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.txtName.getText());
        stringBuilder.append(DNL);
        stringBuilder.append(this.txtEmail.getText());
        stringBuilder.append(DNL);
        stringBuilder.append(this.txtComment.getText());
        stringBuilder.append(DNL);
        stringBuilder.append(NLS.bind((String)"App version: {0}", (Object)Platform.getProduct().getDefiningBundle().getVersion()));
        stringBuilder.append(NL);
        stringBuilder.append("MAS build: No");
        if (this.chbSysInfo.getSelection()) {
            stringBuilder.append(this.getRuntimeInfo());
            stringBuilder.append(this.getSystemProperties());
            stringBuilder.append(this.getEnvInfo());
        }
        if (!bl) {
            return stringBuilder.toString();
        }
        Set<File> set = this.table.getCheckedFiles(true);
        if (set.size() > 0) {
            int n = 256000 / set.size();
            for (File file : set) {
                this.appendFileContent(stringBuilder, file, n);
            }
        }
        return stringBuilder.toString();
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.getButton(0).setText(this.getString("Submit.label", new Object[0]));
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.handler = new Handler();
        this.setTitle(this.getString("title", new Object[0]));
        this.setMessage(this.getString("message", new Object[0]));
        this.charWidth = UIUtil.getAverageCharWidth((Drawable)composite2);
        Label label = new Label(composite2, 64);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 2;
        gridData.widthHint = this.charWidth * textLength;
        label.setLayoutData((Object)gridData);
        label.setText(this.getString("Personal.description", new Object[0]));
        this.txtName = this.createTextControl(composite2, AddonInfo.Param.NAME, 4);
        this.txtEmail = this.createTextControl(composite2, AddonInfo.Param.EMAIL, 4);
        textHeight = 5;
        this.txtComment = this.createTextControl(composite2, this.getString("Comment.label", new Object[0]), "", null, 578, null);
        Composite composite3 = DialogUtil.insertLabelSeparator(composite2, this.getString("FileList.label", new Object[0]));
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        composite3.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 5;
        composite4.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 3;
        composite4.setLayoutData((Object)gridData);
        this.chbSysInfo = this.addButton(composite4, CMD_SYSTEM_INFO, 32, 16388);
        this.chbSysInfo.setSelection(true);
        this.addButton(composite4, CMD_ATTACH_FILES, 8, 16384);
        this.addButton(composite4, CMD_PREVIEW, 8, 131072);
        this.table = new FilesTable(composite2);
        this.table.addFiles(AttachItem.Type.LogFile, LogUtil.getLogFiles());
        IStateBoss iStateBoss = App.instance().stateBoss();
        iStateBoss.saveState(iStateBoss.stateFile(), true);
        this.table.addFile(AttachItem.Type.StateFile, iStateBoss.stateFile());
        this.table.packTable();
        label = new Label(composite2, 64);
        gridData = new GridData(4, 128, true, false);
        gridData.horizontalSpan = 3;
        gridData.widthHint = this.charWidth * textLength;
        label.setLayoutData((Object)gridData);
        label.setText(this.getString("Confirm.label", new Object[0]));
        return composite2;
    }

    public String getEmail() {
        return this.email;
    }

    private String getEnvInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(NLS.bind((String)SEC_TITLE, (Object)"Environment Variables"));
        Map<String, String> map = System.getenv();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue()).append(NL);
        }
        return stringBuilder.toString();
    }

    private String getRuntimeInfo() {
        File[] fileArray;
        StringBuilder stringBuilder = new StringBuilder();
        Runtime runtime = Runtime.getRuntime();
        stringBuilder.append(NLS.bind((String)SEC_TITLE, (Object)"Runtime Info"));
        stringBuilder.append("Available processors (cores): ").append(runtime.availableProcessors()).append(NL);
        stringBuilder.append("Free memory: ").append(SizeFormatter.format(runtime.freeMemory(), 2)).append(NL);
        long l = runtime.maxMemory();
        stringBuilder.append("Maximum memory: ").append(l == Long.MAX_VALUE ? "no limit" : SizeFormatter.format(l, 2)).append(NL);
        stringBuilder.append("Total memory (bytes): ").append(SizeFormatter.format(Runtime.getRuntime().totalMemory(), 2));
        stringBuilder.append(NLS.bind((String)SEC_TITLE, (Object)"File System Info"));
        File[] fileArray2 = fileArray = File.listRoots();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            stringBuilder.append("File system root: ").append(file.getAbsolutePath()).append(NL);
            stringBuilder.append("Total space: ").append(SizeFormatter.format(file.getTotalSpace(), 2)).append(NL);
            stringBuilder.append("Free space: ").append(SizeFormatter.format(file.getFreeSpace(), 2)).append(NL);
            stringBuilder.append("Usable space: ").append(SizeFormatter.format(file.getUsableSpace(), 2)).append(NL);
            ++n2;
        }
        return stringBuilder.toString();
    }

    @Override
    protected int getShellStyle() {
        return super.getShellStyle() | 0x10 | 0x10000000;
    }

    public Set<File> getSubmitFiles() {
        return this.table.getCheckedFiles(false);
    }

    public String getSubmitMessage() {
        return this.submitMsg;
    }

    private String getSystemProperties() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(NLS.bind((String)SEC_TITLE, (Object)"System Properties"));
        Properties properties = System.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append(NL);
        }
        return stringBuilder.toString();
    }

    protected void okPressed() {
        this.submitMsg = this.constructSubmitMessage(false);
        this.email = this.txtEmail.getText();
        super.okPressed();
    }

    public final String getString(String string, Object ... objectArray) {
        ResourceBundle resourceBundle = UIMsg.constructedKeyBundle();
        String string2 = resourceBundle.getString(PREFIX + string);
        if (objectArray != null && objectArray.length > 0) {
            string2 = NLS.bind((String)string2, (Object[])objectArray);
        }
        return string2;
    }

    private Button addButton(Composite composite, String string, int n, int n2) {
        String string2 = this.getString(String.valueOf(string) + ".label", new Object[0]);
        Button button = this.createCheckbox(composite, string2, n, n2);
        button.setData(KEY_CMD, (Object)string);
        button.addSelectionListener((SelectionListener)this.handler);
        return button;
    }

    private StringBuilder appendFileContent(StringBuilder stringBuilder, File file, int n) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(NLS.bind((String)SEC_TITLE, (Object)file));
        try {
            boolean bl = StreamUtil.readFromFile((File)file, (int)n, (StringBuilder)stringBuilder);
            if (!bl) {
                stringBuilder.append(NL);
                stringBuilder.append(NLS.bind((String)"The file {0} is too big to be displayed here in its entirety. You can review the original file prior to submitting it.", (Object)file));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.error("Cannot find file " + file);
            stringBuilder.append("Cannot find file ").append(file);
        }
        catch (IOException iOException) {
            LOG.error("Cannot load file " + file, (Throwable)iOException);
            stringBuilder.append("Cannot load file ").append(file).append(": ").append(iOException.getMessage());
        }
        return stringBuilder;
    }

    private static final class AttachItem
    extends CheckboxTable.Item {
        private final File path;
        private final Type type;

        private AttachItem(Type type, String string, File file) {
            super(string, file != null ? file.toString() : null);
            if (type == null) {
                throw new NullPointerException("type");
            }
            this.path = file;
            this.type = type;
        }

        static enum Type {
            LogFile,
            StateFile,
            Custom;


            boolean includeInPreview() {
                return this != Custom;
            }
        }
    }

    private final class FilesTable
    extends CheckboxTable<AttachItem>
    implements MouseListener {
        FilesTable(Composite composite) {
            super(composite, 0, SubmitFeedbackDialog.PREFIX, 30);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.horizontalSpan = 2;
            this.tblParent.setLayoutData((Object)gridData);
            this.packTable();
            this.table.addMouseListener((MouseListener)this);
        }

        void addFile(AttachItem.Type type, File file) {
            String string = this.getString((Object)((Object)type) + ".name");
            this.addItem(new AttachItem(type, string, file), true);
        }

        void addFiles(AttachItem.Type type, Set<File> set) {
            for (File file : set) {
                this.addFile(type, file);
            }
        }

        Set<File> getCheckedFiles(boolean bl) {
            Set set = super.getCheckedItems();
            LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>(set.size());
            for (AttachItem attachItem : set) {
                if (bl && !attachItem.type.includeInPreview()) continue;
                linkedHashSet.add(attachItem.path);
            }
            return linkedHashSet;
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            if (mouseEvent.widget == this.table) {
                SubmitFeedbackDialog.this.handler.onPreviewSelectedItem();
            } else {
                LOG.warn("Unknown widget: " + mouseEvent.widget);
            }
        }

        public void mouseDown(MouseEvent mouseEvent) {
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }
    }

    private class Handler
    extends SelectionAdapter {
        private Handler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void widgetSelected(SelectionEvent selectionEvent) {
            Object object;
            block13: {
                String string;
                Widget widget = selectionEvent.widget;
                if (!(widget instanceof Button)) return;
                Button button = (Button)selectionEvent.widget;
                object = button.getData(SubmitFeedbackDialog.KEY_CMD);
                if (!(object instanceof String)) break block13;
                switch (string = (String)object) {
                    case "AttachFiles": {
                        this.onAttachFiles();
                        return;
                    }
                    case "Preview": {
                        this.onPreview();
                        return;
                    }
                    default: {
                        LOG.warn("Unknown action: " + string);
                        return;
                    }
                    case "SystemInfo": {
                        return;
                    }
                }
            }
            LOG.warn("Invalid data: " + object);
        }

        private void onAttachFiles() {
            OSFileDialog oSFileDialog = new OSFileDialog(SubmitFeedbackDialog.this.getShell(), 4098);
            String string = oSFileDialog.open();
            if (string != null) {
                String string2 = oSFileDialog.getFilterPath();
                String[] stringArray = oSFileDialog.getFileNames();
                if (stringArray.length > 0) {
                    LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>(stringArray.length);
                    String[] stringArray2 = stringArray;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string3 = stringArray2[n2];
                        File file = new File(string2, string3);
                        linkedHashSet.add(file);
                        ++n2;
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Attached files: " + linkedHashSet);
                    }
                    SubmitFeedbackDialog.this.table.addFiles(AttachItem.Type.Custom, linkedHashSet);
                }
            }
        }

        private void onPreview() {
            TextPreviewDialog textPreviewDialog = new TextPreviewDialog(SubmitFeedbackDialog.this.getShell());
            textPreviewDialog.setTitle(SubmitFeedbackDialog.this.getString("CombinedPreview.title", new Object[0]));
            textPreviewDialog.setText(SubmitFeedbackDialog.this.constructSubmitMessage(true));
            textPreviewDialog.open();
        }

        private void onPreviewSelectedItem() {
            Set set = SubmitFeedbackDialog.this.table.getSelectedItems();
            if (set.size() > 0) {
                AttachItem attachItem = (AttachItem)set.iterator().next();
                File file = attachItem.path;
                Shell shell = SubmitFeedbackDialog.this.getShell();
                TextPreviewDialog textPreviewDialog = new TextPreviewDialog(shell);
                textPreviewDialog.setTitle(SubmitFeedbackDialog.this.getString("FilePreview.title", attachItem.path));
                IFileSystem iFileSystem = IO.fileSystem();
                Display display = shell.getDisplay();
                Point point = UIUtil.getPrefPreviewSize(display);
                Image image = iFileSystem.getThumbnail((Device)display, file, point.x, point.y);
                if (image != null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Preview as thumbnail " + image.getBounds() + ", preferred: " + point);
                    }
                    textPreviewDialog.setImage(image);
                } else {
                    String string = FileUtil.getExtension((String)file.getName()).toLowerCase();
                    if (!StringUtil.isEmpty((String)string) && LIST_TEXT_EXT.contains(string)) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Preview as text " + file);
                        }
                        String string2 = SubmitFeedbackDialog.this.appendFileContent(null, file, 256000).toString();
                        textPreviewDialog.setText(string2);
                    } else {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Preview with native: " + file);
                        }
                        textPreviewDialog.setFile(file);
                    }
                }
                textPreviewDialog.open();
            } else {
                LOG.warn("No selected items in table");
            }
        }
    }
}

