/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.dialogs;

import com.deltawalker.internal.ContextId;
import com.deltawalker.internal.ScmIntegrator;
import com.deltawalker.ui.UIUtil;
import com.deltopia.io.FileUtil;
import com.deltopia.jface.util.DialogUtil;
import com.deltopia.ui.OSFileDialog;
import java.io.File;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ScmPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final ScmIntegrator integrator = new ScmIntegrator();
    private Table table;
    private final TableColumnLayout tcLayout = new TableColumnLayout();

    private Control createButtonBar(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(131072, 4, false, true));
        final Button button = new Button(composite2, 8);
        button.setText("Browse");
        button.setLayoutData((Object)new GridData(4, 16384, true, false));
        button.setEnabled(false);
        final Shell shell = UIUtil.getActiveWindowShell();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = ScmPrefPage.this.table.getItem(ScmPrefPage.this.table.getSelectionIndex());
                String string = tableItem.getText(1);
                OSFileDialog oSFileDialog = new OSFileDialog(shell, 4096);
                if (FileUtil.absolutelyExists((String)string)) {
                    oSFileDialog.setFilterPath(FileUtil.getPathStem((String)string));
                    oSFileDialog.setFileName(FileUtil.getFileName((String)string));
                }
                if (FileUtil.absolutelyExists((String)(string = oSFileDialog.open())) && new File(string).isFile()) {
                    tableItem.setText(1, string);
                    tableItem.setChecked(ScmPrefPage.this.integrator.isConfiguredWithDW(ScmIntegrator.Scm.values()[ScmPrefPage.this.table.getSelectionIndex()], new File(string)));
                }
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                button.setEnabled(ScmPrefPage.this.table.getSelectionCount() == 1);
            }
        });
        return composite2;
    }

    protected Control createContents(Composite composite) {
        UIUtil.setHelpContextId((Control)composite, ContextId.SCM_PREF_PAGE);
        Composite composite2 = DialogUtil.createPageComposite(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 2;
        this.createTable(composite2);
        this.createButtonBar(composite2);
        return composite2;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        this.getDefaultsButton().setEnabled(false);
    }

    private void createTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.tcLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(composite2, 68384);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setText("SCM");
        this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(30));
        tableColumn = new TableColumn(this.table, 0);
        tableColumn.setText("Config File Default Location");
        this.tcLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(70));
        ScmIntegrator.Scm[] scmArray = ScmIntegrator.Scm.values();
        int n = scmArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScmIntegrator.Scm scm = scmArray[n2];
            final TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, scm.displayName());
            String string = ScmIntegrator.getConfigFileDefaultLocation(scm);
            if (FileUtil.absolutelyExists((String)string) && new File(string).isFile()) {
                tableItem.setText(1, string);
                tableItem.setChecked(this.integrator.isConfiguredWithDW(scm, new File(string)));
            } else {
                tableItem.setText(1, "No config file in default location. Click 'Browse' to locate.");
                tableItem.setChecked(false);
            }
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = tableItem.getText(1);
                    if (!FileUtil.absolutelyExists((String)string) || !new File(string).isFile()) {
                        tableItem.setChecked(false);
                    }
                }
            });
            ++n2;
        }
        this.table.getColumn(0).pack();
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void performHelp() {
        UIUtil.showHelp("general-scm-integration", UIUtil.HelpContext.PREF_PAGE);
    }

    public boolean performOk() {
        ScmIntegrator.Scm[] scmArray = ScmIntegrator.Scm.values();
        int n = scmArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScmIntegrator.Scm scm;
            ScmIntegrator.Scm scm2 = scm = scmArray[n2];
            TableItem tableItem = this.table.getItem(scm.ordinal());
            String string = tableItem.getText(1);
            File file = new File(string);
            if (FileUtil.absolutelyExists((String)string) && file.isFile()) {
                if (tableItem.getChecked()) {
                    this.integrator.cofigureWithDW(scm2, file);
                } else {
                    this.integrator.uncofigureDW(scm2, file);
                }
            }
            ++n2;
        }
        return true;
    }
}

