/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.dialogs;

import com.deltawalker.App;
import com.deltawalker.LocaleUtil;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.internal.ContextId;
import com.deltawalker.internal.ui.LogItemWorkbenchAdapter;
import com.deltawalker.ui.OverlayPrefStore;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltopia.io.IO;
import com.deltopia.io.IniFileUtil;
import com.deltopia.io.StreamUtil;
import com.deltopia.jface.util.DialogUtil;
import com.deltopia.jface.util.SelectionDialogUtil;
import com.deltopia.util.Const;
import com.deltopia.util.OS;
import com.deltopia.util.logging.LogUtil;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static Map<LogItemWorkbenchAdapter.Item, Level> item2level = new LinkedHashMap<LogItemWorkbenchAdapter.Item, Level>();
    private static final String LEVEL_SEGMENT = ".level=";
    private static final Logger LOG = LoggerFactory.getLogger(GeneralPrefPage.class);
    private static final OverlayPrefStore.OverlayKey[] OVERLAY_KEYS = new OverlayPrefStore.OverlayKey[]{new OverlayPrefStore.OverlayKey(OverlayPrefStore.BOOLEAN, PrefKey.C_CHECK_FOR_UPDATES.toString())};
    private Combo cbLocales;
    private final File iniFile = IniFileUtil.getWritableAppIniFile((boolean)EFS.getLocalFileSystem().isCaseSensitive());
    private Locale newLocale;
    private int newMemSize;
    private Locale oldLocale;
    private int oldMemSize;
    private final SelectionListener onSelect = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Widget widget = selectionEvent.widget;
            if (widget instanceof Button) {
                String string = (String)widget.getData();
                GeneralPrefPage.this.overlayPrefs.setValue(string, ((Button)widget).getSelection());
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    };
    private OverlayPrefStore overlayPrefs;
    private boolean restart = false;
    private Spinner spnMemory;

    static {
        item2level.put(LogItemWorkbenchAdapter.Item.DELTOPIA, Level.WARNING);
        item2level.put(LogItemWorkbenchAdapter.Item.DW_CORE, Level.WARNING);
        item2level.put(LogItemWorkbenchAdapter.Item.DW_APP, Level.WARNING);
        item2level.put(LogItemWorkbenchAdapter.Item.DW_FOLDER, Level.WARNING);
        item2level.put(LogItemWorkbenchAdapter.Item.DW_TEXT, Level.WARNING);
        item2level.put(LogItemWorkbenchAdapter.Item.DW_IMAGE, Level.WARNING);
        item2level.put(LogItemWorkbenchAdapter.Item.DW_VFS, Level.WARNING);
        item2level.put(LogItemWorkbenchAdapter.Item.DW_XML, Level.WARNING);
        item2level.put(LogItemWorkbenchAdapter.Item.DW_HTML, Level.WARNING);
    }

    private static String stripWhitespace(String string) {
        if (string == null) {
            throw new NullPointerException("str");
        }
        if (!string.isEmpty()) {
            string = string.replaceAll(" ", "");
            string = string.replaceAll("\\t", "");
        }
        return string;
    }

    private void configureLogger() {
        AdaptableList adaptableList = new AdaptableList();
        for (LogItemWorkbenchAdapter.Item item : item2level.keySet()) {
            adaptableList.add((IAdaptable)new LogItemWorkbenchAdapter(item, null));
        }
        Object[] objectArray = this.promptUser(this.getControl().getShell(), adaptableList);
        if (objectArray != null) {
            for (Map.Entry<LogItemWorkbenchAdapter.Item, Level> entry : item2level.entrySet()) {
                entry.setValue(Level.WARNING);
            }
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                item2level.put(((LogItemWorkbenchAdapter)object).item(), Level.INFO);
                ++n2;
            }
            this.writeLogConfiguration();
        }
    }

    private void createAutoUpdateControl(Composite composite) {
        Button button = DialogUtil.addButton(composite, UIMsg.GeneralPrefPage_autoUpdate, PrefKey.C_CHECK_FOR_UPDATES.toString(), null, 2, this.onSelect);
        button.setLayoutData((Object)new GridData(4, 1024, true, false));
    }

    private void createClearPasswordsControl(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(16384, 1024, false, false));
        button.setText(UIMsg.GeneralPrefPage_clearPwds);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String[] stringArray = new String[]{UIMsg.GeneralPrefPage_clearPwds, IDialogConstants.CANCEL_LABEL};
                int n = UIUtil.showConfirmActionPrompt(GeneralPrefPage.this.getShell(), UIMsg.GeneralPrefPage_clearPwdsMsg, stringArray);
                if (n != 1) {
                    String string = Platform.getInstanceLocation().getURL().getPath();
                    File file = new File(string, "secure_storage");
                    IO.fileSystem().delete(file, false);
                }
            }
        });
    }

    private void createConfigLoggerControl(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(16384, 1024, false, false));
        button.setText(UIMsg.GeneralPrefPage_configLogger);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GeneralPrefPage.this.configureLogger();
            }
        });
    }

    protected Control createContents(Composite composite) {
        UIUtil.setHelpContextId((Control)composite, ContextId.GENERAL_PREF_PAGE);
        this.overlayPrefs = new OverlayPrefStore(PrefUtil.getGlobalPrefs(), OVERLAY_KEYS);
        this.overlayPrefs.load();
        this.overlayPrefs.start();
        Composite composite2 = DialogUtil.createPageComposite(composite);
        this.createLocaleControls(composite2);
        DialogUtil.insertSpace(composite2);
        this.createAutoUpdateControl(composite2);
        DialogUtil.insertSpace(composite2, true);
        Composite composite3 = DialogUtil.createPageComposite(composite2);
        ((GridLayout)composite3.getLayout()).numColumns = 2;
        this.createConfigLoggerControl(composite3);
        this.createResetLogFilesControl(composite3);
        this.createClearPasswordsControl(composite2);
        Dialog.applyDialogFont((Control)composite2);
        DialogUtil.initializeFromPrefsAndNotify(this.getControl(), this.overlayPrefs);
        return composite2;
    }

    private void createLanuageCombo(Composite composite) {
        this.cbLocales = new Combo(composite, 8);
        this.cbLocales.setLayoutData((Object)new GridData(4, 128, true, false));
        final String[] stringArray = LocaleUtil.getDisplayLocaleNames();
        this.cbLocales.setItems(stringArray);
        this.initializeLocale(false);
        if (this.iniFile != null) {
            this.cbLocales.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n = GeneralPrefPage.this.cbLocales.getSelectionIndex();
                    if (n != -1) {
                        GeneralPrefPage.this.newLocale = LocaleUtil.getLocaleFromDisplayName(stringArray[n]);
                    }
                }
            });
        }
    }

    private void createLocaleControls(Composite composite) {
        Composite composite2 = DialogUtil.createPageComposite(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 2;
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText("Date formatting:");
        this.createLanuageCombo(composite2);
    }

    private void createMemoryControls(Composite composite) {
        Composite composite2 = DialogUtil.createPageComposite(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 3;
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText("Max available memory: ");
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GeneralPrefPage.this.newMemSize = ((Spinner)selectionEvent.widget).getSelection();
            }
        };
        this.spnMemory = new Spinner(composite2, 2048);
        this.spnMemory.addSelectionListener((SelectionListener)selectionAdapter);
        this.spnMemory.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.spnMemory.setMinimum(256);
        long l = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize() / 0x100000L;
        l = Math.max(1024L, l);
        this.spnMemory.setMaximum((int)l);
        this.spnMemory.setIncrement(10);
        this.spnMemory.setPageIncrement(256);
        this.initializeMemorySize(false);
        label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText("MB");
    }

    private void createResetLogFilesControl(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(16384, 1024, false, false));
        button.setText(UIMsg.GeneralPrefPage_clearLogs);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String[] stringArray = new String[]{UIMsg.GeneralPrefPage_clearLogs, IDialogConstants.CANCEL_LABEL};
                int n = UIUtil.showConfirmActionPrompt(GeneralPrefPage.this.getShell(), UIMsg.GeneralPrefPage_clearLogsMsg, stringArray);
                if (n != 1) {
                    Set set = LogUtil.getLogFiles();
                    for (File file : set) {
                        boolean bl = IO.fileSystem().delete(file, false);
                        if (!LOG.isInfoEnabled()) continue;
                        String string = bl ? " succeeded" : " failed";
                        LOG.info("Deleting " + file + string);
                    }
                }
            }
        });
    }

    private void createResetStateControl(Composite composite) {
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(16384, 1024, false, false));
        button.setText(UIMsg.GeneralPrefPage_resetState);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String[] stringArray = new String[]{UIMsg.GeneralPrefPage_resetState, IDialogConstants.CANCEL_LABEL};
                int n = UIUtil.showConfirmActionPrompt(GeneralPrefPage.this.getShell(), UIMsg.GeneralPrefPage_resetStateMsg, stringArray);
                if (n != 1) {
                    String string = Platform.getInstanceLocation().getURL().getPath();
                    File file = new File(string, "state.dws");
                    boolean bl = IO.fileSystem().delete(file, false);
                    if (LOG.isInfoEnabled()) {
                        String string2 = bl ? " succeeded" : " failed";
                        LOG.info("Deleting " + file + string2);
                    }
                    if (bl) {
                        App.instance().stateBoss().loadState(null);
                    }
                }
            }
        });
    }

    public void dispose() {
        try {
            this.overlayPrefs.stop();
        }
        finally {
            super.dispose();
        }
    }

    private LogItemWorkbenchAdapter findAdapter(AdaptableList adaptableList, LogItemWorkbenchAdapter.Item item) {
        LogItemWorkbenchAdapter[] logItemWorkbenchAdapterArray;
        LogItemWorkbenchAdapter[] logItemWorkbenchAdapterArray2 = logItemWorkbenchAdapterArray = (LogItemWorkbenchAdapter[])adaptableList.getTypedChildren(LogItemWorkbenchAdapter.class);
        int n = logItemWorkbenchAdapterArray.length;
        int n2 = 0;
        while (n2 < n) {
            LogItemWorkbenchAdapter logItemWorkbenchAdapter = logItemWorkbenchAdapterArray2[n2];
            if (logItemWorkbenchAdapter.item() == item) {
                return logItemWorkbenchAdapter;
            }
            ++n2;
        }
        return null;
    }

    private Level getLevel(String string) {
        int n = string.indexOf(LEVEL_SEGMENT);
        if (n != -1) {
            String string2 = string.substring(n + LEVEL_SEGMENT.length(), string.length());
            return Level.fromString(string2);
        }
        return Level.SEVERE;
    }

    private String getName(String string) {
        int n = string.indexOf(LEVEL_SEGMENT);
        if (n != -1) {
            return string.substring(0, n);
        }
        return "";
    }

    public void init(IWorkbench iWorkbench) {
    }

    private void initializeLocale(boolean bl) {
        String string;
        Locale locale = LocaleUtil.getLocale("en_US");
        if (bl || this.iniFile == null) {
            int n = this.cbLocales.indexOf(locale.getDisplayName());
            this.cbLocales.select(n != -1 ? n : 0);
            if (this.iniFile == null) {
                this.cbLocales.setEnabled(false);
            }
            return;
        }
        if (!bl && !(string = IniFileUtil.getValueForName((File)this.iniFile, (String)"", (String)"-nl", (boolean)true)).isEmpty()) {
            locale = LocaleUtil.getLocale(string);
        }
        this.oldLocale = this.newLocale = locale;
        int n = this.cbLocales.indexOf(locale.getDisplayName());
        this.cbLocales.select(n != -1 ? n : 0);
    }

    private void initializeMemorySize(boolean bl) {
        int n;
        int n2 = n = OS.X86_64 ? 4096 : 1024;
        if (bl || this.iniFile == null) {
            this.spnMemory.setSelection(n);
            if (this.iniFile == null) {
                this.spnMemory.setEnabled(false);
            }
            return;
        }
        assert (this.iniFile.isFile());
        if (!bl && this.iniFile.isFile()) {
            String string = IniFileUtil.getValueForName((File)this.iniFile, (String)"", (String)Const.XMX, (boolean)false);
            assert (!string.isEmpty());
            if (!string.isEmpty()) {
                String string2 = string.substring(Const.XMX.length(), string.length() - "m".length());
                n = Integer.parseInt(string2);
            }
        }
        this.oldMemSize = this.newMemSize = n;
        this.spnMemory.setSelection(n);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeMemorySize(true);
        this.initializeLocale(true);
        this.overlayPrefs.loadDefaults();
        DialogUtil.initializeFromPrefsAndNotify(this.getControl(), this.overlayPrefs);
        App.instance().stateBoss().saveState();
    }

    public void performHelp() {
        UIUtil.showHelp("general", UIUtil.HelpContext.PREF_PAGE);
    }

    public boolean performOk() {
        this.writeMemorySize();
        this.writeLocale();
        this.overlayPrefs.propagate();
        App.instance().stateBoss().saveState();
        if (this.restart) {
            String[] stringArray;
            boolean bl = true;
            if (bl) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = IDialogConstants.OK_LABEL;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = UIMsg.UIUtil_restartNow;
                stringArray = stringArray3;
                stringArray3[1] = UIMsg.UIUtil_restartLater;
            }
            String[] stringArray4 = stringArray;
            int n = UIUtil.showRestartPrompt(this.getShell(), UIMsg.GeneralPrefPage_restart, stringArray4);
            if (!bl && n == 0) {
                Display.getDefault().timerExec(500, new Runnable(){

                    @Override
                    public void run() {
                        PlatformUI.getWorkbench().restart();
                    }
                });
            }
        }
        return true;
    }

    private Object[] promptUser(Shell shell, AdaptableList adaptableList) {
        if (adaptableList.size() <= 0) {
            return Const.EMPTY_OBJECT_ARRAY;
        }
        this.readLogConfiguration();
        SelectionDialog selectionDialog = SelectionDialogUtil.createSelectionDialog(shell, adaptableList, (ITreeContentProvider)new BaseWorkbenchContentProvider(), (ILabelProvider)new LabelProvider(), UIMsg.GeneralPrefPage_dlgSubTitle, "OK", null, true);
        LinkedList<LogItemWorkbenchAdapter> linkedList = new LinkedList<LogItemWorkbenchAdapter>();
        for (Map.Entry<LogItemWorkbenchAdapter.Item, Level> entry : item2level.entrySet()) {
            if (entry.getValue() != Level.INFO) continue;
            linkedList.add(this.findAdapter(adaptableList, entry.getKey()));
        }
        selectionDialog.setInitialSelections(linkedList.toArray());
        selectionDialog.setTitle("Configure Logger");
        selectionDialog.open();
        return selectionDialog.getResult();
    }

    private void readLogConfiguration() {
        File file = LogUtil.configFile();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    String string2 = this.getName(GeneralPrefPage.stripWhitespace(string));
                    if (string2.isEmpty() || !item2level.containsKey((Object)LogItemWorkbenchAdapter.Item.fromPluginName(string2))) continue;
                    Level level = this.getLevel(string);
                    item2level.put(LogItemWorkbenchAdapter.Item.fromPluginName(string2), level);
                }
                System.out.println(item2level);
            }
            catch (Throwable throwable) {
                LOG.error("Couldn't read name/value pair", throwable);
            }
            StreamUtil.closeSilently((Closeable)bufferedReader);
        }
        catch (Throwable throwable) {
            LOG.error("Couldn't write name/value pair", throwable);
        }
        LogUtil.loadConfiguration();
    }

    private void writeLocale() {
        if (this.iniFile == null) {
            return;
        }
        if (!this.newLocale.equals(this.oldLocale)) {
            IniFileUtil.setNameValuePair((File)this.iniFile, (String)"", (String)"-nl", (String)this.newLocale.toString(), (String)Const.LINE_ENDING);
            this.restart = true;
        }
    }

    private void writeLogConfiguration() {
        File file = LogUtil.configFile();
        LinkedHashMap<LogItemWorkbenchAdapter.Item, Level> linkedHashMap = new LinkedHashMap<LogItemWorkbenchAdapter.Item, Level>();
        linkedHashMap.putAll(item2level);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            PrintWriter printWriter = null;
            try {
                String string;
                String string2 = "";
                while ((string = bufferedReader.readLine()) != null) {
                    String object = this.getName(GeneralPrefPage.stripWhitespace(string));
                    if (!object.isEmpty() && linkedHashMap.containsKey((Object)LogItemWorkbenchAdapter.Item.fromPluginName(object))) {
                        Object object2 = LogItemWorkbenchAdapter.Item.fromPluginName(object);
                        string2 = String.valueOf(string2) + object + LEVEL_SEGMENT + linkedHashMap.get(object2) + Const.LINE_ENDING;
                        linkedHashMap.remove(object2);
                        continue;
                    }
                    string2 = String.valueOf(string2) + string + Const.LINE_ENDING;
                }
                if (!linkedHashMap.isEmpty()) {
                    for (Map.Entry entry : linkedHashMap.entrySet()) {
                        string2 = String.valueOf(string2) + ((LogItemWorkbenchAdapter.Item)((Object)entry.getKey())).pluginName() + LEVEL_SEGMENT + entry.getValue() + Const.LINE_ENDING + Const.LINE_ENDING;
                    }
                }
                printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file)));
                printWriter.print(string2);
            }
            catch (Throwable throwable) {
                LOG.error("Couldn't write name/value pair", throwable);
            }
            StreamUtil.closeSilently((Closeable)bufferedReader);
            StreamUtil.closeSilently(printWriter);
        }
        catch (Throwable throwable) {
            LOG.error("Couldn't write name/value pair", throwable);
        }
        LogUtil.loadConfiguration();
    }

    private void writeMemorySize() {
        if (this.iniFile == null) {
            return;
        }
        if (this.newMemSize != this.oldMemSize) {
            IniFileUtil.setNameValuePair((File)this.iniFile, (String)"", (String)Const.XMX, (String)(String.valueOf(Integer.toString(this.newMemSize)) + 'm'), (String)"");
            this.restart = true;
        }
    }

    public static enum Level {
        FINE("FINE"),
        INFO("INFO"),
        SEVERE("SEVERE"),
        WARNING("WARNING");

        private static Map<String, Level> str2enum;
        private final String dispName;

        static {
            str2enum = new HashMap<String, Level>();
            Level[] levelArray = Level.values();
            int n = levelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Level level = levelArray[n2];
                str2enum.put(level.dispName, level);
                ++n2;
            }
        }

        public static Level fromString(String string) {
            return str2enum.get(string);
        }

        private Level(String string2) {
            this.dispName = string2;
        }

        public String displayName() {
            return this.dispName;
        }
    }
}

