/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.dialogs;

import com.deltawalker.UriInfo;
import com.deltawalker.ui.FileDialogExtensionComposite;
import com.deltopia.StringUtil;
import com.deltopia.io.TextEncoding;
import com.deltopia.ui.swt.DefaultFileDialog;
import com.deltopia.util.Checker;
import java.io.File;
import java.util.Locale;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FileDialogEx
extends DefaultFileDialog {
    private FileDialogExtensionComposite cmpExtension;
    private FileDialogExtensionDialog dlgExtension;
    private TextEncoding encoding;
    private String ending;
    private Locale locale;
    private final IPreferenceStore prefs;
    private boolean showEnding = true;
    private boolean showOpenInBrowser = false;
    private String title;
    private boolean useStandaloneExtension;

    public static String chooseFilterPath(UriInfo uriInfo, String string, IPreferenceStore iPreferenceStore) {
        String string2 = uriInfo.uri();
        if (!uriInfo.isEmpty()) {
            return string2;
        }
        if (StringUtil.isEmpty((String)(string2 = new Path(string2).removeLastSegments(1).toOSString())) && !(uriInfo = new UriInfo(string2 = iPreferenceStore.getString(UriInfo.constructMruName(string)))).isEmpty()) {
            return new Path(string2).removeLastSegments(1).toOSString();
        }
        return string2;
    }

    public FileDialogEx(Shell shell, int n, IPreferenceStore iPreferenceStore) {
        super(shell, n);
        this.prefs = iPreferenceStore;
    }

    protected void configureButton(int n, Button button) {
    }

    protected void configureShell(Shell shell) {
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite composite, int n, Object object) {
        this.cmpExtension = new FileDialogExtensionComposite(composite, n, object, this.prefs);
        this.cmpExtension.setShowLineEnding(this.showEnding);
        this.cmpExtension.setShowOpenInBrowser(this.showOpenInBrowser);
        if (this.encoding != null) {
            this.cmpExtension.setSelectedEncoding(this.encoding);
        }
        if (this.locale != null) {
            this.cmpExtension.setSelectedLocale(this.locale);
        }
        if (!StringUtil.isEmpty((String)this.ending)) {
            this.cmpExtension.setSelectedLineEnding(this.ending);
        }
        return this.cmpExtension;
    }

    public TextEncoding getSelectedEncoding(boolean bl) {
        return this.cmpExtension == null ? this.encoding : this.cmpExtension.getSelectedEncoding(bl);
    }

    public String getSelectedLineEnding() {
        return this.cmpExtension == null ? this.ending : this.cmpExtension.getSelectedLineEnding();
    }

    public Locale getSelectedLocale() {
        return this.cmpExtension == null ? null : this.cmpExtension.getSelectedLocale();
    }

    public boolean isCharsetSelected() {
        return this.cmpExtension == null ? true : this.cmpExtension.isCharsetSelected();
    }

    public String open() {
        if (this.useStandaloneExtension && !this.isExtensible() && this.dlgExtension == null) {
            this.dlgExtension = new FileDialogExtensionDialog(this.getParentShell());
            this.dlgExtension.open();
            return this.dlgExtension.getFileName();
        }
        return super.open();
    }

    public void setFilePath(String string) {
        if (!StringUtil.isEmpty((String)(string = new File(string).getName()))) {
            super.setFilePath(string);
        }
    }

    public void setFilterPath(String string) {
        File file = new File(string);
        String string2 = file.isFile() ? file.getParent() : (file.isDirectory() ? file.getPath() : null);
        if (!StringUtil.isEmpty((String)string2)) {
            super.setFilterPath(string2);
        }
    }

    public void setSelectedEncoding(TextEncoding textEncoding) {
        this.encoding = (TextEncoding)Checker.notNull((Object)textEncoding, (String)"encoding");
    }

    public void setSelectedLineEnding(String string) {
        this.ending = string;
    }

    public void setSelectedLocale(Locale locale) {
        this.locale = locale;
    }

    public void setShowLineEnding(boolean bl) {
        if (this.cmpExtension != null) {
            this.cmpExtension.setShowLineEnding(bl);
        }
        this.showEnding = bl;
    }

    public void setShowOpenInBrowser(boolean bl) {
        if (this.cmpExtension != null) {
            this.cmpExtension.setShowOpenInBrowser(bl);
        }
        this.showOpenInBrowser = bl;
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this.title = string;
    }

    public void setUseStandaloneExtensionDialog(boolean bl) {
        this.useStandaloneExtension = bl;
    }

    private class FileDialogExtensionDialog
    extends TrayDialog {
        private String fileName;

        public FileDialogExtensionDialog(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            FileDialogEx.this.configureShell(shell);
            this.setHelpAvailable(false);
        }

        protected Button createButton(Composite composite, int n, String string, boolean bl) {
            Button button = super.createButton(composite, n, string, bl);
            if (button != null) {
                FileDialogEx.this.configureButton(n, button);
                this.setButtonLayoutData(button);
            }
            return button;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            Control control = FileDialogEx.this.createDialogArea(composite2, 0, null);
            if (control != null) {
                control.setLayoutData((Object)new GridData(4, 4, true, true));
            }
            return composite2;
        }

        public String getFileName() {
            return this.getReturnCode() == 0 ? this.fileName : null;
        }

        protected int getShellStyle() {
            return super.getShellStyle() | 0x10;
        }

        protected void okPressed() {
            String string = FileDialogEx.this.open();
            if (string != null) {
                super.okPressed();
            } else {
                this.cancelPressed();
            }
            this.fileName = string;
        }
    }
}

