/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.dialogs;

import com.deltawalker.App;
import com.deltawalker.FilterTable;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.dialogs.PrefProviderPage;
import com.deltopia.jface.util.DialogUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class BaseFiltersPrefPage
extends PrefProviderPage
implements IWorkbenchPreferencePage {
    protected FilterTable filterTable;
    protected IFilters overlayFilters;
    protected ToolBar toolBar;

    protected IFilters activeFilters() {
        IFilters iFilters = this.isSessionPage() ? this.activeView.getInput().filters() : App.instance().filterBoss().getDefaultFilters(this.docType());
        return iFilters;
    }

    protected void addFilterControls(Composite composite) {
    }

    protected void addToolBarItems() {
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = DialogUtil.createPageComposite(composite);
        this.createToolBar(composite2);
        this.createFilterControls(composite2);
        this.applyDialogFont(composite2);
        this.updateToolBarItems();
        return composite2;
    }

    private Composite createFilterControls(Composite composite) {
        this.createFilterTable(composite);
        this.addFilterControls(composite);
        this.showPrefsAlert(composite, true, this.isSessionPage(), false);
        return composite;
    }

    protected abstract void createFilterTable(Composite var1);

    private void createToolBar(Composite composite) {
        ToolItem[] toolItemArray;
        this.toolBar = new ToolBar(composite, 8519744);
        GridData gridData = new GridData(131072, 128, false, false);
        this.toolBar.setLayoutData((Object)gridData);
        ToolItem toolItem = new ToolItem(this.toolBar, this.getNewItemStyle());
        toolItem.setText(Item.NEW.toString());
        ToolItem toolItem2 = new ToolItem(this.toolBar, 8);
        toolItem2.setText(Item.EDIT.text);
        ToolItem toolItem3 = new ToolItem(this.toolBar, 8);
        toolItem3.setText(Item.DELETE.text);
        this.addToolBarItems();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ToolItem toolItem = (ToolItem)event.widget;
                int n = BaseFiltersPrefPage.this.toolBar.indexOf(toolItem);
                if (n == Item.NEW.id) {
                    BaseFiltersPrefPage.this.handleNew(toolItem);
                } else if (n == Item.EDIT.id) {
                    BaseFiltersPrefPage.this.handleEdit();
                } else if (n == Item.DELETE.id) {
                    BaseFiltersPrefPage.this.deleteSelectedFilter();
                }
            }
        };
        ToolItem[] toolItemArray2 = toolItemArray = this.toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem toolItem4 = toolItemArray2[n2];
            toolItem4.addListener(13, listener);
            ++n2;
        }
        this.toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (!BaseFiltersPrefPage.this.toolBar.isDisposed()) {
                    ToolItem[] toolItemArray;
                    ToolItem[] toolItemArray2 = toolItemArray = BaseFiltersPrefPage.this.toolBar.getItems();
                    int n = toolItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ToolItem toolItem = toolItemArray2[n2];
                        if (!toolItem.isDisposed()) {
                            toolItem.setControl(null);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private void deleteSelectedFilter() {
        IFilter iFilter = this.selectedFilter();
        if (iFilter != null) {
            int n = this.filterTable.getSelectionIndex();
            this.overlayFilters().remove(iFilter);
            this.filterTable.refresh(null);
            this.filterTable.setSelectionIndex(n);
            this.updateToolBarItems();
        }
    }

    protected int getNewItemStyle() {
        return 8;
    }

    protected abstract void handleEdit();

    protected abstract void handleNew(ToolItem var1);

    public void init(IWorkbench iWorkbench) {
    }

    @Override
    protected boolean canBeSessionPage() {
        return true;
    }

    protected IFilters overlayFilters() {
        if (this.overlayFilters == null) {
            this.overlayFilters = this.activeFilters().clone();
        }
        return this.overlayFilters;
    }

    protected void performDefaults() {
        try {
            this.overlayFilters = App.instance().filterBoss().getFactoryDefaultFilters(this.docType()).clone();
            this.filterTable.setFilters(this.overlayFilters);
        }
        finally {
            super.performDefaults();
        }
    }

    protected IFilter selectedFilter() {
        return this.filterTable.getSelection();
    }

    public void setSelection(IFilter iFilter) {
        this.filterTable.setSelection(iFilter);
    }

    protected void showFilterDialog(boolean bl) {
    }

    protected void updateToolBarItems() {
    }

    protected static enum Item {
        DELETE(UIMsg.BaseFiltersPrefPage_delete, 2),
        DOWN("", 4),
        EDIT(UIMsg.BaseFiltersPrefPage_edit, 1),
        NEW(UIMsg.BaseFiltersPrefPage_new, 0),
        SEPARATOR("", 3),
        UP("", 5);

        private final int id;
        private final String text;

        private Item(String string2, int n2) {
            this.text = string2;
            this.id = n2;
        }

        public int id() {
            return this.id;
        }

        public String toString() {
            return this.text;
        }
    }
}

