/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.dialogs;

import com.deltawalker.ui.Alert;
import com.deltawalker.ui.AlertService;
import com.deltawalker.ui.IAlert;
import com.deltawalker.ui.IAlertService;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AlertTrayDialog
extends TrayDialog {
    private String alertKey;
    private IAlertService alertService = new AlertService();
    private Control cmpAlert;

    protected AlertTrayDialog(IShellProvider iShellProvider) {
        super(iShellProvider);
    }

    protected AlertTrayDialog(Shell shell) {
        super(shell);
    }

    public IAlert alert() {
        return this.alertService.getAlert(this.alertKey);
    }

    public void showAlert(boolean bl, String string, int n) {
        if (!bl) {
            this.alertService.removeAlert(this.alertKey);
            this.getShell().pack();
            return;
        }
        IAlert iAlert = this.alertService.getAlert(this.alertKey);
        if (!(iAlert == null || iAlert.getStyle() == n && string.equals(iAlert.getText()))) {
            this.alertService.removeAlert(this.alertKey);
            iAlert = null;
        }
        if (iAlert != null) {
            iAlert.setText(string);
        } else {
            iAlert = new Alert(null, string, n);
            this.alertKey = this.alertService.addAlert(iAlert);
            this.showAlertControl();
        }
    }

    private void showAlertControl() {
        Shell shell = this.getShell();
        Point point = shell.getSize();
        Composite composite = (Composite)this.getDialogArea();
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.cmpAlert == null || this.cmpAlert.isDisposed()) {
            this.cmpAlert = this.alertService.createControl(composite, 0);
        }
        Point point2 = this.cmpAlert.computeSize(point.x, -1, true);
        if (point2.x == 0 || point2.y == 0) {
            this.cmpAlert.setVisible(false);
        } else {
            this.cmpAlert.setVisible(true);
            this.cmpAlert.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        point.y = shell.computeSize((int)-1, (int)-1).y;
        shell.setSize(point);
        shell.layout(true, true);
    }
}

