/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.dialogs;

import com.deltawalker.Addon;
import com.deltawalker.AddonException;
import com.deltawalker.AddonInfo;
import com.deltawalker.AddonInfoUtil;
import com.deltawalker.App;
import com.deltawalker.MissingInfoAddonException;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.internal.ContextId;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.UserInfoDialog;
import com.deltopia.StringUtil;
import com.deltopia.jface.util.DialogUtil;
import com.deltopia.net.HttpSubmitter;
import com.deltopia.util.OS;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddonInfoDialog
extends UserInfoDialog {
    private static final Logger LOG = LoggerFactory.getLogger(AddonInfoDialog.class);
    private static final Pattern REGEX_EMAIL = Pattern.compile(".+@.{2,}\\..{2,}");
    private Button chbCanEmail;
    private IPreferenceStore prefs;
    private RegisterTask registerTask = null;
    protected Text txtKey;
    protected boolean userInfoUI = true;

    public AddonInfoDialog(Shell shell, AddonInfo addonInfo) {
        super(shell);
        this.info = addonInfo;
        this.prefs = PrefUtil.getGlobalPrefs();
    }

    public AddonInfo addonInfo() {
        return this.info;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, ContextId.INSTALL_LICENSE_DIALOG);
            shell.setText(UIMsg.InstallLicenseAction_toolTip);
        } else {
            shell.setText(UIMsg.InstallLicenseAction_toolTipMas);
        }
    }

    private final void copyParam(AddonInfo.Param param, Map<String, String> map) {
        String string = this.info.paramValueAsString(param);
        if (!string.isEmpty()) {
            map.put(param.compatibilityString(), string);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.validateAndShowStatus(true);
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        if (this.userInfoUI) {
            this.setTitle(UIMsg.AddonInfoDlg_subTitle);
            this.setMessage(UIMsg.AddonInfoDlg_msg);
            Control[] controlArray = new Control[1];
            this.txtKey = this.createTextControl(composite2, AddonInfo.Param.KEY, 4, controlArray);
            this.initializeLicenseField(this.info);
            this.txtKey.setBackground(this.clrRequired);
            DialogUtil.insertSpace(composite2, false, 2);
            Label label = new Label(composite2, 64);
            GridData gridData = new GridData(4, 128, true, false);
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
            label.setText(UIMsg.AddonInfoDlg_personalize);
            this.txtName = this.createTextControl(composite2, AddonInfo.Param.NAME, 4);
            this.txtEmail = this.createTextControl(composite2, AddonInfo.Param.EMAIL, 4);
            this.txtCompany = this.createTextControl(composite2, AddonInfo.Param.FIRM, 4);
            this.txtCompany.setBackground(this.clrOptional);
            new Label(composite2, 0);
            this.chbCanEmail = new Button(composite2, 32);
            gridData = new GridData(4, 128, true, false);
            gridData.horizontalAlignment = 0;
            this.chbCanEmail.setLayoutData((Object)gridData);
            this.chbCanEmail.setText(UIMsg.AddonInfoDlg_emailMe);
            this.chbCanEmail.setSelection(this.prefs.getBoolean(PrefKey.C_CAN_EMAIL.toString()));
            this.chbCanEmail.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = AddonInfoDialog.this.chbCanEmail.getSelection();
                    if (bl != AddonInfoDialog.this.prefs.getBoolean(PrefKey.C_CAN_EMAIL.toString())) {
                        AddonInfoDialog.this.prefs.setValue(PrefKey.C_CAN_EMAIL.toString(), bl);
                        AddonInfoDialog.this.setSendInfo(bl);
                        AddonInfoDialog.this.validateAndShowStatus(false);
                    }
                }
            });
            this.installListeners();
        }
        return composite2;
    }

    @Override
    protected void enableInfoControls(boolean bl) {
        super.enableInfoControls(bl);
        this.chbCanEmail.setEnabled(bl);
    }

    private void enableOK(boolean bl) {
        Button button = this.getButton(0);
        if (button != null) {
            this.getButton(0).setEnabled(bl);
        }
    }

    private boolean getSendInfo() {
        return this.prefs.getBoolean(PrefKey.C_SEND_REG_INFO.toString());
    }

    @Override
    protected int getShellStyle() {
        return super.getShellStyle() | 0x10 | 0x10000000;
    }

    protected void helpPressed() {
        UIUtil.showHelp("install-license-key", UIUtil.HelpContext.DIALOG);
    }

    protected void initializeLicenseField(AddonInfo addonInfo) {
        String string = addonInfo.paramValueAsString(AddonInfo.Param.KEY);
        if (string.equals("MC0CFCha-B6VCxE8D-L3yQ8zCZ-PUtb+F3E-AhUAkWkQ-SHKG7umL-TYEmVDg/-menFts0=")) {
            this.txtKey.setBackground(this.clrRequired);
        } else {
            this.txtKey.setText(addonInfo.paramValueAsString(AddonInfo.Param.KEY));
        }
    }

    protected void installListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                Text text = (Text)modifyEvent.widget;
                AddonInfo.Param param = (AddonInfo.Param)((Object)text.getData());
                if (param == null) {
                    return;
                }
                String string = text.getText();
                if (param == AddonInfo.Param.KEY) {
                    if (!(string = string.replaceAll("\\s", "")).equals(AddonInfoDialog.this.info.paramValueAsString(AddonInfo.Param.KEY))) {
                        AddonInfoDialog.this.info.setParamValue(param, string);
                        if (AddonInfoDialog.this.info.edition() == Addon.Edition.TRIAL) {
                            AddonInfoDialog.this.info.setParamValue(AddonInfo.Param.TIME, Calendar.getInstance().getTimeInMillis());
                        }
                    }
                } else {
                    AddonInfoDialog.this.info.setParamValue(param, string);
                }
                AddonInfoDialog.this.setSendInfo(true);
                AddonInfoDialog.this.validateAndShowStatus(false);
                if (!OS.LINUX) {
                    Control[] controlArray;
                    Control[] controlArray2 = controlArray = ((Composite)AddonInfoDialog.this.dialogArea).getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray2[n2];
                        if (text != control) {
                            control.setFocus();
                            text.setFocus();
                        }
                        ++n2;
                    }
                }
            }
        };
        this.txtName.addModifyListener(modifyListener);
        this.txtEmail.addModifyListener(modifyListener);
        this.txtCompany.addModifyListener(modifyListener);
        this.txtKey.addModifyListener(modifyListener);
        this.txtKey.addMouseListener((MouseListener)new MouseAdapter(){
            private boolean hadSelection = false;

            public void mouseDown(MouseEvent mouseEvent) {
                if (AddonInfoDialog.this.txtKey.getSelectionText().trim().length() == 0) {
                    AddonInfoDialog.this.txtKey.selectAll();
                    this.hadSelection = false;
                } else {
                    this.hadSelection = true;
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (!this.hadSelection && AddonInfoDialog.this.txtKey.getSelectionText().trim().isEmpty()) {
                    AddonInfoDialog.this.txtKey.selectAll();
                }
            }
        });
    }

    protected boolean isDisplayRequired(AddonInfo.Param param) {
        return param.isRequired();
    }

    protected void okPressed() {
        if (this.validateAndShowStatus(false)) {
            if (this.getSendInfo()) {
                AddonInfoUtil.save();
                this.sendRegistration();
            }
            super.okPressed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendRegistration() {
        RegisterTask registerTask;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.copyParam(AddonInfo.Param.KEY, hashMap);
        this.copyParam(AddonInfo.Param.NAME, hashMap);
        this.copyParam(AddonInfo.Param.EMAIL, hashMap);
        this.copyParam(AddonInfo.Param.FIRM, hashMap);
        boolean bl = this.prefs.getBoolean(PrefKey.C_CAN_EMAIL.toString());
        hashMap.put("canEmail", Boolean.toString(bl));
        hashMap.put("version", App.instance().version());
        Object object = this;
        synchronized (object) {
            if (this.registerTask != null) {
                throw new IllegalStateException("Already sending registration info.");
            }
            this.registerTask = registerTask = new RegisterTask(hashMap, this.prefs);
        }
        object = new Thread((Runnable)registerTask, "Registration task");
        ((Thread)object).start();
    }

    private void setSendInfo(boolean bl) {
        this.prefs.setValue(PrefKey.C_SEND_REG_INFO.toString(), bl);
    }

    protected boolean validateAndShowStatus(boolean bl) {
        int n;
        int n2;
        String string;
        AddonException addonException = null;
        boolean bl2 = true;
        try {
            this.info.validate();
            this.info.addon();
        }
        catch (MissingInfoAddonException missingInfoAddonException) {
            addonException = missingInfoAddonException;
        }
        catch (AddonException addonException2) {
            addonException = addonException2;
            bl2 = false;
        }
        if (bl2) {
            String string2;
            this.enableInfoControls(true);
            this.setErrorMessage(null);
            string = UIMsg.AddonInfoDlg_installNew;
            if (this.info.edition() == Addon.Edition.TRIAL) {
                this.txtKey.setBackground(this.clrRequired);
                string2 = String.valueOf(AddonInfoUtil.constructReminderMessage()) + ".\n" + string;
                this.setMessage(string2);
                n2 = string2.indexOf("Your DeltaWalker");
                n = string2.indexOf(".\n", n2);
                this.makeMessageBold(n2, n);
            } else {
                this.txtKey.setBackground(this.clrOptional);
                string2 = this.info.edition().displayName();
                String string3 = String.valueOf(NLS.bind((String)UIMsg.AddonInfoDlg_validated, (Object)string2)) + string;
                this.setMessage(string3);
                n = string3.indexOf(".\n");
                this.makeMessageBold(0, n != -1 ? n : string3.length());
            }
        } else {
            this.txtKey.setBackground(this.clrRequired);
            this.txtKey.redraw();
            this.enableInfoControls(false);
        }
        if (addonException != null) {
            string = this.getErrorMessage(addonException);
            if (!bl && StringUtil.isEmpty((String)string)) {
                string = UIMsg.AddonException_invalidKey;
            }
            this.setErrorMessage(string);
            int n3 = string.indexOf("The specified");
            n2 = string.indexOf("\n", n3);
            this.makeMessageBold(n3 != -1 ? n3 : 0, n2 != -1 ? n2 : string.length());
        }
        boolean bl3 = (string = this.info.paramValueAsString(AddonInfo.Param.NAME)).length() >= 2;
        this.txtName.setBackground(bl3 ? this.clrOptional : this.clrRequired);
        String string4 = this.info.paramValueAsString(AddonInfo.Param.EMAIL);
        n = REGEX_EMAIL.matcher(string4).matches() ? 1 : 0;
        this.txtEmail.setBackground(n != 0 ? this.clrOptional : this.clrRequired);
        boolean bl4 = this.getSendInfo();
        this.enableOK(bl2 && bl3 && n != 0 && bl4);
        return bl2;
    }

    private static final class RegisterTask
    implements Runnable {
        private final Map<String, String> params;
        private IPreferenceStore prefs;

        private RegisterTask(Map<String, String> map, IPreferenceStore iPreferenceStore) {
            this.params = map;
            this.prefs = iPreferenceStore;
        }

        @Override
        public void run() {
            try {
                URL uRL = new URL("https://www.deltopia.com/uploads/registration");
                HttpSubmitter.postRequest((URL)uRL, this.params);
                this.prefs.setValue(PrefKey.C_SEND_REG_INFO.toString(), true);
            }
            catch (IOException iOException) {
                LOG.error("Cannot send registration", (Throwable)iOException);
            }
        }
    }
}

