/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.DocType;
import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.Msg;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.DropdownMenuAction;
import com.deltawalker.ui.actions.TogglePrefAction;
import com.deltopia.util.OS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.IUpdate;

public class TogglePrefsAction
extends DropdownMenuAction
implements IUpdate {
    public TogglePrefsAction(ResourceBundle resourceBundle, IWorkbenchWindow iWorkbenchWindow) {
        super(resourceBundle, "TogglePrefsAction.", iWorkbenchWindow);
        if (OS.COCOA) {
            this.setImageDescriptor(ImageCache.getImageDescriptor(ImageConst.PREFS_32));
        }
        this.setId("selectedPrefs");
    }

    private IAction getDefaultAction() {
        return UIUtil.actionAdvisor().getAction("openPrefs");
    }

    @Override
    protected List<IAction> getMenuActions() {
        DiffView diffView = this.deltaView();
        if (diffView == null) {
            return Collections.emptyList();
        }
        ArrayList<IAction> arrayList = new ArrayList<IAction>(4);
        ResourceBundle resourceBundle = Msg.constructedKeyBundle();
        IDiffDoc iDiffDoc = diffView.getInput();
        DocType docType = iDiffDoc.docType();
        IPreferenceStore iPreferenceStore = iDiffDoc.preferences();
        if (docType == DocType.FOLDER || docType.isText()) {
            arrayList.add((IAction)new TogglePrefAction(resourceBundle, "TogglePrefAction_ignoreWhitespace.", iPreferenceStore, PrefKey.C_IGNORE_WHITESPACE.toString()));
            arrayList.add((IAction)new TogglePrefAction(resourceBundle, "TogglePrefAction_ignoreEndings.", iPreferenceStore, PrefKey.C_IGNORE_LINE_ENDINGS.toString()));
            arrayList.add((IAction)new TogglePrefAction(resourceBundle, "TogglePrefAction_ignoreCase.", iPreferenceStore, PrefKey.C_IGNORE_CHAR_CASE.toString()));
            arrayList.add(null);
        }
        if (docType.isText()) {
            arrayList.add((IAction)new TogglePrefAction(resourceBundle, "TogglePrefAction_wrapLines.", iPreferenceStore, PrefKey.T_WRAP_LINES.toString()));
            IPreferenceStore iPreferenceStore2 = EditorsUI.getPreferenceStore();
            arrayList.add((IAction)new TogglePrefAction(resourceBundle, "TogglePrefAction_showWhitespace.", iPreferenceStore2, "showWhitespaceCharacters"));
            arrayList.add((IAction)new TogglePrefAction(resourceBundle, "TogglePrefAction_showInlineDiffs.", iPreferenceStore, PrefKey.T_DO_INLINE_DELTAS.toString()));
            arrayList.add(null);
        }
        boolean bl = !diffView.getInput().isWorking();
        for (IAction iAction : arrayList) {
            if (iAction == null) continue;
            iAction.setEnabled(bl);
        }
        arrayList.add(this.getDefaultAction());
        return arrayList;
    }

    @Override
    public void runWithEvent(Event event) {
        PrefUtil.openPrefDialogOn(null, null, null);
    }

    @Override
    public void update() {
        boolean bl = this.deltaView() != null && this.deltaView().getInput().isWorking();
        this.setEnabled(bl);
    }
}

