/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.App;
import com.deltawalker.Relation;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.actions.MenuAction;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.texteditor.IUpdate;

public class SwapMenuAction
extends MenuAction
implements IUpdate {
    public SwapMenuAction(ResourceBundle resourceBundle, int n, DiffView diffView) {
        super(resourceBundle, "SwapMenu" + n + "Action.", n, diffView);
        this.setId(n == 0 ? "swapMenu0" : "swapMenu1");
        this.setActionDefinitionId(n == 0 ? "com.deltawalker.ui.file.swapMenu0" : "com.deltawalker.ui.file.swapMenu1");
    }

    private Role destination() {
        Set<Role> set = Relation.others(this.source(), true);
        return set.toArray(new Role[set.size()])[this.index];
    }

    public String getText() {
        DiffView diffView = this.deltaView();
        if (diffView.getInput() == null || this.source() == null || this.destination() == null) {
            return super.getText();
        }
        boolean bl = diffView.isThreeWay();
        return NLS.bind((String)UIMsg.SwapAction_menuItem_label, (Object)this.source().getDisplayName(bl), (Object)this.destination().getDisplayName(bl));
    }

    public void run() {
        App.instance().viewBoss().viewDoc(this.deltaView(), true, this.source(), this.destination(), false, true);
    }

    @Override
    protected Role source() {
        return this.deltaView().getFocusRole();
    }

    public void update() {
        boolean bl = true;
        boolean bl2 = this.deltaView().isThreeWay();
        if (!bl2) {
            Role role = Relation.lastRole(bl2);
            this.setEnabled(role == Role.TWO);
            if (this.source() == Role.TWO || this.destination() == Role.TWO) {
                bl = false;
            }
        }
        this.setEnabled(bl);
    }
}

