/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.SubmitFeedbackDialog;
import com.deltopia.StringUtil;
import com.deltopia.net.HttpSubmitter;
import com.deltopia.util.logging.ToString;
import java.io.File;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitFeedbackAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final Logger LOG = LoggerFactory.getLogger(SubmitFeedbackAction.class);
    private IWorkbenchWindow wbWindow;

    public SubmitFeedbackAction(IWorkbenchWindow iWorkbenchWindow) {
        if (iWorkbenchWindow == null) {
            throw new IllegalArgumentException();
        }
        this.wbWindow = iWorkbenchWindow;
        this.setId("submitFeedback");
        this.setActionDefinitionId("com.deltawalker.ui.help.submitFeedback");
        this.setText(UIMsg.SubmitFeedbackAction_text);
        this.setToolTipText(UIMsg.SubmitFeedbackAction_text);
    }

    public void dispose() {
        this.wbWindow = null;
    }

    public void run() {
        SubmitFeedbackDialog submitFeedbackDialog;
        int n;
        if (this.wbWindow != null && (n = (submitFeedbackDialog = new SubmitFeedbackDialog(this.wbWindow.getShell())).open()) == 0) {
            Set<File> set = submitFeedbackDialog.getSubmitFiles();
            String string = submitFeedbackDialog.getEmail();
            try {
                if (!StringUtil.isEmpty((String)string)) {
                    string = "?email=" + URLEncoder.encode(string, "UTF-8");
                }
                URL uRL = new URL("https://www.deltopia.com/uploads/feedback" + StringUtil.makeSafe((String)string));
                HttpSubmitter.submitFiles(set, (URL)uRL, (String)submitFeedbackDialog.getSubmitMessage(), null, (boolean)false);
                if (LOG.isInfoEnabled()) {
                    LOG.info(new ToString().append("Submitting feedback to " + uRL).append(", Files", set).toString());
                }
            }
            catch (Exception exception) {
                LOG.warn("Couldn't submit feedback", (Throwable)exception);
                UIUtil.showError(submitFeedbackDialog.getString("SubmitError", exception.getMessage()));
            }
        }
    }
}

