/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.script.DualPrintStream;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.PartEventAction;
import java.util.ResourceBundle;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.internal.console.ConsoleView;

public class ShowConsoleAction
extends PartEventAction {
    private static MessageConsole msgConsole;

    public static MessageConsole console() {
        return msgConsole;
    }

    private static IConsoleView consoleView(IWorkbenchPage iWorkbenchPage) {
        return (IConsoleView)iWorkbenchPage.findView("org.eclipse.ui.console.ConsoleView");
    }

    public static MessageConsole createMessageConsole() {
        if (msgConsole == null) {
            msgConsole = new MessageConsole("", null);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{msgConsole});
            MessageConsoleStream messageConsoleStream = msgConsole.newMessageStream();
            MessageConsoleStream messageConsoleStream2 = msgConsole.newMessageStream();
            messageConsoleStream2.setColor(UIUtil.display().getSystemColor(3));
            System.setOut(new DualPrintStream(System.out, messageConsoleStream));
            System.setErr(new DualPrintStream(System.err, messageConsoleStream2));
        }
        return msgConsole;
    }

    public static void showConsole(IWorkbenchPage iWorkbenchPage, boolean bl) {
        IConsoleView iConsoleView;
        if (bl && iWorkbenchPage.isPartVisible((IWorkbenchPart)(iConsoleView = ShowConsoleAction.consoleView(iWorkbenchPage)))) {
            iWorkbenchPage.hideView((IViewPart)iConsoleView);
            return;
        }
        try {
            iWorkbenchPage.showView("org.eclipse.ui.console.ConsoleView");
            ShowConsoleAction.createMessageConsole();
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    public ShowConsoleAction(ResourceBundle resourceBundle, IWorkbenchWindow iWorkbenchWindow) {
        super(DeltaWalkerPlugin.getPluginId(), resourceBundle, iWorkbenchWindow, "ShowConsoleAction.", 1);
        this.setId("showConsole");
    }

    @Override
    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        super.partClosed(iWorkbenchPart);
        if (iWorkbenchPart instanceof ConsoleView) {
            this.setText(UIMsg.ShowConsoleAction_show);
        }
    }

    @Override
    public void partOpened(IWorkbenchPart iWorkbenchPart) {
        super.partOpened(iWorkbenchPart);
        if (iWorkbenchPart instanceof ConsoleView) {
            this.setText(UIMsg.ShowConsoleAction_hide);
        }
    }

    public void run() {
        IWorkbenchPage iWorkbenchPage = this.getWorkbenchWindow().getActivePage();
        ShowConsoleAction.showConsole(iWorkbenchPage, true);
    }

    @Override
    protected void workbenchPartChanged(IWorkbenchPart iWorkbenchPart, IWorkbenchPart iWorkbenchPart2) {
        IWorkbenchPage iWorkbenchPage = this.getWorkbenchWindow().getActivePage();
        IConsoleView iConsoleView = ShowConsoleAction.consoleView(iWorkbenchPage);
        if (iWorkbenchPart == null || iConsoleView == null) {
            return;
        }
        IActionBars iActionBars = iConsoleView.getViewSite().getActionBars();
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IContributionItem)new Separator());
        IContributionItem iContributionItem = iToolBarManager.find("outputGroup");
        if (iContributionItem == null) {
            iContributionItem = new GroupMarker("outputGroup");
            iToolBarManager.add(iContributionItem);
        }
    }
}

