/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.Msg;
import com.deltawalker.interfaces.IIcon32Provider;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.actions.Compare2WayHorizontalAction;
import com.deltawalker.ui.actions.Compare2WayVerticalAction;
import com.deltawalker.ui.actions.Compare3WayHorizontalAction;
import com.deltawalker.ui.actions.Compare3WayMixedAction;
import com.deltawalker.ui.actions.Compare3WayVerticalAction;
import com.deltawalker.ui.actions.DropdownMenuAction;
import com.deltawalker.ui.actions.IActionAccessor;
import com.deltopia.util.OS;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.RetargetAction;

public class SelectLayoutAction
extends DropdownMenuAction {
    private IActionAccessor actionAccessor;
    private IPropertyChangeListener onProperty = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            if (string.equals("checked")) {
                SelectLayoutAction.this.updateImage((IAction)propertyChangeEvent.getSource());
            }
        }
    };

    public SelectLayoutAction(ResourceBundle resourceBundle, IWorkbenchWindow iWorkbenchWindow, IActionAccessor iActionAccessor) {
        super(resourceBundle, "SelectLayoutAction.", iWorkbenchWindow);
        this.actionAccessor = iActionAccessor;
        if (OS.COCOA) {
            this.setImageDescriptor(ImageCache.getImageDescriptor(ImageConst.SWITCH_2WAY_VERTICAL_32));
        }
        this.setId("switchLayout");
    }

    private IAction getAction(String string, boolean bl) {
        IAction iAction = this.actionAccessor.getAction(string);
        if (!bl) {
            return iAction;
        }
        IAction iAction2 = ((RetargetAction)iAction).getActionHandler();
        if (iAction2 != null) {
            return iAction2;
        }
        ResourceBundle resourceBundle = Msg.constructedKeyBundle();
        if (string.equals("compare2WayVertical")) {
            return new Compare2WayVerticalAction(resourceBundle, null);
        }
        if (string.equals("compare2WayHorizontal")) {
            return new Compare2WayHorizontalAction(resourceBundle, null);
        }
        if (string.equals("compare3WayVertical")) {
            return new Compare3WayVerticalAction(resourceBundle, null);
        }
        if (string.equals("compare3WayHorizontal")) {
            return new Compare3WayHorizontalAction(resourceBundle, null);
        }
        if (string.equals("compare3WayMixed")) {
            return new Compare3WayMixedAction(resourceBundle, null);
        }
        assert (false);
        return null;
    }

    private ImageDescriptor getImageDescriptor(IAction iAction, boolean bl) {
        if (bl) {
            return ((IIcon32Provider)iAction).getImage32Descriptor();
        }
        return iAction.getImageDescriptor();
    }

    @Override
    protected List<IAction> getMenuActions() {
        ArrayList<IAction> arrayList = new ArrayList<IAction>(2);
        IAction iAction = this.actionAccessor.getAction("compare2WayVertical");
        iAction.addPropertyChangeListener(this.onProperty);
        arrayList.add(iAction);
        iAction = this.actionAccessor.getAction("compare3WayVertical");
        iAction.addPropertyChangeListener(this.onProperty);
        arrayList.add(iAction);
        return arrayList;
    }

    @Override
    public void runWithEvent(Event event) {
        this.dropdownMenu(event);
    }

    @Override
    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        super.partActivated(iWorkbenchPart);
        this.updateImage(this.getCheckedAction());
    }

    private void updateImage(IAction iAction) {
        if (iAction != null && iAction.isChecked()) {
            if (OS.COCOA) {
                IIcon32Provider iIcon32Provider = (IIcon32Provider)((RetargetAction)iAction).getActionHandler();
                this.setImageDescriptor(iIcon32Provider.getImage32Descriptor());
            } else {
                this.setImageDescriptor(iAction.getImageDescriptor());
            }
            this.setDisabledImageDescriptor(iAction.getDisabledImageDescriptor());
        }
    }

    @Override
    protected void workbenchPartChanged(IWorkbenchPart iWorkbenchPart, IWorkbenchPart iWorkbenchPart2) {
        super.workbenchPartChanged(iWorkbenchPart2, iWorkbenchPart);
        if (iWorkbenchPart != null) {
            DiffView diffView = this.getDiffView(iWorkbenchPart);
            this.setEnabled(diffView != null);
            if (diffView == null) {
                return;
            }
            boolean bl = OS.COCOA;
            IAction iAction = !diffView.isThreeWay() ? (diffView.isOrientation(512) ? this.getAction("compare2WayVertical", bl) : this.getAction("compare2WayHorizontal", bl)) : (diffView.isOrientation(768) ? this.getAction("compare3WayMixed", bl) : (diffView.isOrientation(512) ? this.getAction("compare3WayVertical", bl) : this.getAction("compare3WayHorizontal", bl)));
            this.setImageDescriptor(this.getImageDescriptor(iAction, bl));
            this.setDisabledImageDescriptor(iAction.getDisabledImageDescriptor());
        }
    }
}

