/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.ui.actions.PartEventAction;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.WorkbenchPage;

public class SaveAllAction
extends PartEventAction
implements IPropertyListener {
    private IWorkbenchPart openPart;
    private List<IWorkbenchPart> partsWithListeners = new ArrayList<IWorkbenchPart>(1);

    public SaveAllAction(ResourceBundle resourceBundle, IWorkbenchWindow iWorkbenchWindow) {
        super(DeltaWalkerPlugin.getPluginId(), resourceBundle, iWorkbenchWindow, "SaveAllAction.", 1);
        this.setId("saveAll");
        this.setEnabled(false);
        iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.save_all_action_context");
        this.setActionDefinitionId("org.eclipse.ui.file.saveAll");
    }

    @Override
    public void dispose() {
        super.dispose();
        for (IWorkbenchPart iWorkbenchPart : this.partsWithListeners) {
            iWorkbenchPart.removePropertyListener((IPropertyListener)this);
        }
        this.partsWithListeners.clear();
    }

    @Override
    public void pageActivated(IWorkbenchPage iWorkbenchPage) {
        super.pageActivated(iWorkbenchPage);
        this.updateState();
    }

    @Override
    public void pageClosed(IWorkbenchPage iWorkbenchPage) {
        super.pageClosed(iWorkbenchPage);
        this.updateState();
    }

    @Override
    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        super.partClosed(iWorkbenchPart);
        if (iWorkbenchPart instanceof ISaveablePart) {
            iWorkbenchPart.removePropertyListener((IPropertyListener)this);
            this.partsWithListeners.remove(iWorkbenchPart);
            this.updateState();
        }
    }

    @Override
    public void partOpened(IWorkbenchPart iWorkbenchPart) {
        super.partOpened(iWorkbenchPart);
        if (iWorkbenchPart instanceof ISaveablePart) {
            iWorkbenchPart.addPropertyListener((IPropertyListener)this);
            this.partsWithListeners.add(iWorkbenchPart);
            this.openPart = iWorkbenchPart;
            this.updateState();
            this.openPart = null;
        }
    }

    public void propertyChanged(Object object, int n) {
        if (object instanceof ISaveablePart && n == 257) {
            this.updateState();
        }
    }

    public void run() {
        if (this.getWorkbenchWindow() == null) {
            return;
        }
        WorkbenchPage workbenchPage = (WorkbenchPage)this.getActivePage();
        if (workbenchPage != null) {
            workbenchPage.saveAllEditors(false, true);
            this.updateState();
        }
    }

    @Override
    protected void updateState() {
        if (this.openPart != null && this.openPart.getSite().getPage().equals(this.getActivePage()) && ((ISaveablePart)this.openPart).isDirty()) {
            this.setEnabled(true);
        } else {
            WorkbenchPage workbenchPage = (WorkbenchPage)this.getActivePage();
            if (workbenchPage == null) {
                this.setEnabled(false);
            } else if (workbenchPage.getDirtyParts().length > 0) {
                this.setEnabled(true);
            } else {
                SaveablesList saveablesList = (SaveablesList)workbenchPage.getWorkbenchWindow().getWorkbench().getService(ISaveablesLifecycleListener.class);
                ISaveablesSource[] iSaveablesSourceArray = saveablesList.getNonPartSources();
                int n = 0;
                while (n < iSaveablesSourceArray.length) {
                    Saveable[] saveableArray = iSaveablesSourceArray[n].getSaveables();
                    int n2 = 0;
                    while (n2 < saveableArray.length) {
                        if (saveableArray[n2].isDirty()) {
                            this.setEnabled(true);
                            return;
                        }
                        ++n2;
                    }
                    ++n;
                }
                this.setEnabled(false);
            }
        }
    }
}

