/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.App;
import com.deltawalker.IPersistable;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.interfaces.IRoleAccessor;
import com.deltawalker.script.Role;
import com.deltawalker.ui.CompareEditor;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIUtil;
import com.deltopia.eclipse.util.IPropertyChangeNotifier;
import com.deltopia.util.IDisposable;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.texteditor.IUpdate;

public class SaveAction
extends PartEventAction
implements IUpdate,
IDisposable,
IRoleAccessor {
    private final IPropertyChangeListener onProp = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("MODIFIED".equals(propertyChangeEvent.getProperty())) {
                SaveAction.this.setEnabled(SaveAction.this.persistable.isModified());
            }
        }
    };
    private IPersistable persistable;
    private IWorkbenchWindow window;

    public static IPersistable activePersistable(IWorkbenchPart iWorkbenchPart) {
        IEditorPart iEditorPart;
        if (iWorkbenchPart instanceof IEditorPart && (iEditorPart = (IEditorPart)iWorkbenchPart) != null) {
            Role role;
            IDoc iDoc;
            Object object;
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof IPersistable) {
                return (IPersistable)iEditorInput;
            }
            if (iEditorInput instanceof IDiffDoc && (object = iEditorPart.getAdapter(DiffView.class)) != null && (iDoc = ((IDiffDoc)iEditorInput).doc(0, role = ((DiffView)object).getFocusRole())) instanceof IPersistable) {
                return (IPersistable)((Object)iDoc);
            }
        }
        return null;
    }

    public SaveAction() {
        super(null);
        this.setId("save");
        this.setActionDefinitionId("com.deltawalker.ui.file.save");
        this.window = UIUtil.getActiveWindow();
        this.window.getPartService().addPartListener((IPartListener)this);
        this.acquirePersistable();
    }

    private void acquirePersistable() {
        IPersistable iPersistable = SaveAction.activePersistable(this.getActivePart());
        if (this.persistable != iPersistable) {
            IPropertyChangeNotifier iPropertyChangeNotifier;
            if (this.persistable instanceof IPropertyChangeNotifier) {
                iPropertyChangeNotifier = (IPropertyChangeNotifier)((Object)this.persistable);
                iPropertyChangeNotifier.removePropertyListener(this.onProp);
            }
            this.persistable = iPersistable;
            if (this.persistable instanceof IPropertyChangeNotifier) {
                iPropertyChangeNotifier = (IPropertyChangeNotifier)((Object)this.persistable);
                iPropertyChangeNotifier.addPropertyListener(this.onProp);
            }
        }
    }

    public void dispose() {
        this.window.getPartService().addPartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        super.partActivated(iWorkbenchPart);
        this.acquirePersistable();
    }

    @Override
    public Role role() {
        Object object;
        IEditorPart iEditorPart = (IEditorPart)this.getActivePart();
        if (iEditorPart instanceof CompareEditor && (object = iEditorPart.getAdapter(DiffView.class)) != null) {
            return ((DiffView)object).getFocusRole();
        }
        return null;
    }

    public void run() {
        block4: {
            IPersistable iPersistable = SaveAction.activePersistable(this.getActivePart());
            if (iPersistable != null) {
                try {
                    if (iPersistable.isModified()) {
                        iPersistable.doSave((IProgressMonitor)new NullProgressMonitor());
                        this.update();
                    }
                }
                catch (IOException iOException) {
                    if (!(iPersistable instanceof IDoc)) break block4;
                    App.instance().docBoss().handleDocException((IDoc)((Object)iPersistable), iOException);
                }
            }
        }
    }

    public void update() {
        IPersistable iPersistable = SaveAction.activePersistable(this.getActivePart());
        this.setEnabled(iPersistable != null && iPersistable.isModified());
    }
}

