/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.Msg;
import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.ScriptBoss;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.TagReportConfig;
import com.deltawalker.internal.reports.FolderHtmlReporter;
import com.deltawalker.internal.reports.JsonReporter;
import com.deltawalker.internal.reports.Linked;
import com.deltawalker.internal.reports.Reporter;
import com.deltawalker.internal.reports.TextHtmlReporter;
import com.deltawalker.internal.reports.XmlReporter;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.StatusLineProgressMonitor;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.LicensedAction;
import com.deltawalker.ui.dialogs.FileDialogEx;
import com.deltopia.StringUtil;
import com.deltopia.io.TextEncoding;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.texteditor.IUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportAction
extends LicensedAction
implements IUpdate {
    private static final Logger LOG = LoggerFactory.getLogger(ReportAction.class);
    private static final boolean USE_TABS = false;
    private final TagReportConfig.Format format;
    private Linked linked;
    private IPreferenceStore prefs;
    private Thread thread;
    private final DiffView view;

    public ReportAction(ResourceBundle resourceBundle, TagReportConfig.Format format, DiffView diffView) {
        super(DeltaWalkerPlugin.getPluginId(), resourceBundle, "ReportAction.", 1);
        switch (format) {
            case HTML: {
                this.setId("createReportHtml");
                this.setActionDefinitionId("com.deltawalker.ui.file.createReportHtml");
                break;
            }
            case XML: {
                this.setId("createReportXml");
                this.setActionDefinitionId("com.deltawalker.ui.file.createReportXml");
                break;
            }
            case JSON: {
                this.setId("createReportJson");
                this.setActionDefinitionId("com.deltawalker.ui.file.createReportJson");
                break;
            }
            default: {
                throw new IllegalArgumentException("format");
            }
        }
        this.view = diffView;
        this.format = format;
        this.linked = Linked.fromPrefs();
    }

    private int createDialogArea(Composite composite, int n, int n2, boolean bl) {
        if (!bl) {
            return n2;
        }
        int n3 = n2 - n;
        GridData gridData = new GridData();
        gridData.verticalAlignment = 0x1000000;
        if (n3 > 0) {
            gridData.widthHint = n3;
        }
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)gridData);
        label.setText(UIMsg.ReportAction_linkedLabel);
        if (-1 == n2) {
            n2 = label.getLocation().x + label.computeSize((int)-1, (int)-1).x + n;
        }
        Combo combo = new Combo(composite, 8);
        combo.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.fillLinkedCombo(combo);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Combo combo = (Combo)event.widget;
                ReportAction.this.linked = Linked.fromInt(combo.getSelectionIndex());
                ReportAction.this.linked.toPrefs();
            }
        };
        combo.addListener(13, listener);
        combo.select(this.linked.toInt());
        combo.notifyListeners(13, null);
        return n2;
    }

    private FileDialogEx createFileDialog(List<IDiffModel> list) {
        final boolean[] blArray = new boolean[1];
        for (IDiffModel object2 : list) {
            IDiffDoc iDiffDoc = object2.deltaDoc();
            if (this.prefs == null) {
                this.prefs = iDiffDoc.preferences();
            }
            if (iDiffDoc.docType(0) != DocType.FOLDER) continue;
            blArray[0] = true;
            break;
        }
        FileDialogEx fileDialogEx = new FileDialogEx(UIUtil.getActiveWindowShell(), 8192, this.prefs){

            @Override
            protected void configureButton(int n, Button button) {
                super.configureButton(n, button);
                if (n == 0) {
                    button.setText(UIMsg.ReportAction_okButton_label);
                }
            }

            @Override
            protected Control createDialogArea(Composite composite, int n, Object object) {
                int n2;
                int[] nArray;
                if (object != null) {
                    nArray = (int[])object;
                    n2 = nArray[1];
                } else {
                    n2 = -1;
                }
                nArray = null;
                Object var6_6 = null;
                Object var7_7 = null;
                GridLayout gridLayout = new GridLayout();
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                gridLayout.numColumns = 2;
                Composite composite2 = new Composite(composite, n);
                composite2.setLayout((Layout)gridLayout);
                n2 = ReportAction.this.createDialogArea(composite2, gridLayout.horizontalSpacing, n2, blArray[0]);
                Control control = super.createDialogArea(composite2, n, new int[]{gridLayout.verticalSpacing, n2});
                if (control != null) {
                    GridData gridData = new GridData(4, 128, true, false);
                    gridData.horizontalSpan = gridLayout.numColumns;
                    control.setLayoutData((Object)gridData);
                }
                return composite2;
            }
        };
        fileDialogEx.setFilePath(String.valueOf(blArray[0] ? "F" : "T") + "Report." + this.format.toString());
        fileDialogEx.setShowLineEnding(false);
        fileDialogEx.setShowOpenInBrowser(true);
        fileDialogEx.setTitle(UIMsg.ReportAction_dialogTitle);
        fileDialogEx.setFilterExtensions(new String[]{"html", Msg.Common_allFiles_extension});
        fileDialogEx.setFilterNames(new String[]{UIMsg.CompareSummaryDlg_htmlFiles_name, Msg.Common_allFiles_name});
        fileDialogEx.setUseStandaloneExtensionDialog(true);
        return fileDialogEx;
    }

    private void fillLinkedCombo(Combo combo) {
        int n = Linked.values().length;
        int n2 = 0;
        while (n2 < n) {
            combo.add(Linked.fromInt(n2).toString());
            ++n2;
        }
        combo.select(this.linked.toInt());
    }

    public void report(String string, TextEncoding textEncoding, String string2, Linked linked) {
        this.report(string, textEncoding != null ? textEncoding.charset() : null, string2, linked);
    }

    public void report(final String string, String string2, String string3, Linked linked) {
        List<IDiffModel> list;
        if (LOG.isInfoEnabled()) {
            LOG.info("filename: " + string + "    encoding: " + string2 + "    lineEnding: " + string3 + "    linked: " + (Object)((Object)linked));
        }
        this.linked = linked != null ? linked : Linked.fromPrefs();
        String string4 = !StringUtil.isEmpty((String)string2) ? string2 : "UTF-8";
        IDiffDoc iDiffDoc = this.view.getInput();
        if (this.prefs == null) {
            this.prefs = this.view.getInput().preferences();
        }
        if ((list = iDiffDoc.diffModels()).isEmpty()) {
            return;
        }
        final IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[1];
        UIUtil.display().syncExec(new Runnable(){

            @Override
            public void run() {
                iProgressMonitorArray[0] = StatusLineProgressMonitor.createInstance(ReportAction.this.view);
            }
        });
        Set<Role> set = Relation.roles(iDiffDoc.isThreeWay());
        final TagReportConfig tagReportConfig = new TagReportConfig(iDiffDoc.docType(0), this.format, set, this.linked, string4, this.prefs.getBoolean(PrefKey.T_SHOW_PSEUDO_CONFLICTS.toString()), iProgressMonitorArray[0]);
        final Throwable[] throwableArray = new Throwable[1];
        this.thread = new Thread(){

            @Override
            public void run() {
                try {
                    try {
                        Reporter reporter;
                        long l = LOG.isInfoEnabled() ? System.nanoTime() : 0L;
                        iProgressMonitorArray[0].beginTask(UIMsg.ReportAction_performingTotalWork, -1);
                        block2 : switch (ReportAction.this.format) {
                            case HTML: {
                                switch (tagReportConfig.docType) {
                                    case FOLDER: {
                                        reporter = new FolderHtmlReporter(tagReportConfig, list, string, true);
                                        break block2;
                                    }
                                    case TEXT: {
                                        reporter = new TextHtmlReporter(tagReportConfig, (List<IDiffModel>)list, string);
                                        break block2;
                                    }
                                }
                                throw new IllegalArgumentException("config.docType");
                            }
                            case XML: {
                                reporter = new XmlReporter(tagReportConfig, (List<IDiffModel>)list, string);
                                break;
                            }
                            case JSON: {
                                reporter = new JsonReporter(tagReportConfig, (List<IDiffModel>)list, string);
                                break;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                        App.instance().scriptBoss().fireEvent(ScriptBoss.Event.REPORT_STARTED, null, ReportAction.this.view.getInput());
                        reporter.generateReport();
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Report finished for " + (double)(System.nanoTime() - l) / 1000000.0 + " ms");
                        }
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                        App.instance().scriptBoss().fireEvent(ScriptBoss.Event.REPORT_ENDED, null, ReportAction.this.view.getInput());
                        ReportAction.this.thread = null;
                        if (iProgressMonitorArray != null) {
                            iProgressMonitorArray[0].done();
                        }
                        if (throwableArray[0] != null) {
                            String string2 = "Couldn't create a report: {0}";
                            string2 = NLS.bind((String)string2, (Object)throwableArray[0].getLocalizedMessage());
                            UIUtil.showError(string2, throwableArray[0]);
                            LOG.warn(string2, throwableArray[0]);
                        } else if (ReportAction.this.prefs.getBoolean(PrefKey.C_OPEN_REPORT_IN_BROWSER.toString())) {
                            Program.launch((String)string);
                        }
                    }
                }
                finally {
                    App.instance().scriptBoss().fireEvent(ScriptBoss.Event.REPORT_ENDED, null, ReportAction.this.view.getInput());
                    ReportAction.this.thread = null;
                    if (iProgressMonitorArray != null) {
                        iProgressMonitorArray[0].done();
                    }
                    if (throwableArray[0] != null) {
                        String string3 = "Couldn't create a report: {0}";
                        string3 = NLS.bind((String)string3, (Object)throwableArray[0].getLocalizedMessage());
                        UIUtil.showError(string3, throwableArray[0]);
                        LOG.warn(string3, throwableArray[0]);
                    } else if (ReportAction.this.prefs.getBoolean(PrefKey.C_OPEN_REPORT_IN_BROWSER.toString())) {
                        Program.launch((String)string);
                    }
                }
            }
        };
        this.thread.start();
    }

    public void run() {
        List<IDiffModel> list = this.view.getInput().diffModels();
        if (list.isEmpty()) {
            return;
        }
        FileDialogEx fileDialogEx = this.createFileDialog(list);
        String string = fileDialogEx.open();
        if (string == null) {
            return;
        }
        String string2 = fileDialogEx.getSelectedEncoding(true).charset();
        String string3 = fileDialogEx.getSelectedLineEnding();
        this.report(string, string2, string3, null);
    }

    public void update() {
        this.setEnabled(this.thread == null);
    }
}

