/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.StatusLineProgressMonitor;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.PartEventAction;
import com.deltawalker.ui.printing.IPrintable;
import com.deltopia.util.OS;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;

public class PrintAction
extends PartEventAction {
    public static boolean hasPrinter() {
        return App.instance().printBoss().getPrinterData(true) != null;
    }

    public PrintAction(ResourceBundle resourceBundle, IWorkbenchWindow iWorkbenchWindow) {
        super(DeltaWalkerPlugin.getPluginId(), resourceBundle, iWorkbenchWindow, "PrintAction.", 1);
        this.setId(ActionFactory.PRINT.getId());
        this.updateState();
    }

    public void run() {
        if (!OS.OSX && !PrintAction.hasPrinter()) {
            UIUtil.showError("There are no printers installed. Please install at least one printer, then try printing again.");
            return;
        }
        DiffView diffView = this.deltaView();
        IProgressMonitor iProgressMonitor = StatusLineProgressMonitor.createInstance(diffView);
        IPrintable iPrintable = (IPrintable)((Object)diffView);
        App.instance().printBoss().print(iPrintable, iProgressMonitor, true);
    }

    @Override
    protected void updateState() {
        boolean bl;
        DiffView diffView = this.deltaView();
        boolean bl2 = bl = diffView != null && diffView.docType() != DocType.IMAGE;
        if (bl && !OS.OSX) {
            bl = PrintAction.hasPrinter();
        }
        this.setEnabled(bl);
    }
}

