/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.Addon;
import com.deltawalker.App;
import com.deltawalker.DocBase;
import com.deltawalker.Msg;
import com.deltawalker.interfaces.IScriptBoss;
import com.deltawalker.interfaces.IScriptDoc;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.script.doc.ScriptDoc;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.actions.LicensedAction;
import com.deltopia.StringUtil;
import com.deltopia.ui.OSFileDialog;
import com.deltopia.util.IDisposable;
import java.util.EnumSet;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenScriptAction
extends LicensedAction
implements IMenuListener2,
IDisposable {
    public static final int MAX_PATH_LENGTH = 60;
    private final boolean open;
    private IWorkbenchWindow window;

    public static void addScriptHistoryItems(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator());
        final IScriptBoss iScriptBoss = App.instance().scriptBoss();
        TreeSet<IScriptDoc> treeSet = iScriptBoss.scriptDocs();
        for (final IScriptDoc iScriptDoc : treeSet) {
            iMenuManager.add((IAction)new Action(){

                public String getText() {
                    return OpenScriptAction.constrainText(((DocBase)((Object)iScriptDoc)).uriInfo().uri(), 60);
                }

                public void run() {
                    ((ScriptDoc)iScriptDoc).setTimeLastOpened(System.currentTimeMillis());
                    iScriptBoss.viewDoc(iScriptDoc, true);
                }
            });
        }
    }

    public static String constrainText(String string, int n) {
        int n2 = Math.round(0.3f * (float)n);
        int n3 = Math.round(0.7f * (float)n);
        return StringUtil.ellipsize((String)string, (int)n2, (int)n3);
    }

    public OpenScriptAction(IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        super(DeltaWalkerPlugin.getPluginId(), Msg.constructedKeyBundle(), bl ? "OpenScriptAction." : "NewScriptAction.", 1, EnumSet.of(Addon.Edition.TRIAL, Addon.Edition.PRO, Addon.Edition.ORO));
        this.setId(bl ? "openScript" : "newScript");
        this.window = iWorkbenchWindow;
        this.open = bl;
    }

    public void dispose() {
        this.window = null;
    }

    public void menuAboutToHide(IMenuManager iMenuManager) {
        IContributionItem[] iContributionItemArray;
        IContributionItem[] iContributionItemArray2 = iContributionItemArray = iMenuManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray2[n2];
            if (iContributionItem instanceof IDisposable) {
                ((IDisposable)iContributionItem).dispose();
            }
            ++n2;
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        OpenScriptAction.addScriptHistoryItems(iMenuManager);
    }

    public void run() {
        if (!this.open) {
            App.instance().scriptBoss().openScript(null, true);
        } else {
            OSFileDialog oSFileDialog = new OSFileDialog(this.window.getShell(), 4096);
            oSFileDialog.setFilterExtensions(new String[]{UIMsg.LoadScriptAction_scriptFiles_extension, Msg.Common_allFiles_extension});
            oSFileDialog.setFilterNames(new String[]{UIMsg.LoadScriptAction_scriptFiles_name, Msg.Common_allFiles_name});
            String string = oSFileDialog.open();
            if (!StringUtil.isEmpty((String)string)) {
                App.instance().scriptBoss().openScript(string, true);
            }
        }
    }
}

