/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.App;
import com.deltawalker.StateBoss;
import com.deltawalker.interfaces.IApp;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.ui.dialogs.SnapshotFileDialog;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.ResourceAction;
import com.deltopia.StringUtil;
import com.deltopia.io.StreamUtil;
import com.google.gson.stream.JsonReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.UUID;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenReportJsonAction
extends ResourceAction
implements IUpdate {
    private static final Logger LOG = LoggerFactory.getLogger(OpenReportJsonAction.class);
    private final IWorkbenchWindow window;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDiffDoc open(String string) {
        IDiffDoc iDiffDoc;
        final IApp iApp = App.instance();
        JsonReader jsonReader = null;
        try {
            jsonReader = StateBoss.getJsonReader(new File(string));
            final IDiffDoc iDiffDoc2 = iApp.docBoss().create(jsonReader, string);
            UUID uUID = iDiffDoc2.getId();
            UIUtil.display().syncExec(new Runnable(){

                @Override
                public void run() {
                    iApp.viewBoss().viewDoc(iDiffDoc2, true);
                }
            });
            iDiffDoc = iApp.docBoss().get(uUID);
        }
        catch (IOException iOException) {
            try {
                LOG.error("Couldn't open snapshot: " + string, (Throwable)iOException);
            }
            catch (Throwable throwable) {
                StreamUtil.closeSilently(jsonReader);
                throw throwable;
            }
            StreamUtil.closeSilently((Closeable)jsonReader);
            return null;
        }
        StreamUtil.closeSilently((Closeable)jsonReader);
        return iDiffDoc;
    }

    public OpenReportJsonAction(ResourceBundle resourceBundle, IWorkbenchWindow iWorkbenchWindow) {
        super(DeltaWalkerPlugin.getPluginId(), resourceBundle, "OpenReportJsonAction.", 1);
        this.window = iWorkbenchWindow;
        this.setId("openReportJson");
        this.setActionDefinitionId("com.deltawalker.ui.file.openReportJson");
    }

    public void run() {
        Shell shell = UIUtil.getActiveWindowShell();
        SnapshotFileDialog snapshotFileDialog = new SnapshotFileDialog(shell, 4096, null, null);
        String string = snapshotFileDialog.open();
        if (StringUtil.isEmpty((String)string)) {
            return;
        }
        OpenReportJsonAction.open(string);
    }

    public void update() {
        this.setEnabled(true);
    }
}

