/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.Msg;
import com.deltawalker.UriInfo;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.FileFilterUtil;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.UriChooser;
import com.deltawalker.ui.actions.OpenLocalAction;
import com.deltawalker.ui.dialogs.FileDialogEx;
import com.deltopia.StringUtil;
import com.deltopia.io.FileType;
import com.deltopia.io.TextEncoding;
import java.util.Locale;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;

public class OpenLocalFileAction
extends OpenLocalAction {
    public OpenLocalFileAction(DiffView diffView) {
        super(DeltaWalkerPlugin.getPluginId(), Msg.constructedKeyBundle(), "OpenLocalFileAction.", diffView);
    }

    public void run() {
        IPreferenceStore iPreferenceStore = this.view.preferences();
        FileDialogEx fileDialogEx = new FileDialogEx(UIUtil.getActiveWindowShell(), 4096, iPreferenceStore);
        Role role = this.view.getFocusRole();
        String string = NLS.bind((String)UIMsg.FileDialogEx_selectTitle, (Object)role.getDisplayName(this.view.isThreeWay()));
        fileDialogEx.setTitle(string);
        UriChooser uriChooser = this.view.uriChooserBoss().uriChooser(role);
        fileDialogEx.setFilterPath(FileDialogEx.chooseFilterPath(uriChooser.uriInfo(), role.toString(), iPreferenceStore));
        fileDialogEx.setFilterNames(FileFilterUtil.getDefaultFilterNames());
        fileDialogEx.setFilterExtensions(FileFilterUtil.getDefaultFilterExtensions());
        String string2 = fileDialogEx.open();
        if (!StringUtil.isEmpty((String)string2)) {
            TextEncoding textEncoding = null;
            Locale locale = null;
            UriInfo uriInfo = new UriInfo(string2, FileType.FILE);
            if (fileDialogEx.isCharsetSelected()) {
                textEncoding = fileDialogEx.getSelectedEncoding(false);
                if (textEncoding != null) {
                    uriInfo = uriInfo.cloneUpdateEncoding(textEncoding);
                }
            } else {
                locale = fileDialogEx.getSelectedLocale();
                if (locale != null) {
                    uriInfo = uriInfo.cloneUpdateLocale(locale);
                }
            }
            uriInfo = uriInfo.cloneUpdateLineEnding(fileDialogEx.getSelectedLineEnding());
            uriChooser.updateUriInfo(uriInfo, false, false, false);
        }
    }
}

