/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.PrefKey;
import com.deltawalker.UriInfo;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.actions.IMenuProvider;
import com.deltawalker.ui.actions.MenuCreator;
import com.deltopia.io.VfsUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class OpenDropDownMenuAction
extends Action
implements IMenuProvider {
    protected IAction[] actions;
    private boolean showLocal = true;
    private MenuCreator menuCreator = new MenuCreator(this);
    protected DiffView view;

    public OpenDropDownMenuAction(DiffView diffView) {
        this.view = diffView;
        this.showLocal = diffView.preferences().getBoolean(PrefKey.C_DEFAULT_TO_LOCAL.toString());
        this.getMenuActions();
        this.copyActionAttributes();
        this.setMenuCreator(this.menuCreator);
    }

    protected void copyActionAttributes() {
        int n = this.showLocal ? 0 : 1;
        IAction iAction = this.actions[n];
        this.setImageDescriptor(iAction.getImageDescriptor());
        this.setDisabledImageDescriptor(iAction.getDisabledImageDescriptor());
        this.setHoverImageDescriptor(iAction.getHoverImageDescriptor());
        this.setToolTipText(iAction.getToolTipText());
    }

    protected abstract IAction[] getMenuActions();

    @Override
    public void populateMenu(Menu menu) {
        IAction[] iActionArray;
        IAction[] iActionArray2 = iActionArray = this.getMenuActions();
        int n = iActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction iAction = iActionArray2[n2];
            if (iAction instanceof IUpdate) {
                ((IUpdate)iAction).update();
            }
            ActionContributionItem actionContributionItem = new ActionContributionItem(iAction);
            actionContributionItem.fill(menu, -1);
            ++n2;
        }
    }

    protected boolean shouldShowLocalAction() {
        Role role = this.view.getFocusRole();
        UriInfo uriInfo = this.view.uriChooserBoss().uriInfos().get((Object)role);
        String string = uriInfo.uri();
        if (!string.isEmpty()) {
            this.showLocal = !VfsUtil.hasRemoteScheme((String)string);
        }
        return this.showLocal;
    }

    protected void setShowLocalAction(boolean bl) {
        this.showLocal = bl;
        this.copyActionAttributes();
        this.view.preferences().setValue(PrefKey.C_DEFAULT_TO_LOCAL.toString(), bl);
    }
}

