/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.IDeltaListener;
import com.deltawalker.ui.IDeltaNotifier;
import com.deltawalker.ui.IEditIterator;
import com.deltopia.eclipse.util.Goto;
import com.deltopia.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.texteditor.IUpdate;

public class GotoEditAction
extends Action
implements IUpdate,
IDisposable {
    private final IDeltaListener onDelta = new IDeltaListener(){

        @Override
        public void deltasChanged() {
            GotoEditAction.this.update();
        }

        @Override
        public void selectionChanged(boolean bl) {
            GotoEditAction.this.update();
        }
    };
    private final Goto go;
    private DiffView dView;

    public GotoEditAction(Goto goto_, DiffView diffView) {
        this.go = goto_;
        this.dView = diffView;
        if (this.go == Goto.NEXT) {
            this.setId("nextEdit");
            this.setActionDefinitionId("com.deltawalker.ui.navigate.nextEdit");
        } else {
            this.setId("previousEdit");
            this.setActionDefinitionId("com.deltawalker.ui.navigate.previousEdit");
        }
        diffView.addDeltaListener(this.onDelta);
    }

    public void dispose() {
        if (this.dView != null) {
            IDiffDoc iDiffDoc = this.dView.getInput();
            if (iDiffDoc instanceof IDeltaNotifier) {
                ((IDeltaNotifier)((Object)iDiffDoc)).addDeltaListener(this.onDelta);
            }
            this.dView = null;
        }
    }

    public void run() {
        IEditIterator iEditIterator = (IEditIterator)((Object)this.dView);
        IAction iAction = null;
        if (iEditIterator != null) {
            if (this.go == Goto.NEXT) {
                iEditIterator.nextEdit();
                iAction = this.dView.controller().getAction("previousEdit");
            } else {
                iEditIterator.previousEdit();
                iAction = this.dView.controller().getAction("nextEdit");
            }
        }
        this.update();
        ((IUpdate)iAction).update();
    }

    public void update() {
        boolean bl = false;
        if (this.dView instanceof IEditIterator) {
            IEditIterator iEditIterator = (IEditIterator)((Object)this.dView);
            bl = this.go == Goto.NEXT ? iEditIterator.hasNextEdit() : iEditIterator.hasPreviousEdit();
        }
        this.setEnabled(bl);
    }
}

