/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.Delta;
import com.deltawalker.DeltaUtil;
import com.deltawalker.Msg;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.IDeltaListener;
import com.deltawalker.ui.actions.ResourceAction;
import com.deltopia.eclipse.util.Goto;
import com.deltopia.ui.swt.KeyUtil;
import com.deltopia.util.IDisposable;
import com.deltopia.util.OS;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GotoConflictAction
extends ResourceAction
implements IDisposable {
    private static final Set<Delta> CONFLICT = new HashSet<Delta>();
    private DiffView dView;
    private final Goto go;
    private boolean mod2;
    private final IDeltaListener onDelta = new IDeltaListener(){

        @Override
        public void deltasChanged() {
            GotoConflictAction.this.update();
        }

        @Override
        public void selectionChanged(boolean bl) {
            GotoConflictAction.this.update();
        }
    };

    static {
        CONFLICT.add(new Delta(DeltaUtil.conflictKind()));
    }

    public GotoConflictAction(ResourceBundle resourceBundle, Goto goto_, DiffView diffView, boolean bl) {
        super(DeltaWalkerPlugin.getPluginId(), resourceBundle, goto_ == Goto.NEXT ? "GotoNextConflictAction." : "GotoPreviousConflictAction.", 1);
        this.go = goto_;
        this.dView = diffView;
        if (this.go == Goto.NEXT) {
            this.setId(bl ? "nextConflictTB" : "nextConflict");
            this.setActionDefinitionId("com.deltawalker.ui.navigate.nextConflict");
            if (OS.OSX) {
                this.setToolTipText(Msg.NextConflictAction_toolTipOSX);
            }
        } else {
            this.setId(bl ? "previousConflictTB" : "previousConflict");
            this.setActionDefinitionId("com.deltawalker.ui.navigate.previousConflict");
            if (OS.OSX) {
                this.setToolTipText(Msg.PreviousConflictAction_toolTipOSX);
            }
        }
        diffView.addDeltaListener(this.onDelta);
        Composite composite = this.dView.getControl();
        final Display display = composite.getDisplay();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                int n = event.type;
                switch (n) {
                    case 12: {
                        display.removeFilter(1, (Listener)this);
                        display.removeFilter(2, (Listener)this);
                        break;
                    }
                    case 1: {
                        boolean bl;
                        boolean bl2 = bl = KeyUtil.hasKey((Event)event, (int)SWT.MOD2) || KeyUtil.hasMask((Event)event, (int)SWT.MOD2);
                        if (GotoConflictAction.this.mod2 == bl) break;
                        GotoConflictAction.this.mod2 = bl;
                        GotoConflictAction.this.update();
                        break;
                    }
                    case 2: {
                        boolean bl;
                        boolean bl3 = bl = !KeyUtil.hasKey((Event)event, (int)SWT.MOD2) && KeyUtil.hasMask((Event)event, (int)SWT.MOD2);
                        if (GotoConflictAction.this.mod2 == bl) break;
                        GotoConflictAction.this.mod2 = bl;
                        GotoConflictAction.this.update();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("event.type");
                    }
                }
            }
        };
        display.addFilter(1, listener);
        display.addFilter(2, listener);
        composite.addListener(12, listener);
        this.update();
    }

    public void dispose() {
        if (this.dView != null) {
            this.dView.addDeltaListener(this.onDelta);
            this.dView = null;
        }
    }

    public void run() {
        DiffView diffView = this.dView;
        if (this.go == Goto.NEXT) {
            diffView.nextDelta(CONFLICT);
        } else {
            diffView.previousDelta(CONFLICT);
        }
    }

    protected void update() {
        if (!this.dView.isThreeWay()) {
            this.setEnabled(false);
            return;
        }
        DiffView diffView = this.dView;
        boolean bl = diffView != null ? (this.go == Goto.NEXT ? diffView.hasNextDelta(CONFLICT) : diffView.hasPreviousDelta(CONFLICT)) : false;
        this.setEnabled(bl);
    }
}

