/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.FilterTable;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.actions.IMenuProvider;
import com.deltawalker.ui.actions.MenuCreator;
import com.deltawalker.ui.actions.PartEventAction;
import com.deltopia.ui.swt.KeyUtil;
import com.deltopia.util.IDisposable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class DropdownMenuAction
extends PartEventAction
implements IMenuProvider,
IDisposable {
    private final boolean asDropdownCtl;
    private Shell shell;

    public static Point getInitialLocation(Shell shell, Point point, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y + rectangle.height;
        Rectangle rectangle2 = shell.getMonitor().getClientArea();
        if (n + point.x > rectangle2.x + rectangle2.width) {
            n = rectangle.x + rectangle.width - point.x;
        }
        if (n2 + point.y > rectangle2.y + rectangle2.height) {
            n2 = rectangle.y - point.y;
        }
        return new Point(n, n2);
    }

    public static String stripMnemonic(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.indexOf(38, n2);
            if (-1 == n3) break;
            int n4 = n3 + 1;
            if (n3 < n - 1 && string.charAt(n4) != '&') {
                string = String.valueOf(string.substring(0, n3)) + string.substring(n4);
                break;
            }
            n2 = n4;
        }
        return string;
    }

    public DropdownMenuAction(ResourceBundle resourceBundle, String string, IWorkbenchWindow iWorkbenchWindow) {
        this(resourceBundle, string, iWorkbenchWindow, false);
    }

    public DropdownMenuAction(ResourceBundle resourceBundle, String string, IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        this(DeltaWalkerPlugin.getPluginId(), resourceBundle, string, iWorkbenchWindow, bl);
    }

    public DropdownMenuAction(String string, ResourceBundle resourceBundle, String string2, IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        super(string, resourceBundle, iWorkbenchWindow, string2, 4);
        this.asDropdownCtl = bl;
        this.setMenuCreator(new MenuCreator(this){

            @Override
            public Menu getMenu(Control control) {
                if (DropdownMenuAction.this.asDropdownCtl) {
                    if (this.menu != null) {
                        this.menu.dispose();
                    }
                    this.menu = DropdownMenuAction.this.getMenu(control);
                    return this.menu;
                }
                return super.getMenu(control);
            }
        });
    }

    protected boolean canRunWithEvent(Event event) {
        return this.shell == null;
    }

    protected Control createControl(Composite composite) {
        List<IAction> list = this.getMenuActions();
        if (list.isEmpty()) {
            return null;
        }
        Table table = new Table((Composite)this.shell, 67632);
        FilterTable.increaseFontSize((Control)table);
        for (IAction iAction : list) {
            if (iAction == null) continue;
            if (iAction instanceof IUpdate) {
                ((IUpdate)iAction).update();
            }
            if (!iAction.isEnabled()) continue;
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setChecked(iAction.isChecked());
            tableItem.setData((Object)iAction);
            tableItem.setText(DropdownMenuAction.stripMnemonic(iAction.getText()));
        }
        if (table.getItemCount() <= 0) {
            return null;
        }
        table.addSelectionListener(new SelectionListener(){

            private void checkItem(Widget widget) {
                TableItem tableItem;
                Object object;
                if (widget instanceof TableItem && (object = (tableItem = (TableItem)widget).getData()) != null) {
                    IAction iAction = (IAction)object;
                    iAction.run();
                    if (iAction instanceof IUpdate) {
                        ((IUpdate)iAction).update();
                    }
                    tableItem.setChecked(iAction.isChecked());
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.checkItem(selectionEvent.item);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail == 32) {
                    this.checkItem(selectionEvent.item);
                }
            }
        });
        return table;
    }

    protected int defaultWidth() {
        return -1;
    }

    @Override
    protected DiffView deltaView() {
        return this.getDiffView(this.activePart());
    }

    @Override
    public void dispose() {
        try {
            IMenuCreator iMenuCreator = this.getMenuCreator();
            if (iMenuCreator != null) {
                iMenuCreator.dispose();
                this.setMenuCreator(null);
            }
        }
        finally {
            super.dispose();
        }
    }

    protected void dropdownMenu(Event event) {
        Menu menu;
        ToolItem toolItem = (ToolItem)event.widget;
        IMenuCreator iMenuCreator = this.getMenuCreator();
        if (iMenuCreator != null && (menu = iMenuCreator.getMenu((Control)toolItem.getParent())) != null) {
            Rectangle rectangle = toolItem.getBounds();
            Point point = toolItem.getParent().toDisplay(new Point(rectangle.x, rectangle.y + rectangle.height));
            menu.setLocation(point.x, point.y);
            menu.setVisible(true);
        }
    }

    public IAction getCheckedAction() {
        List<IAction> list = this.getMenuActions();
        for (IAction iAction : list) {
            if (iAction == null) continue;
            if (iAction instanceof IUpdate) {
                ((IUpdate)iAction).update();
            }
            if (!iAction.isChecked()) continue;
            return iAction;
        }
        return null;
    }

    protected int getControlShellStyle() {
        return 8;
    }

    protected DiffView getDiffView(IWorkbenchPart iWorkbenchPart) {
        DiffView diffView;
        if (iWorkbenchPart != null && (diffView = (DiffView)iWorkbenchPart.getAdapter(DiffView.class)) != null) {
            return diffView;
        }
        return null;
    }

    private Menu getMenu(Control control) {
        if (control instanceof ToolBar) {
            ToolItem[] toolItemArray;
            ToolBar toolBar = (ToolBar)control;
            ToolItem[] toolItemArray2 = toolItemArray = toolBar.getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAction iAction;
                ToolItem toolItem = toolItemArray2[n2];
                Object object = toolItem.getData();
                if (object instanceof ActionContributionItem && (this == (iAction = ((ActionContributionItem)object).getAction()) || iAction instanceof RetargetAction && this == ((RetargetAction)iAction).getActionHandler())) {
                    return this.getMenu(toolItem);
                }
                ++n2;
            }
        }
        return null;
    }

    private Menu getMenu(ToolItem toolItem) {
        if (this.shell != null) {
            return null;
        }
        this.shell = new Shell(this.getWorkbenchWindow().getShell(), this.getControlShellStyle());
        Control control = this.createControl((Composite)this.shell);
        if (control == null) {
            this.shell.dispose();
            this.shell = null;
        } else {
            this.shell.setLayout((Layout)new FillLayout());
            Point point = this.shell.computeSize(this.defaultWidth(), -1);
            this.shell.setSize(point);
            Rectangle rectangle = toolItem.getBounds();
            Point point2 = toolItem.getParent().toDisplay(rectangle.x, rectangle.y);
            Rectangle rectangle2 = new Rectangle(point2.x, point2.y, rectangle.width, rectangle.height);
            Point point3 = DropdownMenuAction.getInitialLocation(this.shell, point, rectangle2);
            this.shell.setLocation(point3);
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            if (DropdownMenuAction.this.shell != event.widget) break;
                            DropdownMenuAction.this.shell = null;
                            break;
                        }
                        case 16: 
                        case 27: {
                            Control control;
                            if (DropdownMenuAction.this.shell != event.widget || event.type == 16 && (control = DropdownMenuAction.this.shell.getDisplay().getFocusControl()) != null && DropdownMenuAction.this.shell.equals(control.getShell())) break;
                            DropdownMenuAction.this.shell.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (DropdownMenuAction.this.shell != null && !DropdownMenuAction.this.shell.isDisposed()) {
                                        DropdownMenuAction.this.shell.close();
                                    }
                                }
                            });
                        }
                    }
                }
            };
            this.shell.addListener(12, listener);
            this.shell.open();
            this.shell.addListener(27, listener);
            this.shell.addListener(16, listener);
        }
        return null;
    }

    protected abstract List<IAction> getMenuActions();

    protected UUID getSessionUuid() {
        DiffView diffView = this.deltaView();
        return diffView != null ? diffView.getInput().getId() : null;
    }

    @Override
    public void populateMenu(Menu menu) {
        List<IAction> list = this.getMenuActions();
        for (IAction iAction : list) {
            Object object = iAction != null ? new ActionContributionItem(iAction) : new Separator();
            if (iAction instanceof IUpdate) {
                ((IUpdate)iAction).update();
            }
            object.fill(menu, -1);
        }
    }

    public void runWithEvent(Event event) {
        List<IAction> list;
        if (!this.canRunWithEvent(event)) {
            return;
        }
        if (event.widget instanceof ToolItem) {
            event.stateMask = KeyUtil.getModifier((Widget)event.widget, (boolean)true);
        }
        if ((list = this.getMenuActions()).isEmpty()) {
            this.run();
        } else {
            for (IAction iAction : list) {
                if (iAction instanceof IUpdate) {
                    ((IUpdate)iAction).update();
                }
                if (iAction == null || !iAction.isEnabled()) continue;
                iAction.runWithEvent(event);
                return;
            }
        }
    }
}

