/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.DocType;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.TagReportConfig;
import com.deltawalker.internal.reports.JsonReporter;
import com.deltawalker.internal.reports.Linked;
import com.deltawalker.internal.reports.ReportException;
import com.deltawalker.internal.ui.dialogs.SnapshotFileDialog;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.StatusLineProgressMonitor;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.ResourceAction;
import com.deltopia.StringUtil;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.IUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateReportJsonAction
extends ResourceAction
implements IUpdate {
    private static final Logger LOG = LoggerFactory.getLogger(CreateReportJsonAction.class);
    private Thread thread;
    private final DiffView view;

    public CreateReportJsonAction(ResourceBundle resourceBundle, DiffView diffView) {
        super(DeltaWalkerPlugin.getPluginId(), resourceBundle, "CreateReportJsonAction.", 1);
        this.view = diffView;
        this.setId("createReportJson");
        this.setActionDefinitionId("com.deltawalker.ui.file.createReportJson");
    }

    public void createAndSave(final String string, final Set<Role> set) {
        final IDiffDoc iDiffDoc = this.view.getInput();
        final IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[1];
        UIUtil.display().syncExec(new Runnable(){

            @Override
            public void run() {
                iProgressMonitorArray[0] = StatusLineProgressMonitor.createInstance(CreateReportJsonAction.this.view);
            }
        });
        this.thread = new Thread(){

            @Override
            public void run() {
                try {
                    try {
                        TagReportConfig tagReportConfig = new TagReportConfig(DocType.FOLDER, TagReportConfig.Format.JSON, set, Linked.NONE, "UTF-8", false, iProgressMonitorArray[0]);
                        JsonReporter jsonReporter = new JsonReporter(tagReportConfig, Arrays.asList(iDiffDoc.diffModel(0)), string);
                        jsonReporter.generateReport();
                    }
                    catch (ReportException reportException) {
                        LOG.error("Creating a snapshot failed: " + reportException.getCause());
                        CreateReportJsonAction.this.thread = null;
                        if (iProgressMonitorArray[0] != null) {
                            iProgressMonitorArray[0].done();
                        }
                    }
                    catch (Throwable throwable) {
                        LOG.error("Creating a snapshot failed: " + throwable);
                        CreateReportJsonAction.this.thread = null;
                        if (iProgressMonitorArray[0] != null) {
                            iProgressMonitorArray[0].done();
                        }
                    }
                }
                finally {
                    CreateReportJsonAction.this.thread = null;
                    if (iProgressMonitorArray[0] != null) {
                        iProgressMonitorArray[0].done();
                    }
                }
            }
        };
        this.thread.start();
    }

    public void run() {
        IDiffDoc iDiffDoc;
        if (this.thread != null) {
            throw new IllegalStateException("Creating patch already in progress.");
        }
        Shell shell = this.view.getControl().getShell();
        SnapshotFileDialog snapshotFileDialog = new SnapshotFileDialog(shell, 8192, (iDiffDoc = this.view.getInput()).preferences(), iDiffDoc.roles());
        String string = snapshotFileDialog.open();
        if (StringUtil.isEmpty((String)string)) {
            return;
        }
        Set<Role> set = snapshotFileDialog.roles();
        this.createAndSave(string, set);
    }

    public void update() {
        IDiffDoc iDiffDoc = this.view.getInput();
        DocType docType = iDiffDoc.docType(0);
        boolean bl = docType.isText() || docType.isStructure();
        this.setEnabled(this.thread == null && !this.view.isThreeWay() && bl);
    }
}

