/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.DocType;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.PatchConfig;
import com.deltawalker.internal.PatchReportConfig;
import com.deltawalker.internal.reports.TextPatchReporter;
import com.deltawalker.internal.ui.dialogs.SavePatchDialog;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.StatusLineProgressMonitor;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.LicensedAction;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.IUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePatchAction
extends LicensedAction
implements IUpdate {
    private static final Logger LOG = LoggerFactory.getLogger(CreatePatchAction.class);
    private Thread thread;
    private final DiffView view;

    public CreatePatchAction(ResourceBundle resourceBundle, DiffView diffView) {
        super(DeltaWalkerPlugin.getPluginId(), resourceBundle, "CreatePatchAction.", 1);
        this.view = diffView;
        this.setId("createReportPatch");
        this.setActionDefinitionId("com.deltawalker.ui.file.createReportPatch");
    }

    public void run() {
        if (this.thread != null) {
            throw new IllegalStateException("Creating patch already in progress.");
        }
        Shell shell = this.view.getControl().getShell();
        SavePatchDialog savePatchDialog = new SavePatchDialog(shell, 0, this.view.getInput().preferences());
        if (savePatchDialog.open() == null) {
            return;
        }
        final PatchConfig patchConfig = savePatchDialog.getPatchConfiguration();
        final IProgressMonitor[] iProgressMonitorArray = new IProgressMonitor[1];
        UIUtil.display().syncExec(new Runnable(){

            @Override
            public void run() {
                iProgressMonitorArray[0] = StatusLineProgressMonitor.createInstance(CreatePatchAction.this.view);
            }
        });
        this.thread = new Thread(){

            @Override
            public void run() {
                try {
                    try {
                        PatchReportConfig patchReportConfig = new PatchReportConfig(DocType.TEXT, PatchReportConfig.Kind.UNIFIED, 3, "UTF-8", false, iProgressMonitorArray[0]);
                        TextPatchReporter textPatchReporter = new TextPatchReporter(patchReportConfig, Arrays.asList(CreatePatchAction.this.view.deltaModel()), patchConfig.getFileName());
                        textPatchReporter.generateReport();
                    }
                    catch (Throwable throwable) {
                        LOG.error("Creating a patch failed: " + throwable);
                        CreatePatchAction.this.thread = null;
                        if (iProgressMonitorArray[0] != null) {
                            iProgressMonitorArray[0].done();
                        }
                    }
                }
                finally {
                    CreatePatchAction.this.thread = null;
                    if (iProgressMonitorArray[0] != null) {
                        iProgressMonitorArray[0].done();
                    }
                }
            }
        };
        this.thread.start();
    }

    public void update() {
        IDiffDoc iDiffDoc = this.view.getInput();
        DocType docType = iDiffDoc.docType(0);
        boolean bl = docType.isText() || docType.isStructure();
        this.setEnabled(this.thread == null && !this.view.isThreeWay() && bl);
    }
}

