/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.Addon;
import com.deltawalker.DocType;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IReplaceable;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.actions.CopyAction;
import com.deltawalker.ui.actions.MenuAction;
import com.deltopia.ui.swt.KeyUtil;
import com.deltopia.util.IDisposable;
import java.util.EnumSet;
import java.util.ResourceBundle;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.texteditor.IUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CopyMenuAction
extends MenuAction
implements IUpdate,
IDisposable {
    private static final Logger LOG = LoggerFactory.getLogger(CopyMenuAction.class);
    private final InternalListener listener = new InternalListener();
    protected final boolean move;

    public static boolean shouldConfirmReplace(Event event) {
        if (event == null) {
            return false;
        }
        boolean bl = PrefUtil.getGlobalPrefs().getBoolean(PrefKey.D_CONFIRM_REPLACE.toString());
        boolean bl2 = KeyUtil.hasMask((Event)event, (int)SWT.MOD2);
        boolean bl3 = !bl || bl2;
        return bl3;
    }

    public CopyMenuAction(ResourceBundle resourceBundle, String string, int n, DiffView diffView, boolean bl, boolean bl2) {
        super(resourceBundle, string, n, EnumSet.allOf(Addon.Edition.class), diffView);
        this.move = bl2;
        diffView.getControl().addListener(12, (Listener)this.listener);
        diffView.addSelectionChangedListener(this.listener);
    }

    private Role destination() {
        boolean bl;
        Role role = this.source();
        Role[] roleArray = CopyAction.getPossibleDestinations(role, bl = this.isLeft());
        if (roleArray.length > 0 && this.index < roleArray.length) {
            return roleArray[this.index];
        }
        roleArray = CopyAction.getPossibleDestinations(role, !bl);
        return roleArray[this.index];
    }

    public void dispose() {
        DiffView diffView = this.deltaView();
        diffView.removeSelectionChangedListener(this.listener);
        Control control = diffView.getControl();
        if (control != null && !control.isDisposed()) {
            control.removeListener(12, (Listener)this.listener);
        }
    }

    public String getText() {
        DiffView diffView = this.deltaView();
        Role role = this.source();
        Role role2 = this.destination();
        if (diffView.getInput() == null || role == null || role2 == null) {
            return super.getText();
        }
        boolean bl = diffView.getInput().docType(0) == DocType.TEXT;
        boolean bl2 = diffView.isThreeWay();
        String string = this.move ? (bl ? UIMsg.MoveAction_contents_label : UIMsg.MoveAction_selected_label) : (bl ? UIMsg.CopyAction_contents_label : UIMsg.CopyAction_selected_label);
        string = NLS.bind((String)string, (Object)role.getDisplayName(bl2), (Object)role2.getDisplayName(bl2));
        if (LOG.isDebugEnabled()) {
            LOG.debug(string);
        }
        return string;
    }

    public boolean isEnabled() {
        if (this.deltaView().docType() == DocType.IMAGE) {
            return false;
        }
        return super.isEnabled();
    }

    protected abstract boolean isLeft();

    public void runWithEvent(final Event event) {
        IDiffModel iDiffModel = this.deltaView().deltaModel();
        iDiffModel.copy(this.source(), this.destination(), this.move, new IReplaceable(){

            @Override
            public boolean shouldConfirm() {
                return CopyMenuAction.shouldConfirmReplace(event);
            }
        });
    }

    @Override
    public Role source() {
        DiffView diffView = this.deltaView();
        if (diffView != null) {
            boolean bl = diffView.isThreeWay();
            return bl ? diffView.getFocusRole() : (this.isLeft() ? Role.REF : Role.ONE);
        }
        assert (false);
        return Role.REF;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.move ? "Move" : "Copy");
        stringBuilder.append(this.isLeft() ? "MoveMenuAction" : "LeftMenuAction");
        stringBuilder.append(this.index);
        return stringBuilder.toString();
    }

    public void update() {
        Role role = this.source();
        if (role == null) {
            return;
        }
        Role role2 = this.destination();
        DiffView diffView = this.deltaView();
        boolean bl = diffView.isThreeWay();
        boolean bl2 = false;
        if (role != null) {
            if (diffView.isStructView()) {
                bl2 = CopyAction.shouldEnable((IStructDiffModel)diffView.deltaModel(), false, role, role2);
            } else {
                boolean bl3 = this.isLeft();
                if (bl) {
                    bl2 = role == Role.REF ? role2 == (bl3 ? Role.TWO : Role.ONE) : role == (bl3 ? Role.ONE : Role.TWO);
                } else if (role == Role.TWO || role2 == Role.TWO) {
                    bl2 = false;
                } else if (role == Role.REF && role2 == Role.ONE) {
                    bl2 = bl3;
                } else if (role == Role.ONE && role2 == Role.REF) {
                    boolean bl4 = bl2 = !bl3;
                }
                if (bl) {
                    boolean bl5 = bl2 = bl2 && diffView.canCopyFrom(this.move, role, role2);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("src=" + (Object)((Object)role) + " dst=" + (Object)((Object)role2) + " left=" + this.isLeft() + " threeWay=" + bl + " ENABLED=" + bl2);
        }
        this.setEnabled(bl2);
    }

    private class InternalListener
    implements ISelectionChangedListener,
    Listener {
        private InternalListener() {
        }

        public void handleEvent(Event event) {
            assert (event.type == 12);
            CopyMenuAction.this.dispose();
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            CopyMenuAction.this.update();
        }
    }
}

