/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.DiffModel;
import com.deltawalker.IStructElement;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IEditableStruct;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.actions.PartEventAction;
import com.deltopia.ui.swt.KeyUtil;
import com.deltopia.util.IDisposable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CopyAction
extends PartEventAction
implements IUpdate {
    private static final Role[] ALL_ROLES = new Role[]{Role.REF, Role.ONE, Role.TWO};
    private static final Logger LOG = LoggerFactory.getLogger(CopyAction.class);
    private static final Role[] NO_ROLES = new Role[0];
    private DiffView dView;
    protected IAction[] menuActions;
    private final ISelectionChangedListener onSelect = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            CopyAction.this.updateState();
        }
    };

    public static Role[] getPossibleDestinations(Role role, boolean bl) {
        if (role == null) {
            throw new NullPointerException("src");
        }
        if (role != Role.REF && (bl && role == Role.TWO || !bl && role == Role.ONE)) {
            return NO_ROLES;
        }
        Role[] roleArray = new Role[Role.count() - 1];
        int n = 0;
        Role[] roleArray2 = ALL_ROLES;
        int n2 = ALL_ROLES.length;
        int n3 = 0;
        while (n3 < n2) {
            Role role2 = roleArray2[n3];
            if (role != role2) {
                roleArray[n++] = role2;
            }
            ++n3;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("src=" + (Object)((Object)role) + " possible destinations=" + Arrays.asList(roleArray));
        }
        return roleArray;
    }

    public static boolean shouldEnable(IStructDiffModel iStructDiffModel, boolean bl, Role role, Role role2) {
        if (role == null || iStructDiffModel == null) {
            return false;
        }
        if (role2 != null && role2 == Role.TWO && !iStructDiffModel.isThreeWay()) {
            return false;
        }
        List<IDiffNode> list = iStructDiffModel.getSelected();
        for (IDiffNode iDiffNode : list) {
            IStructElement iStructElement;
            if (!(iDiffNode.getElement(role) instanceof IResource)) continue;
            IDiffNode iDiffNode2 = iDiffNode.getParent();
            if (bl) {
                iStructElement = iDiffNode2.getElement(role);
                try {
                    if (!(iStructElement instanceof IEditableStruct) || !(iStructElement instanceof IResource)) continue;
                    if (!((IResource)iStructElement).canEverWrite()) {
                    }
                }
                catch (IOException iOException) {}
                continue;
            }
            if (role2 != null) {
                while (iDiffNode2 != null) {
                    iStructElement = iDiffNode2.getElement(role2);
                    if (!DiffModel.isNullElement(iStructElement)) {
                        try {
                            return iStructElement instanceof IEditableStruct && iStructElement instanceof IResource && ((IResource)iStructElement).canEverWrite();
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }
                    iDiffNode2 = iDiffNode2.getParent();
                }
                continue;
            }
            return true;
        }
        return false;
    }

    public CopyAction(ResourceBundle resourceBundle, IWorkbenchWindow iWorkbenchWindow, boolean bl, String string) {
        super(DeltaWalkerPlugin.getPluginId(), resourceBundle, iWorkbenchWindow, string, 1);
    }

    @Override
    protected DiffView deltaView(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart != null) {
            return (DiffView)iWorkbenchPart.getAdapter(DiffView.class);
        }
        return null;
    }

    @Override
    public void dispose() {
        try {
            DiffView diffView = this.deltaView();
            if (diffView != null) {
                diffView.removeSelectionChangedListener(this.onSelect);
            }
            this.disposeMenuActions();
        }
        finally {
            super.dispose();
        }
    }

    private void disposeMenuActions() {
        if (this.menuActions != null) {
            try {
                IAction[] iActionArray = this.menuActions;
                int n = this.menuActions.length;
                int n2 = 0;
                while (n2 < n) {
                    IAction iAction = iActionArray[n2];
                    if (iAction instanceof IDisposable) {
                        ((IDisposable)iAction).dispose();
                    }
                    ++n2;
                }
            }
            finally {
                this.menuActions = null;
            }
        }
    }

    protected abstract IAction[] getMenuActions();

    public void runWithEvent(Event event) {
        IAction[] iActionArray;
        this.update();
        if (!this.isEnabled()) {
            return;
        }
        if (event.widget instanceof ToolItem) {
            event.stateMask = KeyUtil.getModifier((Widget)event.widget, (boolean)true);
        }
        if ((iActionArray = this.getMenuActions()) == null) {
            this.run();
        } else {
            IAction[] iActionArray2 = this.menuActions;
            int n = this.menuActions.length;
            int n2 = 0;
            while (n2 < n) {
                IAction iAction = iActionArray2[n2];
                if (iAction instanceof IUpdate) {
                    ((IUpdate)iAction).update();
                }
                if (iAction != null && iAction.isEnabled()) {
                    iAction.runWithEvent(event);
                    return;
                }
                ++n2;
            }
        }
    }

    public void setText(String string) {
        super.setText(string);
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
    }

    @Override
    public void update() {
        this.updateState();
    }

    @Override
    protected void updateState() {
        boolean bl = false;
        if (this.dView != null) {
            IAction[] iActionArray;
            IAction[] iActionArray2 = iActionArray = this.getMenuActions();
            int n = iActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAction iAction = iActionArray2[n2];
                if (iAction instanceof IUpdate) {
                    ((IUpdate)iAction).update();
                    if (iAction.isEnabled()) {
                        bl = true;
                        break;
                    }
                }
                ++n2;
            }
        }
        this.setEnabled(bl);
    }

    @Override
    protected void workbenchPartChanged(IWorkbenchPart iWorkbenchPart, IWorkbenchPart iWorkbenchPart2) {
        DiffView diffView = this.deltaView(iWorkbenchPart2);
        if (diffView != null) {
            diffView.removeSelectionChangedListener(this.onSelect);
        }
        this.disposeMenuActions();
        this.dView = this.deltaView(iWorkbenchPart);
        if (diffView != null) {
            diffView.removeSelectionChangedListener(this.onSelect);
        }
        this.updateState();
    }
}

