/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.App;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.ui.dialogs.DiffSummaryDialog;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.LicensedAction;
import com.deltawalker.ui.actions.PageSetupAction;
import com.deltawalker.ui.printing.HeaderFooterPrintOp;
import com.deltawalker.ui.printing.IPrinter;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.actions.ActionFactory;

public class CompareSummaryAction
extends LicensedAction {
    private DiffView dView;

    public CompareSummaryAction(ResourceBundle resourceBundle, DiffView diffView) {
        super(DeltaWalkerPlugin.getPluginId(), resourceBundle, "CompareSummaryAction.", 1);
        this.setId("compareSummary");
        this.setActionDefinitionId("com.deltawalker.ui.file.compareSummary");
        this.dView = diffView;
    }

    public void run() {
        DiffSummaryDialog diffSummaryDialog = new DiffSummaryDialog(this.dView.getControl().getShell()){
            private final IAction actPageSetup;
            private final IAction actPrint;
            private final IAction actPreview;
            {
                this.actPageSetup = new Action(){

                    public void run() {
                        PageSetupAction.run(actPrint, actPreview);
                    }
                };
                this.actPrint = new Action(){

                    public void run() {
                        this.runWithEvent(null);
                    }

                    public void runWithEvent(Event event) {
                        this.print(event);
                    }
                };
                this.actPreview = new Action(){

                    public void run() {
                        this.runWithEvent(null);
                    }

                    public void runWithEvent(Event event) {
                        this.printPreview(event);
                    }
                };
            }

            @Override
            protected IAction createButtonAction(int n) {
                switch (n) {
                    case 2: {
                        return this.actPageSetup;
                    }
                    case 4: {
                        IAction iAction = UIUtil.actionAdvisor().getAction(ActionFactory.PRINT.getId());
                        this.actPrint.setEnabled(iAction.isEnabled());
                        return this.actPrint;
                    }
                }
                return super.createButtonAction(n);
            }

            @Override
            protected HeaderFooterPrintOp createPrintOp(IPrinter iPrinter, IProgressMonitor iProgressMonitor) {
                HeaderFooterPrintOp headerFooterPrintOp = super.createPrintOp(iPrinter, iProgressMonitor);
                if (headerFooterPrintOp != null) {
                    CompareSummaryAction.this.dView.printFileTagValues(headerFooterPrintOp);
                }
                return headerFooterPrintOp;
            }

            private void print(Event event) {
                App.instance().printBoss().print(this, null, true);
            }

            private void printPreview(Event event) {
                App.instance().printBoss().printPreview(this, this.actPageSetup, this.actPrint);
            }
        };
        diffSummaryDialog.setDiffSummaryProvider(this.dView.deltaModel());
        diffSummaryDialog.open();
    }
}

