/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.Msg;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.ui.HistoryTree;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.CompareFilesAction;
import com.deltawalker.ui.actions.DropdownMenuAction;
import com.deltopia.io.FileType;
import com.deltopia.util.IDisposable;
import com.deltopia.util.OS;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;

public class CompareFoldersAction
extends DropdownMenuAction
implements ActionFactory.IWorkbenchAction,
IMenuListener2 {
    public static void compareFolders(IWorkbenchWindow iWorkbenchWindow) {
        UIUtil.closeIntro(iWorkbenchWindow);
        App.instance().viewBoss().showCompareView(null, null);
    }

    public static void hideCompareViews(IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null) {
            List<IViewReference> list = UIUtil.getCompareViewRefs(iWorkbenchWindow);
            int n = list.size();
            int n2 = bl ? 1 : 0;
            int n3 = n - 1;
            while (n3 >= n2) {
                iWorkbenchPage.hideView(list.get(n3));
                --n3;
            }
        }
    }

    public CompareFoldersAction(ResourceBundle resourceBundle, IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        super(DeltaWalkerPlugin.getPluginId(), resourceBundle, "CompareFoldersAction.", iWorkbenchWindow, true);
        if (bl) {
            this.setId("compareFoldersTB");
            this.setText(Msg.CompareFoldersAction_textToolBar);
            this.setImageDescriptor(ImageCache.getImageDescriptor(ImageConst.COMPARE_FOLDERS_32));
        } else {
            this.setId("compareFolders");
            this.setImageDescriptor(OS.OSX ? null : ImageCache.getImageDescriptor(ImageConst.COMPARE_FOLDERS));
        }
        this.setActionDefinitionId("com.deltawalker.ui.file.compareFolders");
    }

    @Override
    protected Control createControl(Composite composite) {
        return new HistoryTree(composite, 0, FileType.FOLDER, false);
    }

    @Override
    protected List<IAction> getMenuActions() {
        return Collections.emptyList();
    }

    public void menuAboutToHide(IMenuManager iMenuManager) {
        IContributionItem[] iContributionItemArray = iMenuManager.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            IContributionItem iContributionItem = iContributionItemArray[n];
            if (iContributionItem instanceof IDisposable) {
                ((IDisposable)iContributionItem).dispose();
            }
            ++n;
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        CompareFilesAction.addHistoryMenuItems(iMenuManager, (IAction)this, DocType.FOLDER);
    }

    public void run() {
        CompareFoldersAction.compareFolders(this.getWorkbenchWindow());
    }

    @Override
    protected void updateState() {
        this.setEnabled(true);
    }
}

