/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.Msg;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDocBoss;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.ui.HistoryTree;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.DropdownMenuAction;
import com.deltawalker.ui.actions.HistoryAction;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileType;
import com.deltopia.util.IDisposable;
import com.deltopia.util.OS;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.ResourceBundle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;

public class CompareFilesAction
extends DropdownMenuAction
implements ActionFactory.IWorkbenchAction,
IMenuListener2 {
    public static void addHistoryMenuItems(IMenuManager iMenuManager, final IAction iAction, DocType docType) {
        Action action = new Action(iAction.getText()){

            public void run() {
                iAction.run();
            }
        };
        action.setId(iAction.getId());
        action.setActionDefinitionId(iAction.getActionDefinitionId());
        action.setImageDescriptor(OS.OSX ? null : iAction.getImageDescriptor());
        iMenuManager.add((IAction)action);
        iMenuManager.add((IContributionItem)new Separator());
        IDocBoss iDocBoss = App.instance().docBoss();
        NavigableSet<IDiffDoc> navigableSet = iDocBoss.getAll(docType.fileType(), false);
        int n = 0;
        for (IDiffDoc iDiffDoc : navigableSet) {
            iMenuManager.add((IAction)new HistoryAction(iDiffDoc, n++));
        }
    }

    public static void compareFiles(IWorkbenchWindow iWorkbenchWindow) {
        UIUtil.closeIntro(iWorkbenchWindow);
        App.instance().viewBoss().openCompareEditor(ContentType.TEXT);
    }

    public CompareFilesAction(ResourceBundle resourceBundle, IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        super(DeltaWalkerPlugin.getPluginId(), resourceBundle, "CompareFilesAction.", iWorkbenchWindow, true);
        if (bl) {
            this.setId("compareFilesTB");
            this.setText(Msg.CompareFilesAction_textToolBar);
            this.setImageDescriptor(ImageCache.getImageDescriptor(ImageConst.COMPARE_FILES_32));
        } else {
            this.setId("compareFiles");
            this.setImageDescriptor(ImageCache.getImageDescriptor(ImageConst.COMPARE_FILES));
        }
        this.setActionDefinitionId("com.deltawalker.ui.file.compareFiles");
    }

    @Override
    protected Control createControl(Composite composite) {
        return new HistoryTree(composite, 0, FileType.FILE, false);
    }

    @Override
    protected List<IAction> getMenuActions() {
        return Collections.emptyList();
    }

    public void menuAboutToHide(IMenuManager iMenuManager) {
        IContributionItem[] iContributionItemArray;
        IContributionItem[] iContributionItemArray2 = iContributionItemArray = iMenuManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray2[n2];
            if (iContributionItem instanceof IDisposable) {
                ((IDisposable)iContributionItem).dispose();
            }
            ++n2;
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        CompareFilesAction.addHistoryMenuItems(iMenuManager, (IAction)this, DocType.TEXT);
    }

    public void run() {
        CompareFilesAction.compareFiles(this.getWorkbenchWindow());
    }

    @Override
    protected void updateState() {
        this.setEnabled(true);
    }
}

