/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.DiffDoc;
import com.deltawalker.DiffDocAdapter;
import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.interfaces.IDiffDocListener;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.actions.PartEventAction;
import java.util.ResourceBundle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class CompareAction
extends PartEventAction {
    private final IDiffDocListener onDiffDoc = new DiffDocAdapter(){

        @Override
        public void comparing() {
            CompareAction.this.setEnabled(false);
        }

        @Override
        public void done() {
            CompareAction.this.setEnabled(true);
        }
    };
    private final IPropertyChangeListener onProperty = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            if (string.equals("INPUT")) {
                Object object = propertyChangeEvent.getOldValue();
                if (object != null) {
                    ((DiffDoc)object).removeDiffDocListener(CompareAction.this.onDiffDoc);
                }
                DiffDoc diffDoc = (DiffDoc)propertyChangeEvent.getNewValue();
                diffDoc.addDiffDocListener(CompareAction.this.onDiffDoc);
                CompareAction.this.setEnabled(!diffDoc.isWorking());
            }
        }
    };
    private boolean toolbar;

    public CompareAction(ResourceBundle resourceBundle, IWorkbenchWindow iWorkbenchWindow, boolean bl) {
        super(DeltaWalkerPlugin.getPluginId(), resourceBundle, iWorkbenchWindow, "CompareAction.", 1);
        this.toolbar = bl;
        this.setId(bl ? "compareTB" : "compare");
        this.setActionDefinitionId("com.deltawalker.ui.file.compare");
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.toolbar) {
            return ImageCache.getImageDescriptor(ImageConst.COMPARE_32);
        }
        return super.getImageDescriptor();
    }

    @Override
    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        super.partActivated(iWorkbenchPart);
        this.updateEnabled(iWorkbenchPart);
    }

    @Override
    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        super.partDeactivated(iWorkbenchPart);
        this.updateEnabled(iWorkbenchPart);
    }

    public void run() {
        boolean bl;
        boolean bl2 = bl = this.deltaView(this.activePart()) != null;
        if (!bl) {
            this.setEnabled(false);
            return;
        }
        this.deltaView(this.activePart()).compare();
    }

    private void updateEnabled(IWorkbenchPart iWorkbenchPart) {
        DiffView diffView = this.deltaView(iWorkbenchPart);
        if (diffView != null) {
            this.setEnabled(!diffView.getInput().isWorking());
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    protected void workbenchPartChanged(IWorkbenchPart iWorkbenchPart, IWorkbenchPart iWorkbenchPart2) {
        DiffView diffView;
        if (iWorkbenchPart2 != null && (diffView = this.deltaView(iWorkbenchPart2)) != null) {
            diffView.removePropertyListener(this.onProperty);
            diffView.getInput().removeDiffDocListener(this.onDiffDoc);
        }
        if (iWorkbenchPart != null && (diffView = this.deltaView(iWorkbenchPart)) != null) {
            diffView.addPropertyListener(this.onProperty);
            diffView.getInput().addDiffDocListener(this.onDiffDoc);
        }
    }
}

