/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui.actions;

import com.deltawalker.App;
import com.deltawalker.Msg;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.ui.ClearHistoryDialog;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.ResourceAction;
import com.deltopia.io.FileType;
import com.deltopia.util.IDisposable;
import java.util.EnumSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class ClearHistoryAction
extends ResourceAction
implements IDisposable {
    private IWorkbenchWindow window;

    public static void clear(Shell shell) {
        ClearHistoryDialog clearHistoryDialog;
        if (shell == null) {
            shell = UIUtil.getActiveWindowShell();
        }
        if ((clearHistoryDialog = new ClearHistoryDialog(shell)).open() == 0) {
            IPreferenceStore iPreferenceStore = PrefUtil.getGlobalPrefs();
            EnumSet<FileType> enumSet = EnumSet.noneOf(FileType.class);
            if (iPreferenceStore.getBoolean(PrefKey.C_CLEAR_FILE_COMP_HISTORY.toString())) {
                enumSet.add(FileType.FILE);
            }
            if (iPreferenceStore.getBoolean(PrefKey.C_CLEAR_FOLDER_COMP_HISTORY.toString())) {
                enumSet.add(FileType.FOLDER);
            }
            boolean bl = iPreferenceStore.getBoolean(PrefKey.C_CLEAR_FAVORITES.toString());
            App.instance().docBoss().remove(enumSet, bl);
        }
    }

    public ClearHistoryAction(IWorkbenchWindow iWorkbenchWindow) {
        super(DeltaWalkerPlugin.getPluginId(), Msg.constructedKeyBundle(), "ClearHistoryAction.", 1);
        if (iWorkbenchWindow == null) {
            iWorkbenchWindow = UIUtil.getActiveWindow();
        }
        assert (iWorkbenchWindow != null);
        this.setId("clearHistory");
        this.window = iWorkbenchWindow;
    }

    public void dispose() {
        this.window = null;
    }

    public void run() {
        ClearHistoryAction.clear(this.window.getShell());
    }
}

