/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.App;
import com.deltawalker.DiffDoc;
import com.deltawalker.DocFactory;
import com.deltawalker.DocType;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.Relation;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.interfaces.IDocBoss;
import com.deltawalker.interfaces.IDocFactory;
import com.deltawalker.interfaces.IViewBoss;
import com.deltawalker.internal.script.ui.ScriptEditor;
import com.deltawalker.internal.ui.DocWorkbenchAdapter;
import com.deltawalker.internal.ui.WorkbenchPartAdapter;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.ui.Alerts;
import com.deltawalker.ui.CompareEditor;
import com.deltawalker.ui.CompareView;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.CompareFilesAction;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.interfaces.IMvcView;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileType;
import com.deltopia.ui.concurrency.GuiExecutor;
import java.io.IOException;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.AdaptableList;

public final class ViewBoss
extends Enum<ViewBoss>
implements IViewBoss {
    public static final /* enum */ ViewBoss INSTANCE = new ViewBoss();
    private static IDocBoss docBoss;
    private static final ExecutorService exec;
    private IWorkbenchPart activePart = null;
    private DiffView activeView;
    private int viewCounter = new Random().nextInt();
    private static final /* synthetic */ ViewBoss[] ENUM$VALUES;

    static {
        ENUM$VALUES = new ViewBoss[]{INSTANCE};
        docBoss = App.instance().docBoss();
        exec = Executors.newCachedThreadPool();
    }

    public static boolean alertResourceMismatch(final DiffView diffView, Map<Role, UriInfo> map) {
        final boolean[] blArray = new boolean[]{true};
        final LinkedList<String> linkedList = new LinkedList<String>();
        FileType fileType = null;
        Set<Role> set = Relation.roles(UriInfoUtil.isThreeWay(map));
        for (Role object2 : set) {
            UriInfo uriInfo = map.get((Object)object2);
            FileType fileType2 = uriInfo.fileType();
            if (uriInfo.isEmpty() || fileType2.isUnknown()) continue;
            if (fileType == null) {
                fileType = fileType2;
                linkedList.add(uriInfo.uri());
                continue;
            }
            if (fileType == fileType2) continue;
            blArray[0] = false;
            linkedList.add(uriInfo.uri());
            break;
        }
        final boolean[] blArray2 = new boolean[1];
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                DiffView diffView2 = diffView;
                if (diffView2 == null) {
                    diffView2 = ViewBoss.openEmptyTextDiffView();
                }
                if (!blArray[0] && linkedList.size() == 2) {
                    String string = NLS.bind((String)UIMsg.Alerts_resourceMismatch, linkedList.get(0), linkedList.get(1));
                    diffView2.controller().alerts().showResourceMismatch(true, string);
                    blArray2[0] = true;
                } else {
                    diffView2.controller().alerts().showResourceMismatch(false, null);
                }
            }
        });
        return blArray2[0];
    }

    private static DiffView openEmptyTextDiffView() {
        DiffView diffView = null;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        CompareFilesAction.compareFiles(iWorkbenchWindow);
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
        if (iWorkbenchPart instanceof CompareEditor) {
            diffView = ((CompareEditor)iWorkbenchPart).diffView(0);
        }
        return diffView;
    }

    @Override
    public DiffView activeDeltaView() {
        return this.activeView;
    }

    private boolean alertInvalidUris(DiffView diffView, Map<Role, UriInfo> map, IDiffDoc iDiffDoc) {
        boolean bl;
        boolean bl2 = bl = diffView != null ? diffView.isThreeWay() : false;
        if (!Alerts.hasInvalidUri(map, bl)) {
            return false;
        }
        if (diffView != null && !diffView.isDisposed()) {
            diffView.controller().alerts().alertForInvalidUris(map, iDiffDoc);
            diffView.uriChooserBoss().updateUriInfo(iDiffDoc);
            return true;
        }
        return false;
    }

    private boolean canReuseView(DocType docType, DocType docType2) {
        return docType == docType2;
    }

    @Override
    public DiffView createDocView(Map<Role, UriInfo> map, IPreferenceStore iPreferenceStore, UUID uUID, boolean bl, UriInfo uriInfo, boolean bl2, boolean bl3) {
        DiffView diffView = this.createMvc(map, iPreferenceStore, uUID, uriInfo, null, false, null, null, null, bl, bl3);
        return diffView;
    }

    private DiffView createMvc(final Map<Role, UriInfo> map, IPreferenceStore iPreferenceStore, UUID uUID, UriInfo uriInfo, DiffView diffView, boolean bl, UUID uUID2, Role role, Role role2, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        Object object3;
        long l;
        UIUtil.closeIntro(null);
        if (bl && !this.saveDirtyDocs(diffView.getInput().dirtyDocs(0), map)) {
            return diffView;
        }
        FileType fileType = UriInfoUtil.guessFileType(map);
        IDiffDoc iDiffDoc = docBoss.get(uUID2);
        String string = iDiffDoc != null ? iDiffDoc.getName() : "";
        long l2 = iDiffDoc != null ? iDiffDoc.getTimeCreated() : System.currentTimeMillis();
        long l3 = l = iDiffDoc != null ? iDiffDoc.getTimeLastOpened() : System.currentTimeMillis();
        if (fileType.isUnknown() && iDiffDoc != null) {
            fileType = iDiffDoc.fileType();
        }
        if (fileType.isUnknown() && diffView != null) {
            object3 = diffView.model().docType(0);
            fileType = ((DocType)((Object)object3)).fileType();
        }
        if (diffView == null) {
            object3 = ContentType.TEXT;
            if (iDiffDoc != null) {
                object3 = iDiffDoc.contentType();
            }
            DiffView diffView2 = diffView = fileType.isFolder() ? this.showCompareView(null, null) : this.openCompareEditor(iDiffDoc, (ContentType)object3);
            if (iDiffDoc != null) {
                object2 = diffView.getInput();
                object2.setId(iDiffDoc.getId());
                object2.setFiltersId(iDiffDoc.getFiltersId());
                object2.setHistoryEntry(iDiffDoc.getHistoryEntry());
                object2.setSync2WayOp(iDiffDoc.getSync2WayOp());
                iDiffDoc.setFiltersId(null);
                iDiffDoc.dispose();
            }
        }
        object3 = fileType;
        object2 = diffView;
        UriInfoUtil.makeUriInfosSafe(map, (FileType)object3);
        UriInfoUtil.replaceDisplayWithEmptyUris(map);
        if (UriInfoUtil.isEmpty(map)) {
            return null;
        }
        if (UriInfoUtil.hasError(map)) {
            this.alertInvalidUris(diffView, map, diffView.getInput());
        }
        if (role != null && role2 != null) {
            object = map.get((Object)role);
            map.put(role, map.get((Object)role2));
            map.put(role2, (UriInfo)object);
        }
        if (iPreferenceStore == null) {
            iPreferenceStore = PrefUtil.createSessionPrefs();
        }
        object = iPreferenceStore;
        final boolean bl4 = iPreferenceStore.getBoolean(PrefKey.C_FOLLOW_SYMLINKS.toString());
        Display display = Display.getCurrent();
        IDiffDoc[] iDiffDocArray = new DiffDoc[1];
        final IResource[] iResourceArray = new IResource[Role.count()];
        exec.execute(new Runnable((FileType)object3, (DiffView)object2, bl2, (IPreferenceStore)object, uUID, string, uriInfo, l2, l, iDiffDocArray, bl3, display){
            private final /* synthetic */ FileType val$fType;
            private final /* synthetic */ DiffView val$view;
            private final /* synthetic */ boolean val$force3Way;
            private final /* synthetic */ IPreferenceStore val$prefs;
            private final /* synthetic */ UUID val$filtersId;
            private final /* synthetic */ String val$name;
            private final /* synthetic */ UriInfo val$mergedUri;
            private final /* synthetic */ long val$timeCreated;
            private final /* synthetic */ long val$timeOpened;
            private final /* synthetic */ IDiffDoc[] val$input;
            private final /* synthetic */ boolean val$saveState;
            private final /* synthetic */ Display val$display;
            {
                this.val$fType = fileType;
                this.val$view = diffView;
                this.val$force3Way = bl2;
                this.val$prefs = iPreferenceStore;
                this.val$filtersId = uUID;
                this.val$name = string;
                this.val$mergedUri = uriInfo;
                this.val$timeCreated = l;
                this.val$timeOpened = l2;
                this.val$input = iDiffDocArray;
                this.val$saveState = bl3;
                this.val$display = display;
            }

            @Override
            public void run() {
                IDocFactory[] iDocFactoryArray;
                UriInfo exception;
                for (Map.Entry iDocFactoryArray2 : map.entrySet()) {
                    exception = (UriInfo)iDocFactoryArray2.getValue();
                    try {
                        exception.allowSecureAccess(true);
                    }
                    catch (IOException iDiffDoc) {
                        iDocFactoryArray2.setValue(exception.cloneUpdateError(iDiffDoc));
                    }
                }
                try {
                    iDocFactoryArray = DocFactory.getFactories(map, iResourceArray, bl4, this.val$fType);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    throw new RuntimeException(exception2);
                }
                if (ViewBoss.alertResourceMismatch(this.val$view, map)) {
                    return;
                }
                exception = UriInfoUtil.guessContentType(map);
                if (exception.isUnknown()) {
                    exception = this.val$fType == FileType.FOLDER ? ContentType.FOLDER : ContentType.TEXT;
                }
                IDiffDoc iDiffDoc = this.val$view.getInput();
                boolean bl = this.val$force3Way;
                if (map.size() == 3) {
                    bl = UriInfoUtil.isThreeWay(map);
                }
                DiffDoc.Builder builder = new DiffDoc.Builder().contentType((ContentType)exception).docFactories(iDocFactoryArray).resources(iResourceArray).uriInfos(map).prefs(this.val$prefs).filtersId(this.val$filtersId).id(iDiffDoc.getId()).name(this.val$name).force3Way(bl).mergedUI(this.val$mergedUri).timeCreated(this.val$timeCreated).timeOpened(this.val$timeOpened).historyEntry(iDiffDoc.getHistoryEntry()).sync2WayOp(iDiffDoc.getSync2WayOp());
                this.val$input[0] = docBoss.create(builder, this.val$saveState);
                if (iDiffDoc.isEmpty()) {
                    docBoss.remove(iDiffDoc);
                }
                if (!this.val$display.isDisposed()) {
                    this.val$display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!val$display.isDisposed()) {
                                ViewBoss.this.createVC(val$view, val$fType, val$input[0], map);
                            }
                        }
                    });
                }
            }
        });
        return object2;
    }

    private void createVC(DiffView diffView, FileType fileType, IDiffDoc iDiffDoc, Map<Role, UriInfo> map) {
        DocType docType;
        DocType docType2 = docType = iDiffDoc.triadCount() > 0 ? iDiffDoc.docType(0) : null;
        if (docType == null && fileType != FileType.UNKNOWN) {
            DocType docType3 = docType = fileType == FileType.FOLDER ? DocType.FOLDER : DocType.TEXT;
        }
        if (docType.isStructure()) {
            diffView = this.showCompareView(iDiffDoc, diffView.isStructView() ? diffView : null);
        } else {
            IEditorPart iEditorPart = this.openCompareEditor(iDiffDoc, diffView);
            diffView = ((CompareEditor)iEditorPart).diffView(0);
        }
        this.alertInvalidUris(diffView, map, iDiffDoc);
    }

    @Override
    public IWorkbenchPart getActiveWorkbenchPart() {
        return this.activePart;
    }

    @Override
    public DiffView openCompareEditor(ContentType contentType) {
        IEditorPart iEditorPart = this.openCompareEditor(docBoss.create(contentType), (DiffView)null);
        DiffView diffView = (DiffView)((CompareEditor)iEditorPart).viewHolder().view(0, true);
        return diffView;
    }

    public DiffView openCompareEditor(IDiffDoc iDiffDoc, ContentType contentType) {
        EnumMap<Role, String> enumMap = new EnumMap(Role.class);
        if (iDiffDoc != null) {
            enumMap = DiffDoc.getFileExtensions(iDiffDoc.uriInfos());
        }
        IEditorPart iEditorPart = this.openCompareEditor(docBoss.create(contentType, enumMap), (DiffView)null);
        DiffView diffView = (DiffView)((CompareEditor)iEditorPart).viewHolder().view(0, true);
        return diffView;
    }

    @Override
    public IEditorPart openCompareEditor(IDiffDoc iDiffDoc, DiffView diffView) {
        if (iDiffDoc == null) {
            throw new NullPointerException("dDoc");
        }
        try {
            IWorkbenchPage iWorkbenchPage = UIUtil.getActiveWindow().getActivePage();
            IWorkbenchPart iWorkbenchPart = null;
            if (diffView != null) {
                iWorkbenchPart = UIUtil.workbenchPartFromDiffView(diffView, false, null);
                if (this.canReuseView(diffView.getInput().docType(), iDiffDoc.docType()) && iWorkbenchPart instanceof CompareEditor) {
                    CompareEditor compareEditor = (CompareEditor)iWorkbenchPart;
                    IDiffDoc iDiffDoc2 = (IDiffDoc)compareEditor.getEditorInput();
                    compareEditor.setInput((IEditorInput)iDiffDoc);
                    iDiffDoc2.dispose();
                    compareEditor.setFocus();
                    return compareEditor;
                }
            }
            IEditorPart iEditorPart = iWorkbenchPage.openEditor((IEditorInput)iDiffDoc, CompareEditor.ID);
            if (iWorkbenchPage != null && iWorkbenchPart != null) {
                iWorkbenchPage.closeEditor((IEditorPart)iWorkbenchPart, true);
            }
            return iEditorPart;
        }
        catch (PartInitException partInitException) {
            ErrorDialog.openError(null, null, (String)UIMsg.MvcBoss_errOpenFileComparison, (IStatus)partInitException.getStatus());
            return null;
        }
    }

    @Override
    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this.activePart) {
            this.activePart = null;
            this.activeView = null;
        }
        boolean bl = false;
        WorkbenchPartAdapter workbenchPartAdapter = (WorkbenchPartAdapter)iWorkbenchPart.getAdapter(WorkbenchPartAdapter.class);
        if (workbenchPartAdapter != null) {
            IMvcView[] iMvcViewArray;
            IDiffDoc iDiffDoc = workbenchPartAdapter.deltaDoc();
            iDiffDoc.setHasOpenView(false);
            bl = true;
            if (iDiffDoc.isEmpty()) {
                docBoss.remove(iDiffDoc);
            }
            IMvcView[] iMvcViewArray2 = iMvcViewArray = workbenchPartAdapter.viewHolder().views(false);
            int n = iMvcViewArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMvcView iMvcView = iMvcViewArray2[n2];
                iMvcView.dispose();
                ++n2;
            }
        }
        if (iWorkbenchPart instanceof ScriptEditor) {
            ((ScriptEditor)iWorkbenchPart).getEditorInput().setHasOpenView(false);
            bl = true;
        }
        if (bl) {
            App.instance().stateBoss().saveState();
        }
    }

    @Override
    public boolean saveDirtyDocs(Map<Role, IDoc> map, Map<Role, UriInfo> map2) {
        AdaptableList adaptableList = new AdaptableList();
        Vector<Role> vector = new Vector<Role>(Role.count());
        for (Map.Entry<Role, IDoc> entry : map.entrySet()) {
            adaptableList.add((IAdaptable)new DocWorkbenchAdapter((IMvcModel)entry.getValue()));
            vector.add(entry.getKey());
        }
        boolean bl = DiffDoc.saveDirtyDocs(adaptableList);
        if (bl) {
            for (Role role : vector) {
                map2.put(role, map2.get((Object)role).cloneUpdateError(null));
            }
        }
        return bl;
    }

    @Override
    public void setActiveWorkbenchPart(IWorkbenchPart iWorkbenchPart) {
        WorkbenchPartAdapter workbenchPartAdapter;
        if (iWorkbenchPart != null && (workbenchPartAdapter = (WorkbenchPartAdapter)iWorkbenchPart.getAdapter(WorkbenchPartAdapter.class)) != null) {
            this.activePart = iWorkbenchPart;
            DiffView diffView = (DiffView)workbenchPartAdapter.viewHolder().view(0, false);
            assert (diffView != null);
            if (diffView != null) {
                this.activeView = diffView;
                long l = System.currentTimeMillis();
                diffView.getInput().setTimeLastOpened(l);
            }
        }
    }

    @Override
    public DiffView showCompareView(IDiffDoc iDiffDoc, DiffView diffView) {
        try {
            Object object;
            IWorkbenchPart iWorkbenchPart = null;
            if (diffView == null) {
                object = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                String string = Integer.toString(this.viewCounter++);
                iWorkbenchPart = object.showView(CompareView.ID, string, 1);
            } else {
                iWorkbenchPart = UIUtil.workbenchPartFromDiffView(diffView, true, null);
            }
            if (iWorkbenchPart != null) {
                object = (WorkbenchPartAdapter)iWorkbenchPart.getAdapter(WorkbenchPartAdapter.class);
                if (iDiffDoc != null) {
                    ((WorkbenchPartAdapter)object).init(null, (IEditorInput)iDiffDoc);
                }
                ((WorkbenchPartAdapter)object).setFocus();
                if (diffView == null) {
                    diffView = (DiffView)((WorkbenchPartAdapter)object).viewHolder().view(0, true);
                }
            }
            return diffView;
        }
        catch (PartInitException partInitException) {
            ErrorDialog.openError(null, null, (String)UIMsg.MvcBoss_errOpenFolderComparison, (IStatus)partInitException.getStatus());
            return null;
        }
    }

    @Override
    public void viewDoc(final DiffView diffView, final boolean bl, final Role role, final Role role2, final boolean bl2, final boolean bl3) {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                Map<Role, UriInfo> map = diffView.uriChooserBoss().uriInfos();
                IDiffDoc iDiffDoc = diffView.getInput();
                ViewBoss.this.createMvc(map, iDiffDoc.preferences(), iDiffDoc.getFiltersId(), new UriInfo(), diffView, bl, iDiffDoc.getId(), role, role2, bl2, bl3);
            }
        });
    }

    @Override
    public void viewDoc(final IDiffDoc iDiffDoc, final boolean bl) {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                ViewBoss.this.createMvc(iDiffDoc.uriInfos(), iDiffDoc.preferences(), iDiffDoc.getFiltersId(), iDiffDoc.mergedUriInfo(), null, false, iDiffDoc.getId(), null, null, false, bl);
            }
        });
    }

    @Override
    public List<DiffView> viewsOnDoc(UUID uUID) {
        IEditorPart iEditorPart2;
        LinkedList<DiffView> linkedList = new LinkedList<DiffView>();
        List<IEditorPart> list = UIUtil.getAllCompareEditors();
        for (IEditorPart iEditorPart2 : list) {
            IDiffDoc iDiffDoc = ((CompareEditor)iEditorPart2).diffDoc();
            if (uUID != iDiffDoc.getId()) continue;
            linkedList.add(((CompareEditor)iEditorPart2).diffView(0));
        }
        iEditorPart2 = UIUtil.getAllCompareViews();
        for (IViewPart iViewPart : iEditorPart2) {
            IDiffDoc iDiffDoc = ((CompareView)iViewPart).diffDoc();
            if (uUID != iDiffDoc.getId()) continue;
            linkedList.add(((CompareView)iViewPart).diffView(0));
        }
        return linkedList;
    }

    public static ViewBoss[] values() {
        ViewBoss[] viewBossArray = ENUM$VALUES;
        int n = viewBossArray.length;
        ViewBoss[] viewBossArray2 = new ViewBoss[n];
        System.arraycopy(ENUM$VALUES, 0, viewBossArray2, 0, n);
        return viewBossArray2;
    }

    public static ViewBoss valueOf(String string) {
        return Enum.valueOf(ViewBoss.class, string);
    }
}

