/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.ui;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.Relation;
import com.deltawalker.UriInfo;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.IDiffViewContentProvider;
import com.deltawalker.ui.UriChooser;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

public class UriChooserBoss {
    private static final String _PREFIX = UriChooserBoss.class.getName();
    private static final String OLD_CHOOSER_BG = String.valueOf(_PREFIX) + ".oldChooserBg ";
    private Map<Role, UriChooser> choosers = new EnumMap<Role, UriChooser>(Role.class);
    private final DiffView dView;
    private boolean inUpdate = false;
    private final FocusListener onFocus = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            UriChooserBoss.this.updateFocusBackground();
        }

        public void focusLost(FocusEvent focusEvent) {
            UriChooserBoss.this.updateFocusBackground();
        }
    };
    private ModifyListener onModify = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            int n;
            if (UriChooserBoss.this.dView.getInput().isWorking()) {
                return;
            }
            UriChooser uriChooser = (UriChooser)modifyEvent.widget;
            int n2 = uriChooser.getSelectionIndex();
            if (n2 >= (n = App.instance().docBoss().uriCount(uriChooser.type()))) {
                return;
            }
            boolean bl = modifyEvent.data instanceof Boolean ? (Boolean)modifyEvent.data : false;
            App.instance().viewBoss().viewDoc(UriChooserBoss.this.dView, false, null, null, bl, true);
        }
    };
    private SelectionListener onSelect = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            UriChooser uriChooser = (UriChooser)selectionEvent.widget;
            if (!uriChooser.hasEntryMask(SWT.MOD1, true)) {
                return;
            }
            int n = uriChooser.getSelectionIndex();
            Role[] roleArray = Role.values();
            int n2 = roleArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Role role = roleArray[n3];
                UriChooser uriChooser2 = UriChooserBoss.this.uriChooser(role);
                if (uriChooser2 != uriChooser) {
                    UriInfo uriInfo = uriChooser2.getHistoryItem(n);
                    if (!$assertionsDisabled && uriInfo.uri() == null) {
                        throw new AssertionError((Object)(String.valueOf(_PREFIX) + ": Combo's history entries corrupted!"));
                    }
                    uriChooser2.updateUriInfo(uriInfo, true, false, false);
                    UriChooserBoss.this.dView.viewHolder().activate(0);
                }
                ++n3;
            }
        }
    };
    private VerifyListener onVerify = new VerifyListener(){

        public void verifyText(VerifyEvent verifyEvent) {
            Map<Role, UriInfo> map = UriChooserBoss.this.uriInfos();
            if (!App.instance().viewBoss().saveDirtyDocs(UriChooserBoss.this.dView.getInput().dirtyDocs(0), map)) {
                verifyEvent.doit = false;
                return;
            }
        }
    };

    public UriChooserBoss(DiffView diffView) {
        this.dView = diffView;
    }

    public void clearUriInfo(Role role) {
        this.choosers.get((Object)role).updateUriInfo(this.dView.getInput().triad(0).get((Object)role));
    }

    protected UriChooser createUriChooser(Composite composite, Role role, TraverseListener traverseListener) {
        UriChooser uriChooser = this.dView.createUriChooser(composite, role);
        IDoc iDoc = this.dView.doc(Role.ONE);
        if (iDoc.docType() != DocType.PREVIEW) {
            uriChooser.addTraverseListener(traverseListener);
            uriChooser.setData(OLD_CHOOSER_BG, uriChooser.getBackground());
        }
        return uriChooser;
    }

    public void createUriChoosers(Composite composite) {
        TraverseListener traverseListener = this.dView.getTraverseListener();
        for (Role role : Relation.roles(true)) {
            this.choosers.put(role, this.createUriChooser(composite, role, traverseListener));
        }
    }

    public void dispose() {
        this.installListeners(false);
        Iterator<Map.Entry<Role, UriChooser>> iterator = this.choosers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Role, UriChooser> entry = iterator.next();
            entry.getValue().dispose();
            iterator.remove();
        }
    }

    private void doUpdate() {
        IDiffViewContentProvider iDiffViewContentProvider = (IDiffViewContentProvider)this.dView.getContentProvider();
        IDiffDoc iDiffDoc = this.dView.getInput();
        for (Role role : Relation.roles(true)) {
            UriChooser uriChooser = this.uriChooser(role);
            if (uriChooser == null) continue;
            uriChooser.setImage(iDiffViewContentProvider.getImage(iDiffDoc, role));
            IDoc iDoc = iDiffDoc.doc(0, role);
            uriChooser.updateUriInfo(iDoc);
        }
    }

    public void installListeners(boolean bl) {
        for (UriChooser uriChooser : this.choosers.values()) {
            if (bl) {
                uriChooser.addModifyListener(this.onModify);
                uriChooser.addSelectionListener(this.onSelect);
                uriChooser.addVerifyListener(this.onVerify);
                uriChooser.addFocusListener(this.onFocus);
                continue;
            }
            uriChooser.removeModifyListener(this.onModify);
            uriChooser.removeSelectionListener(this.onSelect);
            uriChooser.removeVerifyListener(this.onVerify);
            uriChooser.removeFocusListener(this.onFocus);
        }
        if (bl) {
            this.dView.addFocusListener(this.onFocus);
        } else {
            this.dView.removeFocusListener(this.onFocus);
        }
    }

    public void update() {
        if (!this.inUpdate) {
            this.inUpdate = true;
            try {
                this.doUpdate();
            }
            finally {
                this.inUpdate = false;
            }
        }
    }

    private void updateFocusBackground() {
        Role role = this.dView.getFocusRole();
        for (Role object : this.dView.roles()) {
            UriChooser uriChooser;
            Color color;
            if (object.equals((Object)role) || (color = (Color)(uriChooser = this.uriChooser(object)).getData(OLD_CHOOSER_BG)) == null) continue;
            uriChooser.setBackground(color);
        }
        if (role != null) {
            Color color = DeltaColor.getFocusBackground();
            this.uriChooser(role).setBackground(color);
        }
    }

    public void updateUriInfo(IDiffDoc iDiffDoc) {
        Map<Role, IDoc> map = iDiffDoc.triad(0);
        for (Map.Entry<Role, IDoc> entry : map.entrySet()) {
            Role role = entry.getKey();
            IDoc iDoc = entry.getValue();
            this.choosers.get((Object)role).updateUriInfo(iDoc);
        }
    }

    public void updateUriInfo(Map<Role, UriInfo> map) {
        for (Role role : this.choosers.keySet()) {
            this.choosers.get((Object)role).updateUriInfo(map.get((Object)role), false, false, false);
        }
    }

    public UriChooser uriChooser(Role role) {
        return this.choosers.get((Object)role);
    }

    public Map<Role, UriChooser> uriChoosers() {
        return this.choosers;
    }

    public Map<Role, UriInfo> uriInfos() {
        EnumMap<Role, UriInfo> enumMap = new EnumMap<Role, UriInfo>(Role.class);
        for (Role role : this.choosers.keySet()) {
            enumMap.put(role, this.choosers.get((Object)role).uriInfo());
        }
        return enumMap;
    }
}

